/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.SystemFilePaths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;

public class AuditUtil {
    private static FilePath auditHomePath;
    private static SimpleDateFormat timestampFormat;

    public static void audit(String auditName, BHost auditHost, Type editorType, BComponent oldValue, BComponent newValue) throws Exception {
        AuditUtil.audit(auditName, auditHost, editorType.toString(), oldValue, newValue);
    }

    public static void audit(String auditName, BHost auditHost, String editor, BComponent oldValue, BComponent newValue) throws Exception {
        BFolder auditData = new BFolder();
        if (auditHost != null) {
            auditData.add("host", (BValue)BString.make((String)auditHost.getNavDisplayName(null)), 1);
        }
        auditData.add("editor", (BValue)BString.make((String)editor), 1);
        auditData.add("modTime", (BValue)BAbsTime.make(), 1);
        auditData.add("priorValue", oldValue.newCopy(), 1);
        auditData.add("newValue", newValue.newCopy(), 1);
        BIFile auditFile = BFileSystem.INSTANCE.findFile(AuditUtil.getAuditHomePath().merge(auditName + ".bog"));
        BFolder auditComp = new BFolder();
        if (auditFile == null) {
            auditFile = BFileSystem.INSTANCE.makeFile(AuditUtil.getAuditHomePath().merge(auditName + ".bog"));
        } else {
            auditComp = (BFolder)new ValueDocDecoder(auditFile).decodeDocument(true);
        }
        auditComp.add(timestampFormat.format(new Date()), (BValue)auditData);
        ValueDocEncoder enc = new ValueDocEncoder(auditFile.getOutputStream());
        enc.setEncodeTransients(true);
        enc.encodeDocument((BValue)auditComp);
    }

    private static FilePath getAuditHomePath() {
        if (auditHomePath == null) {
            auditHomePath = SystemFilePaths.getPlatformAuditDirPath();
        }
        return auditHomePath;
    }

    static {
        timestampFormat = new SimpleDateFormat("'d'yyyyMMddkkmmss");
    }

    public static class ViewAuditCommand
    extends Command {
        private BWbShell wbShell;
        private String auditName;

        public ViewAuditCommand(String pauditName, BWidget pOwner) {
            super(pOwner, Sys.loadModule((String)"platform"), "AuditUtil.command");
            this.setEnabled(false);
            if (pOwner.getShell() instanceof BWbShell) {
                this.wbShell = (BWbShell)pOwner.getShell();
            }
            this.auditName = pauditName;
        }

        public boolean auditFileExists() {
            return BFileSystem.INSTANCE.findFile(AuditUtil.getAuditHomePath().merge(this.auditName + ".bog")) != null;
        }

        public CommandArtifact doInvoke() {
            if (this.wbShell != null) {
                this.wbShell.hyperlink(BOrd.make((String)("local:|" + AuditUtil.getAuditHomePath().merge(this.auditName + ".bog") + "|bog:|slot:/|view:workbench:PropertySheet")));
            }
            return null;
        }
    }
}

