/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.ntp;

import com.tridium.platform.ntp.BNtpServer;
import com.tridium.platform.ntp.BNtpServerVector;
import com.tridium.platform.ui.ntp.BNtpServerFE;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleFocusChange", parameterType="BFocusEvent", defaultValue="new BFocusEvent()", flags=4), @NiagaraAction(name="setEnabledStates", flags=4)})
public class BNtpServerVectorFE
extends BWbFieldEditor {
    @Generated
    public static final Action handleFocusChange = BNtpServerVectorFE.newAction((int)4, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action setEnabledStates = BNtpServerVectorFE.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNtpServerVectorFE.class);
    boolean readonlyInitialized;
    private BNtpServerFE feFactory;
    private BNtpServerVector vector;
    private BWidget header;
    private final BGridPane contentPane;
    private BWbFieldEditor focusedEditor;
    private final Command addCommand;
    private final Command deleteCommand;
    private final Command upCommand;
    private final Command downCommand;
    private static final Logger log = Logger.getLogger("platform");

    @Generated
    public void handleFocusChange(BFocusEvent parameter) {
        this.invoke(handleFocusChange, (BValue)parameter, null);
    }

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNtpServerVectorFE() {
        this(null);
    }

    public BNtpServerVectorFE(Type elementFeType) {
        if (elementFeType != null) {
            this.feFactory = (BNtpServerFE)elementFeType.getInstance();
        }
        BFlowPane toolbarPane = new BFlowPane(BHalign.center);
        BToolBar toolbar = new BToolBar();
        toolbarPane.add(null, (BValue)toolbar, null);
        this.addCommand = new AddCommand();
        BButton button = new BButton(this.addCommand);
        toolbar.add("add", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.deleteCommand = new DeleteCommand();
        button = new BButton(this.deleteCommand);
        toolbar.add("delete", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.upCommand = new UpCommand();
        button = new BButton(this.upCommand);
        toolbar.add("up", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        this.downCommand = new DownCommand();
        button = new BButton(this.downCommand);
        toolbar.add("down", (BValue)button, null);
        button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane outerGrid = new BGridPane(1);
        this.contentPane = new BGridPane(1);
        outerGrid.add(null, (BValue)this.contentPane);
        outerGrid.add(null, (BValue)toolbarPane);
        outerGrid.setHalign(BHalign.left);
        outerGrid.setColumnAlign(BHalign.center);
        this.setContent((BWidget)outerGrid);
    }

    public void doValidate(Context cx) throws Exception {
        BWidget[] children = this.contentPane.getChildWidgets();
        int firstChild = this.header == null ? 0 : 1;
        HashSet<String> propNames = new HashSet<String>();
        for (int i = firstChild; i < children.length; ++i) {
            BNtpServerFE fe = (BNtpServerFE)children[i];
            fe.doValidate(cx);
            String propName = fe.getServerPropertyName(cx);
            if (propNames.contains(propName)) {
                throw new LocalizableRuntimeException("platform", "NtpServerVectorFE.duplicateServer");
            }
            propNames.add(propName);
        }
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BComplex parent;
        this.vector = (BNtpServerVector)value;
        this.vector.lease(Integer.MAX_VALUE);
        if (cx != null && cx.getFacet("fieldEditor") != null) {
            this.feFactory = (BNtpServerFE)BTypeSpec.make((String)cx.getFacet("fieldEditor").toString()).getInstance();
        }
        if (!this.readonlyInitialized && (parent = this.vector.getParent()) != null) {
            this.setReadonly((parent.loadSlots().getFlags((Slot)this.vector.getPropertyInParent()) & 1) > 0);
        }
        this.contentPane.removeAll();
        this.header = this.getFeFactory().makeHeader();
        if (this.header != null) {
            this.contentPane.add(null, (BValue)this.header, 0);
        }
        SlotCursor c = this.vector.loadSlots().getProperties();
        while (c.next(BNtpServer.class)) {
            this.addElement((BNtpServer)c.get());
        }
        this.setEnabledStates();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BNtpServerVector vector = (BNtpServerVector)value;
        vector.lease();
        vector.removeAll();
        if (vector.getSlotCount() > 0) {
            throw new Exception("Failed to remove NTP slots");
        }
        BWidget[] children = this.contentPane.getChildWidgets();
        int firstChild = this.header == null ? 0 : 1;
        String[] serverStrings = new String[children.length - firstChild];
        for (int i = firstChild; i < children.length; ++i) {
            BNtpServer fieldValue = (BNtpServer)((BWbFieldEditor)children[i]).saveValue(cx);
            serverStrings[i - firstChild] = fieldValue.getServerString();
        }
        vector.sync(serverStrings);
        return vector;
    }

    protected void doSetReadonly(boolean readonly) {
        int firstChild;
        this.readonlyInitialized = true;
        super.doSetReadonly(readonly);
        this.deleteCommand.setEnabled(!readonly && this.focusedEditor != null);
        this.addCommand.setEnabled(!readonly);
        BWidget[] children = this.contentPane.getChildWidgets();
        for (int i = firstChild = this.header == null ? 0 : 1; i < children.length; ++i) {
            ((BWbFieldEditor)children[i]).setReadonly(readonly);
        }
    }

    protected BNtpServerFE getFeFactory() {
        if (this.feFactory == null) {
            this.feFactory = (BNtpServerFE)Sys.getRegistry().getAgents(this.vector.getElementType()).filter(AgentFilter.is((Type)BNtpServerFE.TYPE)).getDefault().getInstance();
        }
        return this.feFactory;
    }

    public void addElement(BNtpServer value) {
        BNtpServerFE editor = (BNtpServerFE)this.getFeFactory().getType().getInstance();
        if (this.header != null) {
            editor.useHeader(this.header);
        }
        if (value != null) {
            editor.loadValue((BObject)value);
        }
        this.contentPane.add(null, (BValue)editor, 0);
        editor.setReadonly(this.isReadonly());
        this.getContent().relayout();
        this.getContent().computePreferredSize();
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.focusEvent, (Slot)handleFocusChange);
        this.linkTo(null, (BComponent)editor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
        this.setModified();
    }

    public void doHandleFocusChange(BFocusEvent evt) {
        try {
            if (this.isReadonly()) {
                return;
            }
            if (evt.getId() == 1005) {
                if (this.focusedEditor == evt.getWidget()) {
                    this.focusedEditor = null;
                }
            } else if (evt.getId() == 1004) {
                this.focusedEditor = (BWbFieldEditor)evt.getWidget();
            }
            this.setArrowCommandEnabledStates();
            this.deleteCommand.setEnabled(this.focusedEditor != null);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception occurred while handling focus change", e);
        }
    }

    public void doSetEnabledStates() {
        this.addCommand.setEnabled(!this.isReadonly());
    }

    public static Property[] getDynamicPropertiesArray(BObject obj, boolean autoLoad) {
        if (autoLoad) {
            obj.asComplex().loadSlots();
        }
        Property[] allProps = obj.asComplex().getPropertiesArray();
        for (int i = 0; i < allProps.length; ++i) {
            if (allProps[i].isFrozen()) continue;
            Property[] result = new Property[allProps.length - i];
            System.arraycopy(allProps, i, result, 0, result.length);
            return result;
        }
        return new Property[0];
    }

    private void setArrowCommandEnabledStates() {
        BWidget[] children = this.contentPane.getChildWidgets();
        if (children.length > 1 && this.focusedEditor != null) {
            int firstChild = this.header == null ? 0 : 1;
            this.upCommand.setEnabled(children[firstChild] != this.focusedEditor);
            this.downCommand.setEnabled(children[children.length - 1] != this.focusedEditor);
        } else {
            this.upCommand.setEnabled(false);
            this.downCommand.setEnabled(false);
        }
    }

    private class DownCommand
    extends Command {
        public DownCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowDown.png")), null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] props = BNtpServerVectorFE.getDynamicPropertiesArray((BObject)BNtpServerVectorFE.this.contentPane, true);
                for (int i = 0; i < props.length; ++i) {
                    if (BNtpServerVectorFE.this.focusedEditor != BNtpServerVectorFE.this.contentPane.get(props[i])) continue;
                    Property temp = props[i];
                    props[i] = props[i + 1];
                    props[i + 1] = temp;
                    BNtpServerVectorFE.this.contentPane.reorder(props);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    private class UpCommand
    extends Command {
        public UpCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"arrowUp.png")), null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                Property[] props = BNtpServerVectorFE.getDynamicPropertiesArray((BObject)BNtpServerVectorFE.this.contentPane, true);
                for (int i = 0; i < props.length; ++i) {
                    if (BNtpServerVectorFE.this.focusedEditor != BNtpServerVectorFE.this.contentPane.get(props[i])) continue;
                    Property temp = props[i];
                    props[i] = props[i - 1];
                    props[i - 1] = temp;
                    BNtpServerVectorFE.this.contentPane.reorder(props);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }

    private class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"add.png")), null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            BNtpServerVectorFE.this.addElement((BNtpServer)BNtpServerVectorFE.this.vector.getElementType().getInstance());
            BNtpServerVectorFE.this.setArrowCommandEnabledStates();
            return null;
        }
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BNtpServerVectorFE.this, "", BImage.make((BIcon)BIcon.std((String)"delete.png")), null, "");
            super.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            if (BNtpServerVectorFE.this.focusedEditor == null) {
                return null;
            }
            try {
                SlotCursor c = BNtpServerVectorFE.this.contentPane.loadSlots().getProperties();
                while (c.next(BWbFieldEditor.class)) {
                    if (c.get() != BNtpServerVectorFE.this.focusedEditor) continue;
                    BNtpServerVectorFE.this.contentPane.remove(c.property());
                    BNtpServerVectorFE.this.focusedEditor = null;
                    BNtpServerVectorFE.this.deleteCommand.setEnabled(false);
                    BNtpServerVectorFE.this.addCommand.setEnabled(true);
                    BNtpServerVectorFE.this.setModified();
                    BNtpServerVectorFE.this.setArrowCommandEnabledStates();
                    BNtpServerVectorFE.this.relayout();
                    return null;
                }
            }
            catch (Throwable t) {
                CommandUtil.error(this, t);
            }
            return null;
        }
    }
}

