/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui;

import com.tridium.platform.BEngineWatchdogPolicy;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BPlatform;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.npsdk.BSystemPlatformServiceNpsdk;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BDateFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:SystemPlatformService"}, requiredPermissions="W")})
@NiagaraActions(value={@NiagaraAction(name="timeModified", flags=4), @NiagaraAction(name="timeZoneModified", flags=4), @NiagaraAction(name="localeModified", flags=4), @NiagaraAction(name="markRebootFieldDirty", flags=4), @NiagaraAction(name="markRestartFieldDirty", flags=4)})
public class BSystemPlatformServicePlugin
extends BWbComponentView {
    @Generated
    public static final Action timeModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Action timeZoneModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Action localeModified = BSystemPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Action markRebootFieldDirty = BSystemPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Action markRestartFieldDirty = BSystemPlatformServicePlugin.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemPlatformServicePlugin.class);
    protected ToggleCommand toggleAutoSaveCommand;
    protected BGridPane ledgerPane;
    protected BGridPane filesystemPane;
    protected BButtonPane buttonPane;
    protected BLabel javaVmNameLabel;
    protected BLabel javaVmVendorLabel;
    protected BLabel javaVmVersionLabel;
    protected BLabel osArchLabel;
    protected BLabel osNameLabel;
    protected BLabel modelLabel;
    protected BLabel modelVersionLabel;
    protected BLabel productLabel;
    protected BLabel hostLabel;
    protected BLabel niagaraVersionLabel;
    protected BLabel fipsStatusLabel;
    protected BWbFieldEditor localeEditor;
    protected BLabel osVersionLabel;
    protected BLabel hostIdLabel;
    protected BLabel nameLabel;
    protected BLabel numCpusLabel;
    protected BLabel currentCpuLabel;
    protected BLabel overallCpuLabel;
    protected BLabel daemonPortLabel;
    protected BLabel daemonSSLPortLabel;
    protected BLabel freePhysicalMemoryLabel;
    protected BLabel totalPhysicalMemoryLabel;
    protected BLimitedFrozenEnumFE watchdogPolicyEditor;
    protected BFacets watchdogPolicyEditorFacets;
    protected BWbFieldEditor watchdogTimeoutEditor;
    protected BWbFieldEditor stationAutoSaveFrequencyEditor;
    protected BIntegerFE stationSaveBackupCountEditor;
    protected BListDropDown timeZoneDropDown;
    protected BWbFieldEditor timeEditor;
    protected BDateFE dateEditor;
    protected boolean isTimeModified = false;
    protected boolean isLocaleModified = false;
    protected boolean isTimeZoneModified = false;
    protected boolean isTimeReadonly = false;
    protected boolean restartEnabled = false;
    protected boolean saving = false;
    protected boolean loading = false;
    protected boolean rebootFieldDirty = false;
    protected boolean restartFieldDirty = false;
    protected boolean quietSave = false;
    private static final Version POLICY_FACETS_VERSION = new Version("4.9");
    private static final BFacets HOUR_MINUTE = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"HH:mm"), BBoolean.FALSE, BBoolean.TRUE, BBoolean.FALSE});
    private static final int KB_PADDING = 19;
    private static final int INT_MAX_PADDING = 14;

    @Generated
    public void timeModified() {
        this.invoke(timeModified, null, null);
    }

    @Generated
    public void timeZoneModified() {
        this.invoke(timeZoneModified, null, null);
    }

    @Generated
    public void localeModified() {
        this.invoke(localeModified, null, null);
    }

    @Generated
    public void markRebootFieldDirty() {
        this.invoke(markRebootFieldDirty, null, null);
    }

    @Generated
    public void markRestartFieldDirty() {
        this.invoke(markRestartFieldDirty, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setValign(BValign.top);
        this.ledgerPane.setColumnGap(10.0);
        this.ledgerPane.setRowGap(6.0);
        this.ledgerPane.setColorRows(true);
        this.nameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.name"), (BWidget)this.nameLabel);
        this.hostLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.host"), (BWidget)this.hostLabel);
        this.modelLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.model"), (BWidget)this.modelLabel);
        this.modelVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.modelVersion"), (BWidget)this.modelVersionLabel);
        this.productLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.product"), (BWidget)this.productLabel);
        this.hostIdLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.hostId"), (BWidget)this.hostIdLabel);
        this.niagaraVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.niagaraVersion"), (BWidget)this.niagaraVersionLabel);
        this.javaVmNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmName"), (BWidget)this.javaVmNameLabel);
        this.javaVmVendorLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVendor"), (BWidget)this.javaVmVendorLabel);
        this.javaVmVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.javaVmVersion"), (BWidget)this.javaVmVersionLabel);
        this.osNameLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.osName"), (BWidget)this.osNameLabel);
        this.osArchLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.osArch"), (BWidget)this.osArchLabel);
        this.osVersionLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.osVersion"), (BWidget)this.osVersionLabel);
        this.daemonPortLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.daemonPort"), (BWidget)this.daemonPortLabel);
        this.daemonSSLPortLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.daemonSSLPort"), (BWidget)this.daemonSSLPortLabel);
        this.localeEditor = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.locale"), (BWidget)this.localeEditor);
        this.timeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemTime"), (BWidget)this.timeEditor);
        this.dateEditor = new BDateFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemDate"), (BWidget)this.dateEditor);
        this.timeZoneDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone"), (BWidget)this.timeZoneDropDown);
        this.timeZoneDropDown.getList().setMultipleSelection(false);
        this.watchdogPolicyEditor = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogPolicy"), (BWidget)this.watchdogPolicyEditor);
        this.watchdogTimeoutEditor = BWbFieldEditor.makeFor((BObject)BRelTime.MINUTE, (Context)BSystemPlatformService.engineWatchdogTimeout.getFacets());
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.engineWatchdogTimeout"), (BWidget)this.watchdogTimeoutEditor);
        this.toggleAutoSaveCommand = new ToggleAutoSaveEnabledCommand();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.isStationAutoSaveEnabled"), (BWidget)new BCheckBox(this.toggleAutoSaveCommand));
        this.stationAutoSaveFrequencyEditor = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR, (Context)BSystemPlatformService.stationAutoSaveFrequency.getFacets());
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.stationAutoSaveFrequency"), (BWidget)this.stationAutoSaveFrequencyEditor);
        this.stationSaveBackupCountEditor = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.stationSaveBackupCount"), (BWidget)this.stationSaveBackupCountEditor);
        this.numCpusLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.numCpus"), (BWidget)this.numCpusLabel);
        this.currentCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.currentCpuUsage"), (BWidget)this.currentCpuLabel);
        this.overallCpuLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.overallCpuUsage"), (BWidget)this.overallCpuLabel);
        this.filesystemPane = new BGridPane(5);
        this.filesystemPane.setColumnAlign(BHalign.fill);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.filesystem"), (BWidget)this.filesystemPane);
        BGridPane memoryPane = new BGridPane(2);
        memoryPane.setColumnAlign(BHalign.fill);
        memoryPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.totalKb"), (boolean)true, (BHalign)BHalign.left));
        memoryPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.freeKb"), (boolean)true, (BHalign)BHalign.left));
        this.totalPhysicalMemoryLabel = new BLabel("", BHalign.right);
        memoryPane.add(null, (BValue)this.totalPhysicalMemoryLabel);
        this.freePhysicalMemoryLabel = new BLabel("", BHalign.right);
        memoryPane.add(null, (BValue)this.freePhysicalMemoryLabel);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.physicalMemory"), (BWidget)memoryPane);
        this.fipsStatusLabel = new BLabel();
        this.buttonPane = new BButtonPane();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.ledgerPane));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.linkTo(null, (BComponent)this.timeZoneDropDown, (Slot)BDropDown.valueModified, (Slot)timeZoneModified);
        this.linkTo(null, (BComponent)this.timeEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.dateEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.localeEditor, (Slot)BWbPlugin.pluginModified, (Slot)localeModified);
        this.linkTo(null, (BComponent)this.watchdogPolicyEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.watchdogTimeoutEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationAutoSaveFrequencyEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.stationSaveBackupCountEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)this.buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT)));
    }

    protected void loadTimeEditors(long millis, BTimeZone tz, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BAbsTime time = BAbsTime.make((long)millis, (BTimeZone)tz);
        BasicContext feContext = new BasicContext(cx, BFacets.make((BFacets)HOUR_MINUTE, (String)"TimeZone", (BIDataValue)tz));
        this.timeEditor.loadValue((BObject)time, (Context)feContext);
        feContext = new BasicContext(cx, BFacets.make((String)"TimeZone", (BIDataValue)tz));
        this.dateEditor.loadValue((BObject)time, (Context)feContext);
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        boolean showFileCount;
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        boolean loadingRestore = this.loading;
        this.loading = true;
        BSystemPlatformService systemPlatformService = (BSystemPlatformService)value;
        systemPlatformService.poll();
        this.registerForComponentEvents((BComponent)systemPlatformService, Integer.MAX_VALUE);
        BHost hostFromOrd = BOrd.toHost((BObject)systemPlatformService);
        this.hostLabel.setText(hostFromOrd != null ? hostFromOrd.getNavDisplayName(null) : LexiconText.make((Type)TYPE, (String)"system.unknownHost").getText(null));
        this.hostIdLabel.setText(systemPlatformService.getHostId());
        this.nameLabel.setText(systemPlatformService.getStationName());
        this.niagaraVersionLabel.setText(systemPlatformService.getNiagaraVersion());
        this.javaVmNameLabel.setText(systemPlatformService.getJavaVmName());
        this.javaVmVendorLabel.setText(systemPlatformService.getJavaVmVendor());
        this.javaVmVersionLabel.setText(systemPlatformService.getJavaVmVersion());
        this.osArchLabel.setText(systemPlatformService.getOsArch());
        this.osNameLabel.setText(systemPlatformService.getOsName());
        this.osVersionLabel.setText(systemPlatformService.getOsVersion());
        this.modelLabel.setText(systemPlatformService.getModel());
        this.modelVersionLabel.setText(systemPlatformService.getModelVersion());
        String productName = systemPlatformService.getProduct();
        if ("".equalsIgnoreCase(productName) || "unknown".equalsIgnoreCase(productName)) {
            switch (systemPlatformService.getModel()) {
                case "TITAN": {
                    productName = "JACE-8000";
                    break;
                }
                default: {
                    productName = systemPlatformService.getModel();
                }
            }
        }
        this.productLabel.setText(productName);
        String fipsStatus = systemPlatformService.getFipsStatus();
        if (fipsStatus != null && !fipsStatus.isEmpty()) {
            LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.fipsStatus"), (BWidget)this.fipsStatusLabel);
            this.fipsStatusLabel.setText(fipsStatus);
        }
        if (systemPlatformService.getLocalDaemonPort() > 0) {
            this.daemonPortLabel.setText(String.valueOf(systemPlatformService.getLocalDaemonPort()));
        } else {
            this.daemonPortLabel.setText(this.getLexicon().getText("unknown"));
        }
        if (systemPlatformService.getLocalDaemonSslPort() > 0) {
            this.daemonSSLPortLabel.setText(String.valueOf(systemPlatformService.getLocalDaemonSslPort()));
        } else {
            this.daemonSSLPortLabel.setText(this.getLexicon().getText("unknown"));
        }
        this.localeEditor.loadValue((BObject)BString.make((String)systemPlatformService.getLocale()), (Context)new BasicContext(cx, BSystemPlatformService.locale.getFacets()));
        this.loadTimeEditors(systemPlatformService.getSystemTime().getMillis(), systemPlatformService.getTimeZone(), cx);
        boolean platformReadonly = systemPlatformService.getIsServiceReadonly();
        this.isTimeReadonly = systemPlatformService.getIsSystemTimeReadonly() || platformReadonly;
        this.timeEditor.setReadonly(this.isTimeReadonly);
        this.dateEditor.setReadonly(this.isTimeReadonly);
        this.timeZoneDropDown.setDropDownEnabled(!this.isTimeReadonly);
        this.watchdogPolicyEditorFacets = BFacets.DEFAULT;
        if (new Version(systemPlatformService.getNiagaraVersion()).compareTo(POLICY_FACETS_VERSION) >= 0) {
            try {
                this.watchdogPolicyEditorFacets = systemPlatformService.getEngineWatchdogPolicyFacets();
            }
            catch (ActionInvokeException actionInvokeException) {
                // empty catch block
            }
        }
        this.watchdogPolicyEditor.loadValue((BObject)systemPlatformService.getEngineWatchdogPolicy(), (Context)new BasicContext(cx, BFacets.make((BFacets)BSystemPlatformService.engineWatchdogPolicy.getFacets(), (BFacets)this.watchdogPolicyEditorFacets)));
        this.watchdogTimeoutEditor.loadValue((BObject)systemPlatformService.getEngineWatchdogTimeout(), (Context)new BasicContext(cx, BSystemPlatformService.engineWatchdogTimeout.getFacets()));
        this.toggleAutoSaveCommand.setSelected(systemPlatformService.getIsStationAutoSaveEnabled());
        this.stationAutoSaveFrequencyEditor.loadValue((BObject)systemPlatformService.getStationAutoSaveFrequency(), (Context)new BasicContext(cx, BSystemPlatformService.stationAutoSaveFrequency.getFacets()));
        this.stationSaveBackupCountEditor.loadValue((BObject)BInteger.make((int)systemPlatformService.getStationSaveBackupCount()), (Context)new BasicContext(cx, BSystemPlatformService.stationSaveBackupCount.getFacets()));
        this.stationAutoSaveFrequencyEditor.setEnabled(systemPlatformService.getIsStationAutoSaveEnabled());
        this.stationSaveBackupCountEditor.setEnabled(systemPlatformService.getIsStationAutoSaveEnabled());
        this.numCpusLabel.setText(String.valueOf(systemPlatformService.getNumCpus()));
        int cpu = systemPlatformService.getCurrentCpuUsage();
        if (cpu < 0) {
            this.currentCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
        } else {
            this.currentCpuLabel.setText(cpu + "%");
        }
        cpu = systemPlatformService.getOverallCpuUsage();
        if (cpu < 0) {
            this.overallCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
        } else {
            this.overallCpuLabel.setText(cpu + "%");
        }
        DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.kbFormat.get();
        this.freePhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(systemPlatformService.getFreePhysicalMemory()), (int)19));
        this.totalPhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(systemPlatformService.getTotalPhysicalMemory()), (int)19));
        this.filesystemPane.removeAll();
        this.filesystemPane.add(null, (BValue)new BNullWidget());
        this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.totalKb"), (boolean)true, (BHalign)BHalign.left));
        this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.freeKb"), (boolean)true, (BHalign)BHalign.left));
        boolean bl = showFileCount = systemPlatformService instanceof BSystemPlatformServiceQnx || systemPlatformService instanceof BSystemPlatformServiceNpsdk;
        if (showFileCount) {
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.currentFileCount"), (boolean)true, (BHalign)BHalign.left));
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.maxFileCount"), (boolean)true, (BHalign)BHalign.left));
        } else {
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)new BNullWidget());
        }
        BVector filesystemAttributes = systemPlatformService.getFilesystemAttributes();
        SlotCursor attributesCursor = filesystemAttributes.loadSlots().getProperties();
        while (attributesCursor.next(BFilesystemAttributes.class)) {
            Property attributesProperty = attributesCursor.property();
            if ((filesystemAttributes.getFlags((Slot)attributesProperty) & 4) != 0) continue;
            BFilesystemAttributes attrs = (BFilesystemAttributes)attributesCursor.get();
            String fsPropName = attributesProperty.getName();
            this.filesystemPane.add(null, (BValue)new BLabel(filesystemAttributes.getDisplayName((Slot)attributesProperty, cx), BHalign.left));
            this.filesystemPane.add(fsPropName + "total", (BValue)new BLabel(TextUtil.padLeft((String)kbFormat.format(attrs.getTotalSpace()), (int)19), BHalign.right));
            this.filesystemPane.add(fsPropName + "free", (BValue)new BLabel(TextUtil.padLeft((String)kbFormat.format(attrs.getFreeSpace()), (int)19), BHalign.right));
            if (showFileCount) {
                String currentFileText = attrs.getCurrentFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                String maxFileText = attrs.getMaxFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getMaxFileCount());
                this.filesystemPane.add(fsPropName + "currentFile", (BValue)new BLabel(TextUtil.padLeft((String)currentFileText, (int)14), BHalign.right));
                this.filesystemPane.add(fsPropName + "maxFile", (BValue)new BLabel(TextUtil.padLeft((String)maxFileText, (int)14), BHalign.right));
                continue;
            }
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)new BNullWidget());
        }
        ZoneListModel listModel = new ZoneListModel(systemPlatformService.getStationTimeZones());
        this.timeZoneDropDown.getList().setModel((ListModel)listModel);
        this.timeZoneDropDown.setSelectedItem((Object)systemPlatformService.getTimeZone());
        this.isTimeModified = false;
        this.isTimeZoneModified = false;
        this.restartEnabled = systemPlatformService.getAllowStationRestart();
        this.buttonPane.removeAll();
        this.buttonPane.addWorkbenchButtons((BWidget)this);
        this.getContent().relayout();
        this.loading = loadingRestore;
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.saving = true;
        BSystemPlatformService systemPlatformService = (BSystemPlatformService)value;
        systemPlatformService.setEngineWatchdogPolicy((BEngineWatchdogPolicy)this.watchdogPolicyEditor.saveValue());
        systemPlatformService.setEngineWatchdogTimeout((BRelTime)this.watchdogTimeoutEditor.saveValue());
        systemPlatformService.setIsStationAutoSaveEnabled(this.toggleAutoSaveCommand.isSelected());
        systemPlatformService.setStationAutoSaveFrequency((BRelTime)this.stationAutoSaveFrequencyEditor.saveValue());
        systemPlatformService.setStationSaveBackupCount(((BInteger)this.stationSaveBackupCountEditor.saveValue()).getInt());
        if (this.isLocaleModified) {
            systemPlatformService.setLocale(this.localeEditor.saveValue().toString());
            this.isLocaleModified = false;
        }
        if (!this.isTimeReadonly && (this.isTimeModified || this.isTimeZoneModified)) {
            BAbsTime date = (BAbsTime)this.dateEditor.saveValue();
            BAbsTime time = (BAbsTime)this.timeEditor.saveValue();
            BAbsTime newValue = BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)((BTimeZone)this.timeZoneDropDown.getSelectedItem()));
            if (!systemPlatformService.getIsSystemTimeReadonly() && !systemPlatformService.getIsServiceReadonly()) {
                systemPlatformService.set(BSystemPlatformService.systemTime, (BValue)newValue, cx);
            }
            this.isTimeModified = false;
        }
        if (this.isTimeZoneModified) {
            if (!systemPlatformService.getIsSystemTimeReadonly() && !systemPlatformService.getIsServiceReadonly()) {
                systemPlatformService.setTimeZone((BTimeZone)this.timeZoneDropDown.getSelectedItem());
            }
            this.isTimeZoneModified = false;
        }
        this.doSaveSystemPlatformServiceFields(systemPlatformService, cx);
        systemPlatformService.savePlatformServiceProperties();
        if (this.rebootFieldDirty) {
            if (!systemPlatformService.getIsServiceReadonly()) {
                if (!this.quietSave && 4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.message"))) {
                    systemPlatformService.reboot();
                }
            } else if (!this.quietSave) {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.message"));
            }
        } else if (this.restartFieldDirty) {
            if (systemPlatformService.getLocalDaemonAccess().atLeast(BDaemonAccessLevel.restricted)) {
                if (!this.quietSave && 4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.message"))) {
                    systemPlatformService.restartStation();
                }
            } else if (!this.quietSave) {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.message"));
            }
        }
        this.rebootFieldDirty = false;
        this.restartFieldDirty = false;
        this.saving = false;
        return value;
    }

    protected void doSaveSystemPlatformServiceFields(BSystemPlatformService svc, Context cx) throws Exception {
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (this.saving || this.loading || evt == null || evt.getSlot() == null || !evt.getSlot().isProperty()) {
            return;
        }
        boolean handled = false;
        DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.kbFormat.get();
        if (evt.getSourceComponent() instanceof BSystemPlatformService) {
            BSystemPlatformService systemPlatformService = (BSystemPlatformService)evt.getSourceComponent();
            Property property = evt.getSlot().asProperty();
            BValue propertyValue = systemPlatformService.get(property);
            if (property == BSystemPlatformService.javaVmName) {
                this.javaVmNameLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.javaVmVendor) {
                this.javaVmVendorLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.javaVmVersion) {
                this.javaVmVersionLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.osArch) {
                this.osArchLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.osName) {
                this.osNameLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.osVersion) {
                this.osVersionLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.hostId) {
                this.hostIdLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.stationName) {
                this.nameLabel.setText(propertyValue.toString());
                handled = true;
            } else if (property == BSystemPlatformService.locale) {
                if (!this.isLocaleModified) {
                    this.localeEditor.loadValue((BObject)BString.make((String)propertyValue.toString()), (Context)new BasicContext((Context)evt.getSlot().getFacets()));
                }
                handled = true;
            } else if (property == BSystemPlatformService.systemTime) {
                if (!this.isTimeModified) {
                    this.loadTimeEditors(((BAbsTime)propertyValue).getMillis(), systemPlatformService.getTimeZone(), this.getCurrentContext());
                }
                handled = true;
            } else if (property == BSystemPlatformService.timeZone) {
                if (!this.isTimeZoneModified) {
                    this.timeZoneDropDown.setSelectedItem((Object)systemPlatformService.getTimeZone());
                }
                handled = true;
            } else if (property == BSystemPlatformService.engineWatchdogPolicy) {
                this.watchdogPolicyEditor.loadValue((BObject)((BEngineWatchdogPolicy)propertyValue), (Context)new BasicContext((Context)evt.getSlot().getFacets(), this.watchdogPolicyEditorFacets));
                handled = true;
            } else if (property == BSystemPlatformService.engineWatchdogTimeout) {
                this.watchdogTimeoutEditor.loadValue((BObject)((BRelTime)propertyValue), (Context)new BasicContext((Context)evt.getSlot().getFacets()));
                handled = true;
            } else if (property == BSystemPlatformService.totalPhysicalMemory) {
                this.totalPhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(systemPlatformService.getTotalPhysicalMemory()), (int)19));
                handled = true;
            } else if (property == BSystemPlatformService.freePhysicalMemory) {
                this.freePhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(systemPlatformService.getFreePhysicalMemory()), (int)19));
                handled = true;
            } else if (property == BSystemPlatformService.isStationAutoSaveEnabled) {
                this.lockModifiedState();
                this.toggleAutoSaveCommand.setSelected(systemPlatformService.getIsStationAutoSaveEnabled());
                handled = true;
                this.unlockModifiedState();
            } else if (property == BSystemPlatformService.stationAutoSaveFrequency || property == BSystemPlatformServiceQnx.stationAutoSaveFrequency || property == BSystemPlatformServiceNpsdk.stationAutoSaveFrequency) {
                this.stationAutoSaveFrequencyEditor.loadValue((BObject)((BRelTime)propertyValue), (Context)new BasicContext((Context)evt.getSlot().getFacets()));
                handled = true;
            } else if (property == BSystemPlatformService.stationSaveBackupCount || property == BSystemPlatformServiceQnx.stationSaveBackupCount || property == BSystemPlatformServiceNpsdk.stationSaveBackupCount) {
                this.stationSaveBackupCountEditor.loadValue((BObject)BInteger.make((int)systemPlatformService.getStationSaveBackupCount()), (Context)new BasicContext((Context)evt.getSlot().getFacets()));
                handled = true;
            } else if (property == BSystemPlatformService.currentCpuUsage) {
                int cpu = systemPlatformService.getCurrentCpuUsage();
                if (cpu < 0) {
                    this.currentCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
                } else {
                    this.currentCpuLabel.setText(cpu + "%");
                }
                handled = true;
            } else if (property == BSystemPlatformService.overallCpuUsage) {
                int cpu = systemPlatformService.getOverallCpuUsage();
                if (cpu < 0) {
                    this.overallCpuLabel.setText(this.getLexicon().getText("labels.system.cpuUsage.unavailable"));
                } else {
                    this.overallCpuLabel.setText(cpu + "%");
                }
                handled = true;
            } else if (property == BSystemPlatformService.localDaemonPort) {
                if (systemPlatformService.getLocalDaemonPort() > 0) {
                    this.daemonPortLabel.setText(String.valueOf(systemPlatformService.getLocalDaemonPort()));
                } else {
                    this.daemonPortLabel.setText(this.getLexicon().getText("unknown"));
                }
                handled = true;
            } else if (property == BSystemPlatformService.localDaemonSslPort) {
                if (systemPlatformService.getLocalDaemonSslPort() > 0) {
                    this.daemonSSLPortLabel.setText(String.valueOf(systemPlatformService.getLocalDaemonSslPort()));
                } else {
                    this.daemonSSLPortLabel.setText(this.getLexicon().getText("unknown"));
                }
                handled = true;
            }
        } else if (evt.getSourceComponent() instanceof BFilesystemAttributes) {
            Property attributesProperty = evt.getSlot().asProperty();
            BFilesystemAttributes attrs = (BFilesystemAttributes)evt.getSourceComponent();
            String fsPropName = attributesProperty.getName();
            if (attributesProperty == BFilesystemAttributes.freeSpace) {
                BLabel label = (BLabel)this.filesystemPane.get(fsPropName + "free");
                if (label != null) {
                    label.setText(TextUtil.padLeft((String)kbFormat.format(attrs.getFreeSpace()), (int)19));
                }
                handled = true;
            } else if (attributesProperty == BFilesystemAttributes.totalSpace) {
                BLabel label = (BLabel)this.filesystemPane.get(fsPropName + "total");
                if (label != null) {
                    label.setText(TextUtil.padLeft((String)kbFormat.format(attrs.getTotalSpace()), (int)19));
                }
                handled = true;
            } else if (attributesProperty == BFilesystemAttributes.currentFileCount) {
                BLabel label = (BLabel)this.filesystemPane.get(fsPropName + "currentFile");
                if (label != null) {
                    String text = attrs.getCurrentFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                    label.setText(TextUtil.padLeft((String)text, (int)14));
                }
                handled = true;
            } else if (attributesProperty == BFilesystemAttributes.maxFileCount) {
                BLabel label = (BLabel)this.filesystemPane.get(fsPropName + "maxFile");
                if (label != null) {
                    String text = attrs.getMaxFileCount() < 0L ? this.getLexicon().getText("labels.system.fileCount.unavailable") : String.valueOf(attrs.getMaxFileCount());
                    label.setText(TextUtil.padLeft((String)text, (int)14));
                }
                handled = true;
            }
        }
        if (handled) {
            this.getContent().relayout();
        } else if (BPlatform.log.isLoggable(Level.FINE)) {
            BPlatform.log.fine("unhandled event " + evt);
        }
    }

    public void doTimeModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeModified = true;
            this.invoke(setModified, null, null);
        }
    }

    public void doTimeZoneModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeZoneModified = true;
            if (!this.restartEnabled) {
                this.rebootFieldDirty = true;
            } else {
                this.restartFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    public void doLocaleModified() {
        if (!this.isModifiedStateLocked()) {
            this.isLocaleModified = true;
            if (this.restartEnabled) {
                this.restartFieldDirty = true;
            } else {
                this.rebootFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    public void doMarkRestartFieldDirty() {
        if (this.restartEnabled) {
            if (!this.isModifiedStateLocked()) {
                this.restartFieldDirty = true;
                this.invoke(setModified, null, null);
            }
        } else {
            this.doMarkRebootFieldDirty();
        }
    }

    public void doMarkRebootFieldDirty() {
        if (!this.isModifiedStateLocked()) {
            this.rebootFieldDirty = true;
            this.invoke(setModified, null, null);
        }
    }

    private class ToggleAutoSaveEnabledCommand
    extends ToggleCommand {
        public ToggleAutoSaveEnabledCommand() {
            super((BWidget)BSystemPlatformServicePlugin.this, BSystemPlatformServicePlugin.this.getLexicon().getText("labels.system.enableStationAutoSave"));
        }

        public CommandArtifact doInvoke() {
            BSystemPlatformServicePlugin.this.stationAutoSaveFrequencyEditor.setEnabled(this.isSelected());
            BSystemPlatformServicePlugin.this.stationSaveBackupCountEditor.setEnabled(this.isSelected());
            BSystemPlatformServicePlugin.this.setModified();
            return null;
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BVector zones) {
            this.items = (BTimeZone[])zones.getChildren(BTimeZone.class);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int row) {
            return this.items[row];
        }

        public Object getItem(int row) {
            return this.getTimeZone(row);
        }
    }
}

