/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui;

import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BDateFE;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:SystemPlatformService", "platform:PlatformServiceContainer"}, requiredPermissions="W")})
@NiagaraActions(value={@NiagaraAction(name="timeModified", flags=4), @NiagaraAction(name="timeZoneModified", flags=4)})
public class BSystemDateTimeEditor
extends BWbComponentView {
    @Generated
    public static final Action timeModified = BSystemDateTimeEditor.newAction((int)4, null);
    @Generated
    public static final Action timeZoneModified = BSystemDateTimeEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemDateTimeEditor.class);
    protected BGridPane ledgerPane;
    private BButtonPane buttonPane;
    private BListDropDown timeZoneDropDown;
    private BWbFieldEditor timeEditor;
    private BDateFE dateEditor;
    private boolean isTimeModified = false;
    private boolean isTimeZoneModified = false;
    protected boolean saving = false;
    protected boolean loading = false;
    protected boolean restartEnabled = false;
    private boolean restartFieldDirty = false;
    private boolean rebootFieldDirty = false;
    private BSystemPlatformService systemPlatformService = null;
    private static final BFacets HOUR_MINUTE = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"HH:mm"), BBoolean.FALSE, BBoolean.TRUE, BBoolean.FALSE});

    @Generated
    public void timeModified() {
        this.invoke(timeModified, null, null);
    }

    @Generated
    public void timeZoneModified() {
        this.invoke(timeZoneModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSystemDateTimeEditor() {
        this.autoRegisterForComponentEvents = false;
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setValign(BValign.top);
        this.ledgerPane.setColumnGap(10.0);
        this.ledgerPane.setRowGap(6.0);
        this.ledgerPane.setColorRows(true);
        this.timeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemTime"), (BWidget)this.timeEditor);
        this.dateEditor = new BDateFE();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemDate"), (BWidget)this.dateEditor);
        this.timeZoneDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone"), (BWidget)this.timeZoneDropDown);
        this.timeZoneDropDown.getList().setMultipleSelection(false);
        this.buttonPane = new BButtonPane();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.ledgerPane));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.linkTo(null, (BComponent)this.timeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)timeZoneModified);
        this.linkTo(null, (BComponent)this.timeEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.linkTo(null, (BComponent)this.dateEditor, (Slot)BWbPlugin.pluginModified, (Slot)timeModified);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(null), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)this.buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT))));
    }

    protected void loadTimeEditors(long millis, BTimeZone tz, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BAbsTime time = BAbsTime.make((long)millis, (BTimeZone)tz);
        BasicContext feContext = new BasicContext(cx, BFacets.make((BFacets)HOUR_MINUTE, (String)"TimeZone", (BIDataValue)tz));
        this.timeEditor.loadValue((BObject)time, (Context)feContext);
        feContext = new BasicContext(cx, BFacets.make((String)"TimeZone", (BIDataValue)tz));
        this.dateEditor.loadValue((BObject)time, (Context)feContext);
        boolean readonly = this.systemPlatformService.getIsSystemTimeReadonly() || this.systemPlatformService.getIsServiceReadonly();
        this.timeEditor.setReadonly(readonly);
        this.dateEditor.setReadonly(readonly);
        this.timeZoneDropDown.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        boolean loadingRestore = this.loading;
        this.loading = true;
        if (value instanceof BSystemPlatformService) {
            this.systemPlatformService = (BSystemPlatformService)value;
        } else if (value instanceof BPlatformServiceContainer) {
            this.systemPlatformService = ((BSystemPlatformService[])((BPlatformServiceContainer)value).getChildren(BSystemPlatformService.class))[0];
        } else {
            throw new ClassCastException();
        }
        this.systemPlatformService.poll();
        this.registerForComponentEvents((BComponent)this.systemPlatformService, 4);
        this.loadTimeEditors(this.systemPlatformService.getSystemTime().getMillis(), this.systemPlatformService.getTimeZone(), cx);
        ZoneListModel listModel = new ZoneListModel(this.systemPlatformService.getAllTimeZones());
        this.timeZoneDropDown.getList().setModel((ListModel)listModel);
        this.timeZoneDropDown.setSelectedItem((Object)this.systemPlatformService.getTimeZone());
        this.isTimeModified = false;
        this.isTimeZoneModified = false;
        this.restartEnabled = this.systemPlatformService.getAllowStationRestart();
        this.buttonPane.removeAll();
        this.buttonPane.addWorkbenchButtons((BWidget)this);
        this.getContent().relayout();
        this.loading = loadingRestore;
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.saving = true;
        if (value instanceof BSystemPlatformService) {
            this.systemPlatformService = (BSystemPlatformService)value;
        } else if (value instanceof BPlatformServiceContainer) {
            this.systemPlatformService = ((BSystemPlatformService[])((BPlatformServiceContainer)value).getChildren(BSystemPlatformService.class))[0];
        } else {
            throw new ClassCastException();
        }
        if (this.isTimeModified || this.isTimeZoneModified) {
            BAbsTime date = (BAbsTime)this.dateEditor.saveValue();
            BAbsTime time = (BAbsTime)this.timeEditor.saveValue();
            BAbsTime newValue = BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)((BTimeZone)this.timeZoneDropDown.getSelectedItem()));
            if (!this.systemPlatformService.getIsSystemTimeReadonly() && !this.systemPlatformService.getIsServiceReadonly()) {
                this.systemPlatformService.set(BSystemPlatformService.systemTime, (BValue)newValue, cx);
            }
            this.isTimeModified = false;
        }
        if (this.isTimeZoneModified) {
            if (!this.systemPlatformService.getIsSystemTimeReadonly() && !this.systemPlatformService.getIsServiceReadonly()) {
                this.systemPlatformService.setTimeZone((BTimeZone)this.timeZoneDropDown.getSelectedItem());
            }
            this.isTimeZoneModified = false;
        }
        this.systemPlatformService.savePlatformServiceProperties();
        if (this.rebootFieldDirty) {
            if (!this.systemPlatformService.getIsServiceReadonly()) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootNow.message"))) {
                    this.systemPlatformService.reboot();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.rebootRequired.message"));
            }
        } else if (this.restartFieldDirty) {
            if (this.systemPlatformService.getLocalDaemonAccess().atLeast(BDaemonAccessLevel.restricted)) {
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartNow.message"))) {
                    this.systemPlatformService.restartStation();
                }
            } else {
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.title"), (Object)this.getLexicon().getText("SystemPlatformServicePlugin.restartRequired.message"));
            }
        }
        this.rebootFieldDirty = false;
        this.restartFieldDirty = false;
        this.saving = false;
        return value;
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (this.saving || !evt.getSlot().isProperty()) {
            return;
        }
        if (evt.getSourceComponent() instanceof BSystemPlatformService) {
            BSystemPlatformService systemPlatformService = (BSystemPlatformService)evt.getSourceComponent();
            Property property = evt.getSlot().asProperty();
            BValue propertyValue = systemPlatformService.get(property);
            if (property == BSystemPlatformService.systemTime) {
                if (!this.isTimeModified) {
                    this.loadTimeEditors(((BAbsTime)propertyValue).getMillis(), systemPlatformService.getTimeZone(), this.getCurrentContext());
                }
            } else if (property == BSystemPlatformService.timeZone && !this.isTimeZoneModified) {
                this.timeZoneDropDown.setSelectedItem((Object)systemPlatformService.getTimeZone());
            }
        }
    }

    public void doTimeModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeModified = true;
            this.invoke(setModified, null, null);
        }
    }

    public void doTimeZoneModified() {
        if (!this.isModifiedStateLocked()) {
            this.isTimeZoneModified = true;
            if (!this.restartEnabled) {
                this.rebootFieldDirty = true;
            } else {
                this.restartFieldDirty = true;
            }
            this.invoke(setModified, null, null);
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BVector zones) {
            this.items = (BTimeZone[])zones.getChildren(BTimeZone.class);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int row) {
            return this.items[row];
        }

        public Object getItem(int row) {
            return this.getTimeZone(row);
        }
    }
}

