/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.util.LexiconText;

public class StringToObjectMap<V>
extends HashMap<String, V> {
    private HashSet<String> originalKeys = new HashSet();

    public StringToObjectMap() {
    }

    public StringToObjectMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringToObjectMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public StringToObjectMap(Map<? extends String, ? extends V> t) {
        this.putAll(t);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(TextUtil.toLowerCase((String)((String)key)));
    }

    public Object get(String key) {
        return super.get(TextUtil.toLowerCase((String)key));
    }

    @Override
    public V put(String key, V value) {
        this.originalKeys.add(key);
        return super.put(TextUtil.toLowerCase((String)key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> t) {
        if (t == null) {
            return;
        }
        Iterator<? extends String> iterator = t.keySet().iterator();
        while (iterator.hasNext()) {
            String o;
            String key = o = iterator.next();
            this.put(key, t.get(key));
        }
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.originalKeys);
    }

    @Override
    public void clear() {
        super.clear();
        this.originalKeys.clear();
    }

    @Override
    public V remove(Object key) {
        String lowerCaseKey = TextUtil.toLowerCase((String)((String)key));
        for (String originalKey : this.originalKeys) {
            if (!lowerCaseKey.equals(TextUtil.toLowerCase((String)originalKey))) continue;
            this.originalKeys.remove(originalKey);
            return super.remove(lowerCaseKey);
        }
        return null;
    }

    public String getString(String key, Object defaultValue) {
        return this.getString(key, defaultValue, null);
    }

    public String getString(String key, Object defaultValue, Context cx) {
        String lcKey = TextUtil.toLowerCase((String)key);
        return super.containsKey(lcKey) ? this.getString(super.get(lcKey), cx) : this.getString(defaultValue, cx);
    }

    private String getString(Object obj, Context cx) {
        if (obj instanceof LexiconText) {
            return ((LexiconText)obj).getHtmlSafeText(cx);
        }
        if (obj instanceof BObject) {
            return ((BObject)obj).toString(cx);
        }
        return String.valueOf(obj);
    }
}

