/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import javax.baja.hx.BHxFieldEditor;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class HxViewHelper {
    protected BHxView view;
    protected String fieldName;
    protected BFacets facets;
    protected boolean readonly;

    protected HxViewHelper(String fieldName, BHxView view, BFacets facets) {
        this.fieldName = fieldName;
        this.view = view;
        this.facets = facets == null ? BFacets.NULL : facets;
    }

    public static HxViewHelper make(String fieldName, BHxView view, Context cx) {
        return new HxViewHelper(fieldName, view, null);
    }

    public static HxViewHelper makeFE(String fieldName, BObject value, Context cx) {
        return new HxViewHelper(fieldName, (BHxView)BHxFieldEditor.makeFor((BObject)value, (Context)cx), cx == null ? BFacets.NULL : cx.getFacets());
    }

    public void write(BObject value, HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, value));
        fieldOp.mergeFacets(this.facets);
        fieldOp.setReadonly(this.isReadonly());
        this.view.write(fieldOp);
    }

    public BObject save(BObject value, HxOp op) throws Exception {
        HxOp fieldOp = op.make(this.fieldName, new OrdTarget((OrdTarget)op, value));
        return this.view.save(fieldOp);
    }

    public void validate(BObject value, HxOp op) throws Exception {
    }

    public boolean isFormValueAvailable(HxOp op) {
        throw new UnsupportedOperationException(this.getClass().getName() + ".isFormValueAvailable(HxOp) " + this.fieldName);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

