/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.hx.util.HxButtonHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxTimeZoneHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import java.util.HashMap;
import javax.baja.hx.BHxView;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"platform:SystemDateTimeEditor"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxSystemDateTimeEditor
extends BHxView {
    @Generated
    public static final BHxSystemDateTimeEditor INSTANCE = new BHxSystemDateTimeEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxSystemDateTimeEditor.class);
    HxViewHelper systemTimeFE = HxViewHelper.makeFE("systemTime", (BObject)BAbsTime.DEFAULT, (Context)BFacets.make((String)"showTimeZone", (boolean)false));
    HxViewHelper timeZoneFE;
    HxButtonHelper refreshButton;
    HxButtonHelper saveButton;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxSystemDateTimeEditor() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("onChange", "onTimeZoneChanged(event)");
        this.timeZoneFE = HxTimeZoneHelper.makeFE("timeZone", attrs, (Context)BSystemPlatformService.timeZone.getFacets());
        this.refreshButton = HxButtonHelper.makeRefresh();
        this.saveButton = HxButtonHelper.makeSave();
    }

    public void write(HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)"module://platform/lib/BHxSystemPlatformServiceEditor.js");
        op.addJavaScript(ord);
        BSystemPlatformService service = this.getSystemPlatformService(op);
        service.checkPropertiesLoaded();
        service.poll();
        HtmlWriter out = op.getHtmlWriter();
        HxMessageHelper.writeMessage("SystemDateTimeEditor", op);
        boolean readonly = !op.canWrite() || service.getIsSystemTimeReadonly() || service.getIsServiceReadonly();
        this.systemTimeFE.setReadonly(readonly);
        this.timeZoneFE.setReadonly(readonly);
        this.saveButton.setReadonly(readonly);
        BTimeZone tz = service.getTimeZone();
        BAbsTime sysTime = BAbsTime.make((long)service.getSystemTime().getMillis(), (BTimeZone)tz);
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("systemRestart")).println("' value='false'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("systemReboot")).println("' value='false'/>");
        out.w((Object)"<input type='hidden' name='").w((Object)op.scope("restartEnabled")).w((Object)"' value='");
        if (op.canWrite() && service.getAllowStationRestart()) {
            out.w((Object)"true");
        } else {
            out.w((Object)"false");
        }
        out.w((Object)"'/>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.systemTime").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.systemTimeFE.write((BObject)sysTime, op);
        out.w((Object)("&nbsp;" + tz.getShortDisplayName(sysTime.inDaylightTime(), null)));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)LexiconText.make((Type)TYPE, (String)"labels.system.systemTimeZone").getHtmlSafeText((Context)op)).w((Object)"</b></td>");
        out.w((Object)"<td>");
        this.timeZoneFE.write((BObject)tz, op);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        out.w((Object)"</table>");
        out.println("<div style='padding:10px; text-align:center;'>");
        this.refreshButton.write(op);
        if (op.canWrite()) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (!service.getIsServiceReadonly()) {
                attrs.put("onclick", "onSystemPlatformServiceSave(\"" + op.scope("submit") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.restartRequired.hxConfirmMessage") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.rebootRequired.hxConfirmMessage") + "\")");
            } else {
                attrs.put("onclick", "onSystemPlatformServiceSave(\"" + op.scope("submit") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.restartWillBeRequired.hxConfirmMessage") + "\",\"" + this.getLexicon().getHtmlSafeText("SystemPlatformServicePlugin.rebootWillBeRequired.hxConfirmMessage") + "\")");
            }
            this.saveButton.write(op, attrs);
        }
        out.println("</div>");
    }

    public BObject save(HxOp op) throws Exception {
        BSystemPlatformService service = this.getSystemPlatformService(op);
        if (!service.getIsSystemTimeReadonly() && !service.getIsServiceReadonly()) {
            BTimeZone zone = (BTimeZone)this.timeZoneFE.save((BObject)service.getTimeZone(), op);
            BAbsTime time = (BAbsTime)this.systemTimeFE.save((BObject)service.getSystemTime(), op);
            time = BAbsTime.make((int)time.getYear(), (BMonth)time.getMonth(), (int)time.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)zone);
            service.setSystemTime(time);
            service.setTimeZone(zone);
            service.savePlatformServiceProperties();
            if (Boolean.valueOf(op.getFormValue("systemReboot")).booleanValue()) {
                service.reboot();
                HxMessageHelper.addMessage("SystemDateTimeEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemReboot.hxMessage"), op);
            } else if (Boolean.valueOf(op.getFormValue("systemRestart")).booleanValue()) {
                service.restartStation();
                HxMessageHelper.addMessage("SystemDateTimeEditor", LexiconText.make((String)"platform", (String)"SystemPlatformServiceEditor.systemRestart.hxMessage"), op);
            }
        }
        return op.get();
    }

    private BSystemPlatformService getSystemPlatformService(HxOp op) {
        BObject obj = op.get();
        if (obj instanceof BSystemPlatformService) {
            return (BSystemPlatformService)obj;
        }
        if (obj instanceof BPlatformServiceContainer) {
            return ((BSystemPlatformService[])((BPlatformServiceContainer)obj).getChildren(BSystemPlatformService.class))[0];
        }
        throw new ClassCastException();
    }
}

