/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx;

import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.ReloadLicenseMessage;
import com.tridium.platform.hx.FileInfoTable;
import com.tridium.platform.hx.util.HxBooleanHelper;
import com.tridium.platform.hx.util.HxMessageHelper;
import com.tridium.platform.hx.util.HxViewHelper;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BLicensePlatformService;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.license.UiUtil;
import com.tridium.sys.Nre;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import org.owasp.encoder.Encode;

@NiagaraType(agent={@AgentOn(types={"platform:LicensePlatformService"}, requiredPermissions="W")})
@NiagaraSingleton
public class BHxLicensePlatformServiceEditor
extends BHxView {
    @Generated
    public static final BHxLicensePlatformServiceEditor INSTANCE = new BHxLicensePlatformServiceEditor();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxLicensePlatformServiceEditor.class);
    private FileInfoTable table = new FileInfoTable("table");
    private Delete delete = new Delete(this.table);
    private ImportEntitlement importEntitlement;
    private HxViewHelper rebootFE;
    private HxViewHelper restartFE;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxLicensePlatformServiceEditor() {
        this.registerEvent((Event)this.delete);
        this.importEntitlement = new ImportEntitlement();
        this.registerEvent((Event)this.importEntitlement);
        this.rebootFE = HxBooleanHelper.makeFE("systemReboot", null);
        this.restartFE = HxBooleanHelper.makeFE("systemRestart", null);
    }

    public void write(HxOp op) throws Exception {
        BDaemonSession localSession;
        op.setMultiPartForm();
        BLicensePlatformService service = (BLicensePlatformService)op.get();
        HtmlWriter out = op.getHtmlWriter();
        HxMessageHelper.writeMessage("LicensePlatformServiceEditor", op);
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sysService.poll();
        BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        licService.poll();
        boolean licenseReadonly = sysService.getIsLicenseReadonly();
        boolean canRestart = sysService.getAllowStationRestart() && !licenseReadonly;
        boolean canReboot = false;
        if (!sysService.getIsServiceReadonly() && !licenseReadonly && (localSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession)) != null) {
            canReboot = true;
        }
        BHostIdStatus hostIdStatus = sysService.getHostIdStatus();
        out.w((Object)"<div class='ux-fixed-header'; style='padding: 5px;'>");
        out.w((Object)"<b>").safe((Object)this.getLexicon().getText("labels.system.hostId")).w((Object)":</b>").w((Object)"<span style='padding-left: 10px;'>").safe((Object)Nre.getHostId()).w((Object)"</span>");
        if (hostIdStatus != BHostIdStatus.perpetual) {
            out.w((Object)"<span style='padding-left: 10px;'>");
            HxUtil.makeImageJS((BImage)BImage.make((BOrd)this.getHostIdIndicatorImageOrd(hostIdStatus)), (String)"border='0'", (HxOp)op);
            out.w((Object)"</span>");
            out.w((Object)"<span style='padding-left: 10px;'>");
            out.safe((Object)this.getHostIdFaultCause(hostIdStatus));
            out.w((Object)"</span>");
        }
        out.w((Object)"</div>");
        out.w((Object)"<div class='tableViewHeader';'>");
        out.w((Object)"<b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.files.header")).w((Object)"</b>");
        out.w((Object)"</div>");
        try {
            AccessController.doPrivileged(() -> {
                this.table.write((BObject)service, op);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        out.w((Object)"<div class='tableViewToolbar'; style='border-bottom: 1px solid black;'>");
        this.delete.writeButton(op);
        out.w((Object)"</div>");
        out.w((Object)"<br/>");
        out.w((Object)"<br/>");
        out.w((Object)"<div class='tableViewHeader'; style='border-top: 1px solid black;'>");
        out.w((Object)"<b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.header")).w((Object)"</b>");
        out.w((Object)"</div>");
        out.w((Object)"<table cellpadding='5'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.file")).w((Object)"</b></td>");
        out.w((Object)"<td><input ");
        out.attr("type", "file");
        out.w(' ');
        out.attr("name", op.scope("file"));
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            out.w((Object)" ").attr("disabled", "disabled");
        }
        out.w((Object)"/></td>\n");
        out.w((Object)"</tr>");
        if (canRestart) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.restart")).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.restartFE.write((BObject)BBoolean.TRUE, op);
            out.w((Object)"</td>\n");
            out.w((Object)"</tr>");
            out.w((Object)("<input type='hidden' name='" + op.scope("systemReboot.value") + "' value='false' />"));
        } else if (canReboot) {
            out.w((Object)"<tr>");
            out.w((Object)"<td><b>").w((Object)op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.reboot")).w((Object)"</b></td>");
            out.w((Object)"<td>");
            this.rebootFE.write((BObject)BBoolean.TRUE, op);
            out.w((Object)"</td>\n");
            out.w((Object)"</tr>");
            out.w((Object)("<input type='hidden' name='" + op.scope("systemRestart.value") + "' value='false' />"));
        } else {
            out.w((Object)("<input type='hidden' name='" + op.scope("systemReboot.value") + "' value='false' />"));
            out.w((Object)("<input type='hidden' name='" + op.scope("systemRestart.value") + "' value='false' />"));
        }
        out.w((Object)"</table>");
        out.w((Object)"<div class='tableViewToolbar'; style='border-bottom: 1px solid black;'>");
        out.w((Object)"<input ").attr("class", "button").w((Object)" ").attr("type", "submit").w((Object)" ");
        out.attr("value", op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.upload.button"));
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            out.w((Object)" ").attr("disabled", "disabled");
        }
        out.w((Object)"/>&nbsp;");
        if (!hostIdStatus.isPerpetual()) {
            this.importEntitlement.writeButton(op);
        }
        out.w((Object)"</div>");
    }

    public BObject save(HxOp op) throws Exception {
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        sysService.poll();
        boolean licenseReadonly = sysService.getIsLicenseReadonly();
        BHostIdStatus hostIdStatus = sysService.getHostIdStatus();
        boolean isNiagaraHomeReadonly = sysService.getIsNiagaraHomeReadonly();
        BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
        licService.poll();
        BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService);
        if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
            throw new PermissionException("licenses readonly (" + licenseReadonly + ") or insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
        }
        BIFile file = op.getFile("file");
        if (file != null) {
            String extension = BajaFileUtil.getExtension((String)op.getFormValue("file"));
            if (extension == null) {
                extension = "";
            }
            if (extension.equalsIgnoreCase("lar")) {
                LicenseSync licenseSync;
                BLicenseArchiveFile lar = new BLicenseArchiveFile();
                lar.setStore(file.getStore());
                try {
                    licenseSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncLicenses((String)Nre.getHostId(), (LicenseInfo[])LicenseInfo.listLocal((boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly), (LicenseInfo[])LicenseInfo.make((VendorLicense[])lar.getLicenses())));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)licenseSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    BBoolean reboot = (BBoolean)this.rebootFE.save((BObject)BBoolean.FALSE, op);
                    BBoolean restart = (BBoolean)this.restartFE.save((BObject)BBoolean.FALSE, op);
                    if (reboot.getBoolean()) {
                        sysService.reboot();
                        HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemReboot.message"), op);
                    } else {
                        BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                        daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                        if (restart.getBoolean()) {
                            sysService.restartStation();
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemRestart.message"), op);
                        } else {
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.needRestart.message"), op);
                        }
                    }
                }
            } else if (extension.equalsIgnoreCase("license")) {
                LicenseSync licenseSync;
                LicenseInfo license = new LicenseInfo(file);
                if (!license.vendorLicense.getHostId().equals(Nre.getHostId())) {
                    throw new LocalizableRuntimeException("platform", "LicensePlatformServicePlugin.badHostId.message", new Object[]{op.getFormValue("file")});
                }
                LicenseInfo[] toInstall = new LicenseInfo[]{license};
                try {
                    licenseSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncLicenses((String)Nre.getHostId(), (LicenseInfo[])LicenseInfo.listLocal((boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly), (LicenseInfo[])toInstall));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)licenseSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    BBoolean reboot = (BBoolean)this.rebootFE.save((BObject)BBoolean.FALSE, op);
                    BBoolean restart = (BBoolean)this.restartFE.save((BObject)BBoolean.FALSE, op);
                    if (reboot.getBoolean()) {
                        sysService.reboot();
                        HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemReboot.message"), op);
                    } else {
                        BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                        daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                        if (restart.getBoolean()) {
                            sysService.restartStation();
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.systemRestart.message"), op);
                        } else {
                            HxMessageHelper.appendMessage("LicensePlatformServiceEditor", LexiconText.make((String)"platform", (String)"HxLicensePlatformServiceEditor.needRestart.message"), op);
                        }
                    }
                }
            } else if (extension.equalsIgnoreCase("certificate")) {
                LicenseSync certSync;
                CertificateInfo[] toInstall = new CertificateInfo[]{new CertificateInfo(file)};
                try {
                    certSync = AccessController.doPrivileged(() -> PortalLicenseUtil.syncCertificates((CertificateInfo[])CertificateInfo.listLocal((boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly), (CertificateInfo[])toInstall));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                if (this.sync(op, (LicenseSync<? extends IFileInfo>)certSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage")) {
                    BDaemonSession daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                    daemonSession.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                }
            } else {
                throw new LocalizableRuntimeException("platform", "HxLicensePlatformServiceEditor.badFileType.message", new Object[]{op.getFormValue("file")});
            }
        }
        return super.save(op);
    }

    private boolean sync(HxOp op, LicenseSync<? extends IFileInfo> sync, String currentMessage, String successMessage) throws Exception {
        if (sync == null) {
            return false;
        }
        StringBuilder m = new StringBuilder();
        Lexicon lex = op.getLexicon("platform");
        if (sync.unchanged()) {
            HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, lex.getHtmlSafeText(currentMessage), BColor.blue, op);
            return false;
        }
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        BHostIdStatus hostIdStatus = sysService.getHostIdStatus();
        m.append("<table cellpadding='5'>");
        m.append("<tr><td colspan='2'>");
        m.append(lex.getHtmlSafeText(successMessage));
        m.append("</td></tr>");
        m.append(this.syncOperationsMessageBuilder(op, sync));
        m.append("</table>");
        HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, m.toString(), BColor.blue, op);
        return true;
    }

    private boolean sync(HxOp op, LicenseSync<? extends IFileInfo> licenseSync, LicenseSync<? extends IFileInfo> certificateSync, String currentMessage, String successMessage) throws Exception {
        String message;
        if (certificateSync == null || licenseSync == null) {
            return false;
        }
        StringBuilder m = new StringBuilder();
        Lexicon lex = op.getLexicon("platform");
        if (licenseSync.unchanged() && certificateSync.unchanged()) {
            HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, lex.getHtmlSafeText(currentMessage), BColor.blue, op);
            return false;
        }
        m.append("<table cellpadding='5'>");
        m.append("<tr><td colspan='2'>");
        m.append(lex.getHtmlSafeText(successMessage));
        m.append("</td></tr>");
        if (!licenseSync.unchanged()) {
            message = this.syncOperationsMessageBuilder(op, licenseSync);
            m.append(message);
        }
        if (!certificateSync.unchanged()) {
            message = this.syncOperationsMessageBuilder(op, certificateSync);
            m.append(message);
        }
        m.append("</table>");
        HxMessageHelper.addMessage("LicensePlatformServiceEditor", null, m.toString(), BColor.blue, op);
        return true;
    }

    private String syncOperationsMessageBuilder(HxOp op, LicenseSync<? extends IFileInfo> sync) throws Exception {
        int i;
        StringBuilder m = new StringBuilder();
        Lexicon lex = op.getLexicon("platform");
        BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        BHostIdStatus hostIdStatus = sysService.getHostIdStatus();
        boolean isNiagaraHomeReadonly = sysService.getIsNiagaraHomeReadonly();
        int count = sync.toRemove.size();
        if (count > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.removed"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo remove = (IFileInfo)sync.toRemove.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        remove.getFile().delete();
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(Encode.forHtml((String)remove.toString((Context)op)));
                m.append("</td></tr>");
            }
        }
        if ((count = sync.toAdd.size()) > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.added"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo add = (IFileInfo)sync.toAdd.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        BIFile file = BFileSystem.INSTANCE.makeFile(add.getInstalledFilePath(true, hostIdStatus.isPerpetual(), isNiagaraHomeReadonly));
                        add.write(file.getOutputStream());
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(Encode.forHtml((String)add.toString((Context)op)));
                m.append("</td></tr>");
            }
        }
        if ((count = sync.toUpdate.size()) > 0) {
            m.append("<tr><td colspan='2'>");
            m.append(lex.getHtmlSafeText("UiUtil.updated"));
            m.append("</td></tr>");
            for (i = 0; i < count; ++i) {
                IFileInfo update = (IFileInfo)sync.toUpdate.get(i);
                try {
                    AccessController.doPrivileged(() -> {
                        BIFile file = BFileSystem.INSTANCE.makeFile(update.getInstalledFilePath(true, hostIdStatus.isPerpetual(), isNiagaraHomeReadonly));
                        update.write(file.getOutputStream());
                        return null;
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                m.append("<tr><td>&nbsp;</td><td width='100%'>");
                m.append(Encode.forHtml((String)update.toString((Context)op)));
                m.append("</td></tr>");
            }
        }
        return m.toString();
    }

    private BOrd getHostIdIndicatorImageOrd(BHostIdStatus hostIdStatus) {
        String iconName = hostIdStatus == BHostIdStatus.unregistered ? "questionMark" : (hostIdStatus == BHostIdStatus.cloned ? "error" : "check");
        return BOrd.make((String)("module://icons/x16/" + iconName + ".png"));
    }

    private String getHostIdFaultCause(BHostIdStatus hostIdStatus) {
        if (hostIdStatus == BHostIdStatus.cloned || hostIdStatus == BHostIdStatus.unregistered) {
            return this.getLexicon().getText("LicenseManager.hostIdFaultCause." + hostIdStatus.getTag());
        }
        return "";
    }

    private class ImportEntitlement
    extends Command {
        public ImportEntitlement() {
            super((BHxView)BHxLicensePlatformServiceEditor.this);
        }

        public String getInvokeCode(HxOp op) {
            return "if (confirm(\"" + op.getLexicon("platform").getHtmlSafeText("FileInfoTable.confirmImport") + "\"))" + super.getInvokeCode(op);
        }

        public void writeButton(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<input ").attr("class", "button").w((Object)" ").attr("type", "button").w((Object)" ");
            out.w((Object)"onclick='").w((Object)this.getInvokeCode(op)).w((Object)"' ");
            out.attr("value", this.getDisplayName(op));
            out.w((Object)"/>&nbsp;");
        }

        public void getEntitlement(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            boolean isNiagaraHomeReadonly = sysService.getIsNiagaraHomeReadonly();
            LicenseInfo[] installedLicenses = LicenseInfo.listLocal((boolean)false, (boolean)isNiagaraHomeReadonly);
            CertificateInfo[] installedCertificates = CertificateInfo.listLocal((boolean)false, (boolean)isNiagaraHomeReadonly);
            HashSet<LicenseInfo> entitlementLicenses = new HashSet<LicenseInfo>();
            HashSet<CertificateInfo> entitlementCerts = new HashSet<CertificateInfo>();
            HashSet<VendorLicense> vendorLicenses = new HashSet<VendorLicense>();
            HashSet<VendorCertificate> vendorCerts = new HashSet<VendorCertificate>();
            for (LicenseInfo licenseInfo : installedLicenses) {
                vendorLicenses.add(licenseInfo.vendorLicense);
            }
            for (LicenseInfo licenseInfo : installedCertificates) {
                vendorCerts.add(licenseInfo.vendorCertificate);
            }
            try {
                XElem[] licenseElems;
                SubscriptionLicenseManager slm = (SubscriptionLicenseManager)Sys.getLicenseManager();
                EntitlementApi.EntitlementStatus entitlementStatus = slm.getLicenseUpdate();
                for (XElem elem : licenseElems = entitlementStatus.getLicenses().elems("license")) {
                    VendorLicense updatedLicense = VendorLicense.make((String)"entitlement", (XElem)elem);
                    entitlementLicenses.add(new LicenseInfo(updatedLicense, null));
                }
            }
            catch (Exception e) {
                BHxView.log.log(Level.SEVERE, "Unable to get licenses from the Entitlement server.", e);
            }
            try {
                List<VendorCertificate> certList = UiUtil.getCertificateUpdate(new ArrayList<VendorCertificate>(vendorCerts));
                for (VendorCertificate cert : certList) {
                    entitlementCerts.add(new CertificateInfo(cert, null));
                }
            }
            catch (Exception e) {
                BHxView.log.log(Level.SEVERE, "Unable to get certificates from the Entitlement server.", e);
            }
            try {
                LicenseSync licenseSync = PortalLicenseUtil.syncLicenses((String)Nre.getHostId(), (LicenseInfo[])installedLicenses, (LicenseInfo[])entitlementLicenses.toArray(new LicenseInfo[0]));
                LicenseSync certificateSync = PortalLicenseUtil.syncCertificates((CertificateInfo[])installedCertificates, (CertificateInfo[])entitlementCerts.toArray(new CertificateInfo[0]));
                BHxLicensePlatformServiceEditor.this.sync(op, (LicenseSync<? extends IFileInfo>)licenseSync, (LicenseSync<? extends IFileInfo>)certificateSync, "LicensePlatformServicePlugin.sync.currentMessage", "LicensePlatformServicePlugin.sync.successMessage");
                this.refresh(op);
            }
            catch (Exception e) {
                BHxView.log.log(Level.SEVERE, "Unable to sync licenses or certificates.", e);
            }
        }

        public void handle(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            boolean licenseReadonly = sysService.getIsLicenseReadonly();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService);
            if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
                throw new PermissionException("licenses readonly (" + licenseReadonly + ") or insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
            }
            try {
                AccessController.doPrivileged(() -> {
                    this.getEntitlement(op);
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }

        public String getDisplayName(HxOp op) {
            return op.getLexicon("platform").getHtmlSafeText("HxLicensePlatformServiceEditor.import.button");
        }
    }

    private class Delete
    extends Command {
        private FileInfoTable table;
        private LexiconText label;

        public Delete(FileInfoTable table) {
            super((BHxView)BHxLicensePlatformServiceEditor.this);
            this.label = LexiconText.make((String)"bajaui", (String)"commands.delete.label");
            this.table = table;
        }

        public String getInvokeCode(HxOp op) {
            return "if (confirm(\"" + op.getLexicon("platform").getHtmlSafeText("FileInfoTable.confirmDelete") + "\"))" + super.getInvokeCode(op);
        }

        public void writeButton(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            boolean licenseReadonly = sysService.getIsLicenseReadonly();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<input ").attr("class", "button").w((Object)" ").attr("type", "button").w((Object)" ");
            out.w((Object)"onclick='").w((Object)this.getInvokeCode(op)).w((Object)"' ");
            out.attr("value", this.getDisplayName(op));
            if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
                out.w((Object)" ").attr("disabled", "disabled");
            }
            out.w((Object)"/>&nbsp;");
        }

        public void handle(HxOp op) throws Exception {
            BSystemPlatformService sysService = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            sysService.poll();
            boolean licenseReadonly = sysService.getIsLicenseReadonly();
            BLicensePlatformService licService = (BLicensePlatformService)Sys.getService((Type)BLicensePlatformService.TYPE);
            licService.poll();
            BPermissions perms = BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService);
            if (licenseReadonly || !BUser.getCurrentAuthenticatedUser().getPermissionsFor((BIProtected)licService).hasAdminInvoke()) {
                throw new PermissionException("licenses readonly (" + licenseReadonly + ") or insufficient permissions " + perms.toString(null) + " < " + BPermissions.adminInvoke.toString(null));
            }
            try {
                AccessController.doPrivileged(() -> {
                    IFileInfo[] fileInformation;
                    for (IFileInfo info : fileInformation = this.table.getSelected(op)) {
                        info.getFile().delete();
                    }
                    if (fileInformation.length > 0) {
                        this.refresh(op);
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }

        public String getDisplayName(HxOp op) {
            return this.label.getHtmlSafeText((Context)op);
        }
    }
}

