/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.ui.history;

import com.tridium.nc.ui.history.BCloudHistoryExportManager;
import com.tridium.nc.ui.history.HistoryNavNameColumn;
import java.util.ArrayList;
import java.util.Collections;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BHistoryExportManager;
import javax.baja.driver.ui.history.ExportLearn;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class CloudExportLearn
extends ExportLearn {
    private static final Lexicon lex = Lexicon.make(BCloudHistoryExportManager.class);
    private static final String lexLocal = lex.getText("historyExportManager.local");
    private String parentStationName = "";

    public CloudExportLearn(BHistoryExportManager manager) {
        super(manager);
    }

    public Object[] getDiscovery(BComponent target) {
        Object[] d = super.getDiscovery(target);
        this.parentStationName = null;
        for (BComponent parent = target; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BStation)) continue;
            this.parentStationName = ((BStation)parent).getStationName();
            break;
        }
        ArrayList result = new ArrayList(d.length);
        Collections.addAll(result, d);
        return result.toArray();
    }

    public boolean isExisting(Object discovery, BComponent component) {
        BHistoryId expId;
        if (!(discovery instanceof BIHistory)) {
            return false;
        }
        if (!(component instanceof BHistoryExport)) {
            return false;
        }
        BIHistory h = (BIHistory)discovery;
        BHistoryExport exp = (BHistoryExport)component;
        BHistoryId id = h.getId();
        return id.equals((Object)(expId = exp.getHistoryId())) || expId.equals((Object)id.toShorthand(this.parentStationName));
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new HistoryNavNameColumn(histLex.getText("historyId"))};
    }

    public void toRow(Object discovery, MgrEditRow row) throws Exception {
        BIHistory history = (BIHistory)discovery;
        BHistoryId shorthandId = history.getId().toShorthand(this.parentStationName);
        String name = shorthandId.toString();
        name = name.startsWith("^", 0) ? lexLocal + '_' + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        row.setDefaultName(name);
        row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)shorthandId);
    }
}

