/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.driver.BDeviceNodeEvent;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;

@NiagaraType
@NiagaraTopic(name="nodeChecked", eventType="BDeviceNodeEvent")
public class BDeviceTree
extends BTree {
    @Generated
    public static final Topic nodeChecked = BDeviceTree.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceTree.class);

    @Generated
    public void fireNodeChecked(BDeviceNodeEvent event) {
        this.fire(nodeChecked, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceTree() {
        throw new UnsupportedOperationException();
    }

    public BDeviceTree(BDeviceNetwork nw, Set<BSimple> idsToOmit) {
        super((TreeModel)new DeviceTreeModel(nw, idsToOmit), (TreeController)new DeviceTreeController());
        this.setNodeRenderer(new DeviceTreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    public DeviceTreeModel getDeviceTreeModel() {
        return (DeviceTreeModel)this.getModel();
    }

    public void setController(TreeController controller) {
        super.setController(controller);
    }

    public DeviceTreeController getDeviceTreeController() {
        return (DeviceTreeController)this.getController();
    }

    public DeviceTreeNodeRenderer getDeviceTreeNodeRenderer() {
        return (DeviceTreeNodeRenderer)this.getNodeRenderer();
    }

    public static class DeviceTreeNodeRenderer
    extends TreeNodeRenderer {
        public double getWidth(TreeNode node) {
            return super.getWidth(node) + 10.0 + 2.0;
        }

        public BBrush getForeground(TreeNode node) {
            CheckNode dtn = (CheckNode)node;
            return dtn.isCheckEnabled() ? Theme.checkBox().getControlForeground() : Theme.checkBox().getControlShadow();
        }

        public void paintNode(Graphics g, TreeNode node, double x, double y) {
            super.paintNode(g, node, x + 12.0, y);
            CheckNode dtn = (CheckNode)node;
            double cy = y + this.getHeight() / 2.0 - 5.0;
            double cw = 10.0;
            double ch = 10.0;
            g.setBrush(this.getForeground(node));
            g.strokeRect(x, cy, cw, ch);
            if (dtn.isChecked()) {
                g.strokeLine(x, cy, x + cw, cy + ch);
                g.strokeLine(x, cy + cw, x + cw, cy);
            }
        }
    }

    public static class DeviceNode
    extends CheckNode {
        private BDevice device;
        private BImage enabledIcon;
        private BImage disabledIcon;

        public DeviceNode(BDevice device, DeviceTreeModel model) {
            super(model);
            this.init(device);
        }

        public DeviceNode(BDevice device, FolderNode parent) {
            super(parent);
            this.init(device);
        }

        private void init(BDevice device) {
            this.device = device;
            device.lease(1);
            this.enabledIcon = BImage.make((BIcon)device.getIcon());
            this.disabledIcon = this.enabledIcon.getDisabledImage();
        }

        public BDevice getDevice() {
            return this.device;
        }

        public String getText() {
            return this.device.getDisplayName(null) + " " + this.device.getStatus().toString();
        }

        public BImage getIcon() {
            return this.checkEnabled ? this.enabledIcon : this.disabledIcon;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int index) {
            return null;
        }
    }

    public static class FolderNode
    extends CheckNode {
        private BDeviceFolder folder;
        private List<TreeNode> childNodes;
        private BImage enabledIcon;
        private BImage disabledIcon;

        public FolderNode(BDeviceFolder folder, DeviceTreeModel model) {
            super(model);
            this.init(folder);
        }

        public FolderNode(BDeviceFolder folder, FolderNode parent) {
            super(parent);
            this.init(folder);
        }

        private void init(BDeviceFolder folder) {
            this.folder = folder;
            this.enabledIcon = BImage.make((BIcon)folder.getIcon());
            this.disabledIcon = this.enabledIcon.getDisabledImage();
            this.childNodes = new ArrayList<TreeNode>();
            folder.lease(1);
            try {
                SlotCursor c = folder.getProperties();
                while (c.next()) {
                    if (c.get() instanceof BDeviceFolder) {
                        this.childNodes.add(new FolderNode((BDeviceFolder)c.get(), this));
                        continue;
                    }
                    if (!(c.get() instanceof BDevice)) continue;
                    BDevice device = (BDevice)c.get();
                    if (this.getDeviceTreeModel().shouldOmitDevice(device)) continue;
                    this.childNodes.add(new DeviceNode(device, this));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setExpanded(true);
        }

        public BDeviceFolder getFolder() {
            return this.folder;
        }

        public String getText() {
            return this.folder.getDisplayName(null);
        }

        public BImage getIcon() {
            return this.checkEnabled ? this.enabledIcon : this.disabledIcon;
        }

        public int getChildCount() {
            return this.childNodes.size();
        }

        public TreeNode getChild(int index) {
            return this.childNodes.get(index);
        }
    }

    public static abstract class CheckNode
    extends TreeNode {
        protected boolean checked = false;
        protected boolean checkEnabled = true;

        public CheckNode(DeviceTreeModel model) {
            super((TreeModel)model);
        }

        public CheckNode(FolderNode parent) {
            super((TreeNode)parent);
        }

        public boolean inCheckBox(double x) {
            double checkBoxX = this.getX() + Theme.tree().getExpanderWidth() + 10.0;
            return x >= checkBoxX && x <= checkBoxX + 10.0;
        }

        public DeviceTreeModel getDeviceTreeModel() {
            return (DeviceTreeModel)this.getModel();
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.setChecked(value, BTreeCascadePolicy.never, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants) {
            this.setChecked(value, cascadeDescendants, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors, boolean observeEnabled) {
            BDeviceNodeEvent event = new BDeviceNodeEvent();
            this.setChecked(value, cascadeDescendants, cascadeAncestors, event, observeEnabled);
            ((DeviceTreeModel)this.getModel()).fireNodeChecked(event);
        }

        private void setChecked(boolean value, BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors, BDeviceNodeEvent event, boolean observeEnabled) {
            TreeNode parent;
            if (this.checked != value && (this.isCheckEnabled() || !observeEnabled)) {
                this.checked = value;
                event.addNode(this);
            }
            if (cascadeDescendants.cascade(value)) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    if (!(this.getChild(i) instanceof CheckNode)) continue;
                    ((CheckNode)this.getChild(i)).setChecked(value, BTreeCascadePolicy.always, BTreeCascadePolicy.never, event, observeEnabled);
                }
            }
            if (cascadeAncestors.cascade(value) && (parent = this.getParent()) != null && parent instanceof CheckNode) {
                ((CheckNode)parent).setChecked(value, BTreeCascadePolicy.never, BTreeCascadePolicy.always, event, observeEnabled);
            }
            this.getDeviceTreeModel().updateTree();
        }

        public boolean isCheckEnabled() {
            return this.checkEnabled;
        }

        public void setCheckEnabled(boolean value) {
            this.setCheckEnabled(value, false);
        }

        public void setCheckEnabled(boolean value, boolean cascade) {
            this.checkEnabled = value;
            if (cascade) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DeviceNode)this.getChild(i)).setCheckEnabled(value, true);
                }
            }
        }

        public void toggleChecked() {
            this.toggleChecked(BTreeCascadePolicy.never, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy cascadeDescendants) {
            this.toggleChecked(cascadeDescendants, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy cascadeDescendants, BTreeCascadePolicy cascadeAncestors) {
            this.setChecked(!this.isChecked(), cascadeDescendants, cascadeAncestors, true);
        }
    }

    public static class DeviceTreeModel
    extends TreeModel {
        private List<CheckNode> roots;
        public Set<BSimple> idsToOmit;
        public BNetworkBatchAgent batchAgent;

        public DeviceTreeModel(BDeviceNetwork nw, Set<BSimple> idsToOmit) {
            this.idsToOmit = idsToOmit;
            this.roots = new ArrayList<CheckNode>();
            this.batchAgent = BNetworkBatchAgent.get((BDeviceNetwork)nw, null);
            nw.lease(1);
            SlotCursor c = nw.getProperties();
            while (c.next()) {
                BDevice device;
                if (c.get() instanceof BDeviceFolder) {
                    this.roots.add(new FolderNode((BDeviceFolder)c.get(), this));
                    continue;
                }
                if (!(c.get() instanceof BDevice) || this.shouldOmitDevice(device = (BDevice)c.get())) continue;
                this.roots.add(new DeviceNode(device, this));
            }
        }

        public void fireNodeChecked(BDeviceNodeEvent event) {
            if (this.getTree() instanceof BDeviceTree) {
                ((BDeviceTree)this.getTree()).fireNodeChecked(event);
            }
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public Iterator<BDevice> getCheckedDevices() {
            return this.getCheckedDevices(true);
        }

        public Iterator<BDevice> getCheckedDevices(boolean checkValue) {
            ArrayList<BDevice> result = new ArrayList<BDevice>();
            for (CheckNode root : this.roots) {
                this.getCheckedDevices(root, checkValue, result);
            }
            return result.iterator();
        }

        private void getCheckedDevices(CheckNode node, boolean checkValue, Collection<BDevice> list) {
            if (node instanceof DeviceNode && node.isChecked() == checkValue) {
                list.add(((DeviceNode)node).getDevice());
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.getCheckedDevices((CheckNode)node.getChild(i), checkValue, list);
            }
        }

        public TreeNode getRoot(int index) {
            return this.roots.get(index);
        }

        public CheckNode getCheckNode(int index) {
            return (CheckNode)this.getRoot(index);
        }

        public boolean shouldOmitDevice(BDevice device) {
            return this.idsToOmit.contains(this.batchAgent.getBatchDeviceId(device));
        }
    }

    public static class DeviceTreeController
    extends TreeController {
        private BTreeCascadePolicy cascadeAncestorPolicy = BTreeCascadePolicy.never;
        private BTreeCascadePolicy cascadeDescendantPolicy = BTreeCascadePolicy.always;

        public void mousePressed(BMouseEvent evt) {
            this.getTree().requestFocus();
            double x = evt.getX();
            double y = evt.getY();
            CheckNode target = (CheckNode)this.getTree().yToTreeNode(y);
            if (target != null) {
                if (target.inExpander(x, y)) {
                    this.getTree().toggleExpanded((TreeNode)target);
                } else if (target.inCheckBox(x)) {
                    if (target.isCheckEnabled()) {
                        target.toggleChecked(this.getCascadeDescendantPolicy(), this.getCascadeAncestorPolicy());
                        this.getTree().relayout();
                    }
                } else if (target.isSelection(x, y)) {
                    this.mouseSelection(target, evt);
                    if (!evt.isButton3Down() && evt.getClickCount() == 2) {
                        this.doSelectAction(target, evt.getX(), evt.getY());
                    }
                } else {
                    target = null;
                    this.mouseSelection(null, evt);
                }
            } else {
                this.mouseSelection(null, evt);
            }
            if (evt.isPopupTrigger()) {
                this.popup(evt, target);
            }
        }

        public BTreeCascadePolicy getCascadeAncestorPolicy() {
            return this.cascadeAncestorPolicy;
        }

        public void setCascadeAncestorPolicy(BTreeCascadePolicy value) {
            this.cascadeAncestorPolicy = value;
        }

        public BTreeCascadePolicy getCascadeDescendantPolicy() {
            return this.cascadeDescendantPolicy;
        }

        public void setCascadeDescendantPolicy(BTreeCascadePolicy value) {
            this.cascadeDescendantPolicy = value;
        }
    }
}

