/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.driver.BDeviceTree;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraTopics(value={@NiagaraTopic(name="listUpdated", eventType="BWidgetEvent"), @NiagaraTopic(name="transferWidgetFocusGained", eventType="BFocusEvent")})
public class BDeviceList
extends BList
implements CommandBindings.Support {
    @Generated
    public static final Topic listUpdated = BDeviceList.newTopic((int)0, null);
    @Generated
    public static final Topic transferWidgetFocusGained = BDeviceList.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceList.class);
    private BDeviceNetwork network = null;
    private BNetworkBatchAgent batchAgent = null;
    private BWidget container;
    private Model model;
    public static final Lexicon lex = Lexicon.make((String)"batchJob");
    private static final Logger LOGGER = Logger.getLogger("batchJob");

    @Generated
    public void fireListUpdated(BWidgetEvent event) {
        this.fire(listUpdated, (BValue)event, null);
    }

    @Generated
    public void fireTransferWidgetFocusGained(BFocusEvent event) {
        this.fire(transferWidgetFocusGained, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeviceList() {
        throw new UnsupportedOperationException();
    }

    public BDeviceList(String headerText) {
        CommandBindings bindings = new CommandBindings();
        bindings.setSupport((CommandBindings.Support)this);
        AddDevice addDevice = new AddDevice();
        bindings.addCommand((Command)addDevice, BCommandEnablePolicy.always);
        bindings.addCommand((Command)new PasteFromClipboard(), BCommandEnablePolicy.always);
        MoveDeviceUp moveDeviceUp = new MoveDeviceUp();
        bindings.addCommand((Command)moveDeviceUp, BCommandEnablePolicy.singleSelection);
        MoveDeviceDown moveDeviceDown = new MoveDeviceDown();
        bindings.addCommand((Command)moveDeviceDown, BCommandEnablePolicy.singleSelection);
        RemoveDevice removeDevice = new RemoveDevice();
        bindings.addCommand((Command)removeDevice, BCommandEnablePolicy.anySelection);
        this.setController((ListController)new Controller(bindings));
        this.setSelection((ListSelection)new CommandBindings.ListSelection(bindings));
        this.model = new Model();
        this.setModel(this.model);
        BBorderPane border = new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BButtonPane(BButtonStyle.toolBar, new Command[]{addDevice, moveDeviceUp, moveDeviceDown, removeDevice}, false, true), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 4.0, 0.0)));
        border.setBorder(BBorder.solid);
        border.setLabel((BWidget)new BLabel(headerText));
        border.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.container = border;
    }

    private BDeviceNetwork getDeviceNetwork() {
        return this.network;
    }

    public BWidget getContainer() {
        return this.container;
    }

    public BSimple[] getDeviceIds() {
        BSimple[] result = new BSimple[this.model.getItemCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.model.getDeviceId(i);
        }
        return result;
    }

    public int dragOver(TransferContext cx) {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            for (BObject value : mark.getValues()) {
                if ((!(value instanceof BDevice) || !this.batchAgent.isBatchDevice((BDevice)value)) && !value.getType().is(this.network.getDeviceFolderType()) && !value.equivalent((Object)this.network)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (cx.isCopy() && cx.getEnvelope().supports(TransferFormat.mark)) {
            int row = this.getItemIndexAt(cx.getX(), cx.getY());
            Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
            for (BObject value : mark.getValues()) {
                if (value instanceof BDevice && this.batchAgent.isBatchDevice((BDevice)value)) {
                    if (row < 0) {
                        this.model.addItem(null, value);
                        continue;
                    }
                    this.model.insertItem(row, null, value);
                    continue;
                }
                if (!value.getType().is(this.network.getDeviceFolderType()) && !value.equivalent((Object)this.network)) continue;
                if (row < 0) {
                    this.model.addItem(null, value);
                    continue;
                }
                this.model.insertItem(row, null, value);
            }
        }
        return null;
    }

    public void addDevices(BSimple[] deviceIds) {
        for (BSimple deviceId : deviceIds) {
            this.addDevice(deviceId);
        }
    }

    public void addDevice(BSimple deviceId) {
        BDevice device = this.batchAgent.getBatchDevice(this.getDeviceNetwork(), deviceId);
        if (device != null) {
            this.addDevice(device);
        }
    }

    public void addDevices(BDevice[] devices) {
        for (BDevice device : devices) {
            this.addDevice(device);
        }
    }

    public void addDevice(BDevice device) {
        if (this.batchAgent.isBatchDevice(device)) {
            this.model.addItem(null, device);
        }
    }

    public void load(BDeviceNetwork network) {
        this.network = network;
        this.batchAgent = BNetworkBatchAgent.get((BDeviceNetwork)network, null);
        this.model.removeAllItems();
    }

    public void loadFromJob(BDeviceNetworkJob job) {
        this.load(job.getNetwork());
        this.addDevices(job.getDevices());
    }

    public void saveToJob(BDeviceNetworkJob job) {
        job.setDevicesToProcess(BValueList.make((BValue[])this.getDeviceIds()));
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command instanceof DeviceListCommand) {
            ((DeviceListCommand)command).checkEnabled(bindingBasedState);
        } else {
            command.setEnabled(bindingBasedState);
        }
    }

    private class Controller
    extends CommandBindings.ListController {
        public Controller(CommandBindings bindings) {
            super(bindings);
        }

        public void focusGained(BFocusEvent event) {
            BDeviceList.this.fireTransferWidgetFocusGained(event);
        }
    }

    private class Model
    extends ListModel {
        private List<BSimple> deviceIds = new ArrayList<BSimple>();
        private Map<BSimple, BDevice> deviceById = new HashMap<BSimple, BDevice>();

        private Model() {
        }

        public BDevice[] getAvailableDevices() {
            ArrayList<BDevice> result = new ArrayList<BDevice>();
            try {
                for (BDevice device : BDeviceList.this.batchAgent.listBatchDevices(BDeviceList.this.getDeviceNetwork())) {
                    if (this.deviceById.containsKey(BDeviceList.this.batchAgent.getBatchDeviceId(device))) continue;
                    result.add(device);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception occurred building available device list", e);
            }
            return result.toArray(new BDevice[0]);
        }

        public synchronized void swapItems(int idx1, int idx2) {
            BSimple temp = this.deviceIds.get(idx1);
            this.deviceIds.set(idx1, this.deviceIds.get(idx2));
            this.deviceIds.set(idx2, temp);
            this.updateList();
        }

        public synchronized void addDeviceFolder(BIDeviceFolder folder, boolean update) {
            BComponent parent = (BComponent)folder;
            parent.lease(1);
            SlotCursor c = parent.getProperties();
            while (c.next()) {
                BValue o = c.get();
                if (o instanceof BIDeviceFolder) {
                    this.addDeviceFolder((BIDeviceFolder)o, false);
                    continue;
                }
                if (!(o instanceof BDevice)) continue;
                this.addDevice((BDevice)o, false);
            }
            if (update) {
                this.updateList();
            }
        }

        public synchronized void addItem(BImage ignored, Object value) {
            if (value instanceof BIDeviceFolder) {
                this.addDeviceFolder((BIDeviceFolder)value, true);
            } else if (value instanceof BDevice) {
                this.addDevice((BDevice)value, true);
            }
        }

        public synchronized void addDevice(BDevice device, boolean update) {
            BSimple deviceId = BDeviceList.this.batchAgent.getBatchDeviceId(device);
            if (!SlotPath.isValidName((String)SlotPath.unescape((String)deviceId.toString()))) {
                BDialog.error((BWidget)BDeviceList.this, (Object)lex.getText("DeviceList.invalidDeviceName", new Object[]{deviceId.toString()}));
                return;
            }
            if (!this.deviceById.containsKey(deviceId)) {
                this.deviceById.put(deviceId, device);
                this.deviceIds.add(deviceId);
                if (update) {
                    this.updateList();
                }
            }
        }

        public synchronized int insertDeviceFolder(int index, BIDeviceFolder folder, boolean update) {
            BComponent parent = (BComponent)folder;
            parent.lease(1);
            SlotCursor c = parent.getProperties();
            while (c.next()) {
                BValue o = c.get();
                if (o instanceof BIDeviceFolder) {
                    index = this.insertDeviceFolder(index, (BIDeviceFolder)o, false);
                    continue;
                }
                if (!(o instanceof BDevice)) continue;
                this.insertDevice(index++, o, false);
            }
            if (update) {
                this.updateList();
            }
            return index;
        }

        public synchronized void insertItem(int index, BImage ignored, Object value) {
            if (value instanceof BDevice) {
                this.insertDevice(index, value, true);
            } else if (value instanceof BIDeviceFolder) {
                this.insertDeviceFolder(index, (BIDeviceFolder)value, true);
            }
        }

        public synchronized void insertDevice(int index, Object value, boolean update) {
            BDevice device = (BDevice)value;
            BSimple deviceId = BDeviceList.this.batchAgent.getBatchDeviceId(device);
            if (!this.deviceById.containsKey(deviceId)) {
                this.deviceIds.add(index, deviceId);
                this.deviceById.put(deviceId, device);
                if (update) {
                    this.updateList();
                }
            }
        }

        public synchronized void removeItem(Object value) {
            BDevice device = (BDevice)value;
            BSimple deviceId = BDeviceList.this.batchAgent.getBatchDeviceId(device);
            this.deviceIds.remove(deviceId);
            this.deviceById.remove(deviceId);
            this.updateList();
        }

        public void removeItem(int index) {
            this.removeItem(this.getDevice(index));
        }

        public synchronized void removeAllItems() {
            this.deviceById.clear();
            this.deviceIds.clear();
            this.updateList();
        }

        public int getItemCount() {
            return this.deviceIds.size();
        }

        public BImage getItemIcon(int index) {
            BDevice device = this.getDevice(index);
            return device == null ? null : BImage.make((BIcon)device.getIcon());
        }

        public Object getItem(int index) {
            BSimple deviceId = this.getDeviceId(index);
            BDevice device = BDeviceList.this.batchAgent.getBatchDevice(BDeviceList.this.getDeviceNetwork(), deviceId);
            return device == null ? lex.getText("DeviceList.invalidDevice", new Object[]{deviceId}) : device.getDisplayName(null);
        }

        public BSimple getDeviceId(int index) {
            return this.deviceIds.get(index);
        }

        public BDevice getDevice(int index) {
            return BDeviceList.this.batchAgent.getBatchDevice(BDeviceList.this.getDeviceNetwork(), this.getDeviceId(index));
        }

        public void updateList() {
            super.updateList();
            BDeviceList.this.fireListUpdated(new BWidgetEvent(1, (BWidget)this.getList()));
        }
    }

    private class PasteFromClipboard
    extends Command {
        public PasteFromClipboard() {
            super((BWidget)BDeviceList.this, (Lexicon)UiLexicon.bajaui(), "commands.paste");
        }

        public synchronized boolean isEnabled() {
            TransferEnvelope envelope = Clipboard.getDefault().getContents();
            if (envelope != null && envelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)envelope.getData(TransferFormat.mark);
                for (BObject value : mark.getValues()) {
                    if (!(value instanceof BDevice) || !BDeviceList.this.batchAgent.isBatchDevice((BDevice)value)) continue;
                    return true;
                }
            }
            return false;
        }

        public CommandArtifact doInvoke() {
            TransferEnvelope envelope = Clipboard.getDefault().getContents();
            if (envelope != null && envelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)envelope.getData(TransferFormat.mark);
                for (BObject value : mark.getValues()) {
                    if (!(value instanceof BDevice) || !BDeviceList.this.batchAgent.isBatchDevice((BDevice)value)) continue;
                    BDeviceList.this.model.addItem(null, value);
                }
            }
            return null;
        }
    }

    private class RemoveDevice
    extends DeviceListCommand {
        public RemoveDevice() {
            super("DeviceList.remove");
        }

        public CommandArtifact doInvoke() {
            int[] sel = BDeviceList.this.model.getSelection().getItems();
            for (int i = sel.length; i > 0; --i) {
                BDeviceList.this.model.removeItem(sel[i - 1]);
            }
            BDeviceList.this.model.getSelection().deselectAll();
            return null;
        }
    }

    private class MoveDeviceDown
    extends DeviceListCommand {
        public MoveDeviceDown() {
            super("DeviceList.moveDown");
        }

        public CommandArtifact doInvoke() {
            int sel = BDeviceList.this.model.getSelection().getItems()[0];
            BDeviceList.this.model.swapItems(sel, sel + 1);
            BDeviceList.this.model.getSelection().select(sel + 1, true);
            return null;
        }

        @Override
        public void checkEnabled(boolean bindingBasedState) {
            if (bindingBasedState) {
                int sel = BDeviceList.this.model.getSelection().getItems()[0];
                if (sel == BDeviceList.this.model.getModel().getItemCount() - 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class MoveDeviceUp
    extends DeviceListCommand {
        public MoveDeviceUp() {
            super("DeviceList.moveUp");
        }

        public CommandArtifact doInvoke() {
            int sel = BDeviceList.this.model.getSelection().getItems()[0];
            BDeviceList.this.model.swapItems(sel, sel - 1);
            BDeviceList.this.model.getSelection().select(sel - 1, true);
            return null;
        }

        @Override
        public void checkEnabled(boolean bindingBasedState) {
            if (bindingBasedState) {
                int sel = BDeviceList.this.model.getSelection().getItems()[0];
                if (sel == 0) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bindingBasedState);
                }
            } else {
                this.setEnabled(bindingBasedState);
            }
        }
    }

    private class CheckAllCommand
    extends DialogCommand {
        private BDeviceTree tree;

        public CheckAllCommand(BDeviceTree tree) {
            super((BWidget)BDeviceList.this, -1, lex, "DeviceList.add.checkAll");
            this.tree = tree;
        }

        public CommandArtifact doInvoke() {
            try {
                int count = this.tree.getDeviceTreeModel().getRootCount();
                for (int i = 0; i < count; ++i) {
                    this.tree.getDeviceTreeModel().getCheckNode(i).setChecked(true, BTreeCascadePolicy.always);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class AddDevice
    extends DeviceListCommand {
        public AddDevice() {
            super("DeviceList.add");
        }

        public CommandArtifact doInvoke() {
            try {
                BDevice[] devices = BDeviceList.this.model.getAvailableDevices();
                if (devices.length == 0) {
                    if (BDeviceList.this.model.getItemCount() > 0) {
                        BDialog.message((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.noMoreDevices.dlgTitle"), (Object)lex.getText("DeviceList.add.noMoreDevices.dlgMessage"));
                    } else {
                        BDialog.message((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.noDevices.dlgTitle"), (Object)lex.getText("DeviceList.add.noDevices.dlgMessage"));
                    }
                    return null;
                }
                HashSet<BSimple> idsToOmit = new HashSet<BSimple>();
                for (int i = 0; i < BDeviceList.this.model.getItemCount(); ++i) {
                    idsToOmit.add(BDeviceList.this.model.getDeviceId(i));
                }
                BDeviceTree tree = new BDeviceTree(BDeviceList.this.getDeviceNetwork(), idsToOmit);
                BBrush bgcolor = Theme.scrollPane().getControlBackground();
                BScrollPane scrollpane = new BScrollPane((BWidget)tree);
                scrollpane.setViewportBackground(bgcolor);
                scrollpane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BFlowPane header = new BFlowPane(BHalign.left);
                header.add("label", (BValue)new BLabel(lex.getText("DeviceList.add.dlgMessage")));
                if (1 == BCommandDialog.open((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)header, (BWidget)new BBox(250.0, 0.0), (BWidget)new BBox(0.0, 300.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)scrollpane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{new CheckAllCommand(tree), DialogCommand.makeOk((BWidget)BDeviceList.this), DialogCommand.makeCancel((BWidget)BDeviceList.this)})) {
                    Iterator<BDevice> i = tree.getDeviceTreeModel().getCheckedDevices();
                    while (i.hasNext()) {
                        BDeviceList.this.model.addItem(null, i.next());
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private abstract class DeviceListCommand
    extends Command {
        public DeviceListCommand(String tag) {
            super((BWidget)BDeviceList.this, lex, tag);
        }

        public void checkEnabled(boolean bindingBasedState) {
            this.setEnabled(bindingBasedState);
        }
    }
}

