/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.ui.JobTable;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.util.LabelUtil;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.gx.BInsets;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"batchJob:JobStepDetails"})})
public class BJobStepDetailsView
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BJobStepDetailsView.class);
    protected JobTable.LogModel model;
    protected BGridPane upperPane;
    protected BButtonPane buttons;
    protected Command refreshLogCommand;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;
    private static final Lexicon lex = Lexicon.make((String)"batchJob");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BJobStepDetailsView() {
        this.autoRegisterForComponentEvents = false;
        this.upperPane = new BGridPane(2);
        this.upperPane.setHalign(BHalign.left);
        this.buttons = new BButtonPane();
        BTable table = JobTable.makeLogDisplay();
        this.model = (JobTable.LogModel)table.getModel();
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)this.upperPane, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), (BWidget)new BBorderPane((BWidget)this.buttons, BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.upperPane.removeAll();
        this.buttons.removeAll();
        BJobStepDetails details = (BJobStepDetails)value;
        for (BComplex parent = details.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BBatchJob)) continue;
            this.buttons.add((Command)new GoJobCommand((BBatchJob)parent));
            break;
        }
        this.loadDetails((BWidget)this, value, details, this.upperPane, this.buttons, this.model);
    }

    public void loadDetails(BWidget owner, BObject base, BJobStepDetails details, BGridPane upperPane, BButtonPane buttons, JobTable.LogModel logModel) throws Exception {
        BLabel typeLabel = new BLabel();
        this.startedLabel = new BLabel();
        this.endedLabel = new BLabel();
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.type"), (BWidget)typeLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.started"), (BWidget)this.startedLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.ended"), (BWidget)this.endedLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"JobStepDetailsView.state"), (BWidget)this.stateLabel);
        typeLabel.setText(details.getStepDescription());
        this.startedLabel.setText(details.getStartTime().toString());
        this.endedLabel.setText(details.getStartTime().toString());
        this.stateLabel.setText(details.getState().toString());
        logModel.load(details.readLog().toString());
        this.refreshLogCommand = new RefreshLogCommand(details);
        this.refreshLogCommand.setEnabled(!details.getState().isComplete());
        buttons.add(this.refreshLogCommand);
        if (details.isMounted() && !details.getState().isComplete()) {
            this.registerForComponentEvents((BComponent)details, Integer.MAX_VALUE);
        }
    }

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BJobStepDetails && evt.getId() == 0) {
            if (evt.getSlot() == BJobStepDetails.startTime) {
                this.startedLabel.setText(evt.getValue().toString());
            } else if (evt.getSlot() == BJobStepDetails.endTime) {
                this.endedLabel.setText(evt.getValue().toString());
            } else if (evt.getSlot() == BJobStepDetails.state) {
                if (((BJobState)evt.getValue()).isComplete()) {
                    try {
                        this.model.load(((BJobStepDetails)evt.getSourceComponent()).readLog().toString());
                        this.refreshLogCommand.setEnabled(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stateLabel.setText(evt.getValue().toString());
            }
        }
    }

    protected class RefreshLogCommand
    extends Command {
        private BJobStepDetails details;

        public RefreshLogCommand(BJobStepDetails details) {
            super((BWidget)BJobStepDetailsView.this, lex, "JobStepDetailsView.refreshLogCommand");
            this.details = details;
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetailsView.this.model.load(this.details.readLog().toString());
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class GoJobCommand
    extends Command {
        private BBatchJob job;

        public GoJobCommand(BBatchJob job) {
            super((BWidget)BJobStepDetailsView.this, lex, "JobStepDetailsView.goJobCommand");
            this.job = job;
        }

        public CommandArtifact doInvoke() {
            try {
                BJobStepDetailsView.this.getWbShell().hyperlink(this.job.getNavOrd());
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

