/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.util;

import com.tridium.util.EngineCycleQueue;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="rate", type="int", defaultValue="50", flags=4, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"millisecond\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(4000)")}), @NiagaraProperty(name="maxSize", type="int", defaultValue="1000", flags=4, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)")})})
public abstract class BEngineCycleQueue<T>
extends BComponent {
    @Generated
    public static final Property rate = BEngineCycleQueue.newProperty((int)4, (int)50, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"millisecond")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)4000))));
    @Generated
    public static final Property maxSize = BEngineCycleQueue.newProperty((int)4, (int)1000, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Type TYPE = Sys.loadType(BEngineCycleQueue.class);
    private EngineCycleQueue<T> engineCycleQueue;

    @Generated
    public int getRate() {
        return this.getInt(rate);
    }

    @Generated
    public void setRate(int v) {
        this.setInt(rate, v, null);
    }

    @Generated
    public int getMaxSize() {
        return this.getInt(maxSize);
    }

    @Generated
    public void setMaxSize(int v) {
        this.setInt(maxSize, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStation()) {
            this.engineCycleQueue = new EngineCycleQueue(this.getSlotPath().toString(), this::consumeMessage, (long)this.getRate(), this.getMaxSize());
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && this.engineCycleQueue != null) {
            if (property.equals(maxSize)) {
                this.engineCycleQueue.setMaxQueueSize(this.getMaxSize());
            }
            if (property.equals(rate)) {
                this.engineCycleQueue.setSleepBetweenDequeues((long)this.getRate());
            }
        }
    }

    public void stopped() {
        if (this.engineCycleQueue != null) {
            this.engineCycleQueue.stop();
        }
    }

    public BIcon getIcon() {
        return BIcon.std((String)"connection.png");
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BJsonSchemaService.post(this, action, argument, cx);
    }

    public int size() {
        return this.engineCycleQueue.size();
    }

    protected void enqueueMessage(T message) {
        this.engineCycleQueue.performEnqueue(message);
    }

    protected void consumeMessage(T message) {
        this.setOutValue(message);
    }

    protected abstract void setOutValue(T var1);

    public void spy(SpyWriter out) throws Exception {
        if (this.engineCycleQueue != null) {
            out.startTable(false);
            try {
                out.th((Object)"Queue State");
                out.tr((Object)"Current Size", (Object)this.size());
                out.tr((Object)"Processed Count", (Object)this.engineCycleQueue.getProcessedCount());
            }
            finally {
                out.endTable();
            }
        }
        super.spy(out);
    }
}

