/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support;

import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.logging.Level;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.OrdTarget;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public final class JsonSchemaSecurity {
    private static final String ESCALATE_PERMISSIONS_VIOLATION = "jsonschema.escalatePermissionsViolation";
    private static Boolean escalatePermissionsViolation;

    private JsonSchemaSecurity() {
    }

    public static <T> T permissionsCheck(BJsonSchema schema, T target) {
        if (target instanceof OrdTarget && !((OrdTarget)target).canRead() || target instanceof BValue && !schema.userHasPermission((BValue)target)) {
            JsonSchemaSecurity.permissionEscalationCheck(schema, target);
            target = null;
        }
        return target;
    }

    private static void permissionEscalationCheck(BJsonSchema schema, Object target) {
        if (JsonSchemaSecurity.shouldEscalatePermissionsViolation()) {
            throw new PermissionException(String.format("JsonSchema [%s] cannot access target: [%s] for user: [%s]", schema.getName(), JsonSchemaUtil.getSlotPath(target), schema.currentUser()));
        }
    }

    private static boolean shouldEscalatePermissionsViolation() {
        if (escalatePermissionsViolation == null) {
            String property = System.getProperty(ESCALATE_PERMISSIONS_VIOLATION);
            escalatePermissionsViolation = "true".equalsIgnoreCase(property);
        }
        return escalatePermissionsViolation;
    }

    public static boolean userHasReadPermission(BValue value, Context context) {
        if (value instanceof BComponent && context != null) {
            return context.getUser().getPermissionsFor((BIProtected)value.asComponent()).hasOperatorRead();
        }
        return true;
    }

    public static boolean userHasWritePermission(BValue value, Context context) {
        if (value instanceof BComponent && context != null) {
            BPermissions permissions = context.getUser().getPermissionsFor((BIProtected)value.asComponent());
            return permissions.hasAdminWrite() || permissions.hasOperatorWrite();
        }
        return true;
    }

    public static Context createServiceContext() {
        block3: {
            try {
                BUserService userService;
                BUser user;
                BJsonSchemaService service = BJsonSchemaService.service();
                String userName = service.getRunAsUserInternal();
                if (userName != null && !userName.isEmpty() && !userName.equals("-unassigned-") && (user = (userService = (BUserService)Sys.getService((Type)BUserService.TYPE)).getUser(userName)) != null) {
                    return new BasicContext(user);
                }
            }
            catch (FeatureNotLicensedException | ServiceNotFoundException se) {
                if (!JsonSchemaUtil.logger.isLoggable(Level.FINE)) break block3;
                JsonSchemaUtil.logger.fine("Service missing so skipping use of RunAs user");
            }
        }
        return null;
    }
}

