/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.support;

import com.tridium.util.ModuleThreadPool;
import com.tridiumx.jsonToolkit.exportMarker.register.BExportMarkerRegister;
import com.tridiumx.jsonToolkit.outbound.schema.subscription.BSubscriptionSlotBlacklist;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSMAExpirationMonitor;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.CannotValidateException;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="runAsUser", type="String", defaultValue="BJsonSchemaService.UNASSIGNED", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")}), @NiagaraProperty(name="SMAExpirationMonitor", type="BSMAExpirationMonitor", defaultValue="new BSMAExpirationMonitor()"), @NiagaraProperty(name="globalCovSlotFilter", type="BSubscriptionSlotBlacklist", defaultValue="new BSubscriptionSlotBlacklist()"), @NiagaraProperty(name="exportMarkerRegister", type="BExportMarkerRegister", defaultValue="new BExportMarkerRegister()", flags=4)})
public final class BJsonSchemaService
extends BAbstractService
implements BIRestrictedComponent,
BIUnlinkableSlotsContainer,
LicenseLimit {
    public static final String UNASSIGNED = "-unassigned-";
    @Generated
    public static final Property runAsUser = BJsonSchemaService.newProperty((int)0, (String)"-unassigned-", (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property SMAExpirationMonitor = BJsonSchemaService.newProperty((int)0, (BValue)new BSMAExpirationMonitor(), null);
    @Generated
    public static final Property globalCovSlotFilter = BJsonSchemaService.newProperty((int)0, (BValue)new BSubscriptionSlotBlacklist(), null);
    @Generated
    public static final Property exportMarkerRegister = BJsonSchemaService.newProperty((int)4, (BValue)new BExportMarkerRegister(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchemaService.class);
    private static final Set<Slot> UNLINKABLE_SLOTS = Collections.singleton(runAsUser);
    private static final BIcon ICON = BIcon.std((String)"braces.png");
    private static final String DEFAULT_AUDIT_USERNAME = "json";
    private static final String logPrefix = "jsonToolkit";
    public static final Logger log = Logger.getLogger("jsonToolkit");
    private boolean nonSuperUserModifiedRunAsUser;

    @Generated
    public String getRunAsUser() {
        return this.getString(runAsUser);
    }

    @Generated
    public void setRunAsUser(String v) {
        this.setString(runAsUser, v, null);
    }

    @Generated
    public BSMAExpirationMonitor getSMAExpirationMonitor() {
        return (BSMAExpirationMonitor)this.get(SMAExpirationMonitor);
    }

    @Generated
    public void setSMAExpirationMonitor(BSMAExpirationMonitor v) {
        this.set(SMAExpirationMonitor, (BValue)v, null);
    }

    @Generated
    public BSubscriptionSlotBlacklist getGlobalCovSlotFilter() {
        return (BSubscriptionSlotBlacklist)this.get(globalCovSlotFilter);
    }

    @Generated
    public void setGlobalCovSlotFilter(BSubscriptionSlotBlacklist v) {
        this.set(globalCovSlotFilter, (BValue)v, null);
    }

    @Generated
    public BExportMarkerRegister getExportMarkerRegister() {
        return (BExportMarkerRegister)this.get(exportMarkerRegister);
    }

    @Generated
    public void setExportMarkerRegister(BExportMarkerRegister v) {
        this.set(exportMarkerRegister, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    public void started() throws Exception {
        try {
            LicenseLimit.checkLicense();
        }
        catch (FeatureNotLicensedException e) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(e.getLocalizedMessage());
        }
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(runAsUser)) {
            return (validatable, ctx) -> {
                Property[] modified = validatable.getModifiedProperties();
                if (Arrays.asList(modified).contains(runAsUser) && !BJsonSchemaService.contextUserIsSuperUser(ctx)) {
                    throw new CannotValidateException(String.format("Must have superuser permissions to edit the %s slot", runAsUser.getName()));
                }
            };
        }
        return null;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(runAsUser)) {
            this.nonSuperUserModifiedRunAsUser = !BJsonSchemaService.contextUserIsSuperUser(context);
        }
    }

    public Set<Slot> getUnlinkableSourceSlots(Context context) {
        return UNLINKABLE_SLOTS;
    }

    public Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_SLOTS;
    }

    public String getRunAsUserInternal() {
        if (this.nonSuperUserModifiedRunAsUser) {
            throw new PermissionException("runAsUser was modified by a non super user");
        }
        return this.getRunAsUser();
    }

    private static boolean contextUserIsSuperUser(Context context) {
        return context != null && context.getUser() != null && context.getUser().getPermissions().isSuperUser();
    }

    public static BJsonSchemaService service() {
        BJsonSchemaService service = (BJsonSchemaService)Sys.getService((Type)TYPE);
        if (!service.getStatus().isFault()) {
            return service;
        }
        throw new FeatureNotLicensedException(TYPE.getTypeName() + " unlicensed");
    }

    public static BExportMarkerRegister register() {
        return BJsonSchemaService.service().getExportMarkerRegister();
    }

    public static IFuture post(BComponent instance, Action action, BValue argument, Context cx) {
        return ModuleThreadPool.getInstance((Type)TYPE).post(instance, action, argument, cx);
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public static void audit(Context cx, String event, String target, String slotName, String old, BValue value) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            if (value == null) {
                value = BString.make((String)"null");
            }
            if (old == null) {
                old = "null";
            }
            String username = cx != null && cx.getUser() != null ? cx.getUser().getUsername() : DEFAULT_AUDIT_USERNAME;
            AuditEvent auditEvent = new AuditEvent(event, target, slotName, old, value.toString(), username);
            auditor.audit(auditEvent);
        }
    }

    public static Logger childLogger(String name) {
        return Logger.getLogger("jsonToolkit." + name);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

