/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query;

import com.tridium.util.ModuleThreadPool;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchema;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailException;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailReasons;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryResultHolder;
import com.tridiumx.jsonToolkit.outbound.schema.support.BJsonSchemaService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class QueryRunner {
    private static final Logger logger = BJsonSchemaService.childLogger("query");
    private final BJsonSchema schema;
    private final List<Future<?>> executingQueries = new ArrayList();

    public QueryRunner(BJsonSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueries(BComplex base, Context context) throws QueryFailException {
        if (!this.schema.getEnabled()) {
            return;
        }
        BJsonSchemaQuery[] queries = (BJsonSchemaQuery[])this.schema.getQueries().getChildren(BJsonSchemaQuery.class);
        this.schema.getConfig().getDebug().getMetrics().incrementQueryFolderExecs();
        List<Future<?>> list = this.executingQueries;
        synchronized (list) {
            if (!this.executingQueries.isEmpty()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("%s - Not running queries this time", this.schema.getName()));
                }
                this.schema.getMetrics().queryFail(QueryFailReasons.OVERLAP.getReason());
                return;
            }
            this.startQueryExecution(queries, base, context);
        }
        BAbsTime timeout = BAbsTime.now().add(this.schema.getQueries().getQueriesMaxExecutionTime());
        try {
            while (!this.executingQueries.isEmpty()) {
                if (BAbsTime.now().isAfter(timeout)) {
                    this.executingQueries.forEach(future -> future.cancel(true));
                    break;
                }
                long waitMillis = timeout.getMillis() - BAbsTime.now().getMillis();
                this.waitForQueriesToComplete(waitMillis);
            }
        }
        finally {
            this.completeQueryExecution();
        }
    }

    private void waitForQueriesToComplete(long waitMillis) throws QueryFailException {
        Iterator<Future<?>> futureIterator = this.executingQueries.iterator();
        while (futureIterator.hasNext()) {
            Future<?> task = futureIterator.next();
            try {
                task.get(waitMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable rootException;
                logger.log(Level.SEVERE, String.format("Json schema [%s] query execution failed: %s", this.schema.getName(), e.getMessage()), e);
                Throwable exception = null;
                if (task instanceof ForkJoinTask) {
                    exception = ((ForkJoinTask)task).getException();
                }
                if (exception == null) {
                    exception = e;
                }
                if ((rootException = QueryRunner.getRootCause(exception)).getMessage() == null) continue;
                this.schema.getConfig().getDebug().getMetrics().queryFail(QueryFailReasons.RUNTIME.getReason() + " : " + rootException.getMessage());
            }
            catch (TimeoutException e) {
                this.schema.getConfig().getDebug().getMetrics().queryFail(QueryFailReasons.TIMEOUT.getReason());
                throw new QueryFailException("Schema queries execution time exceeded");
            }
            finally {
                futureIterator.remove();
            }
        }
    }

    private static Throwable getRootCause(Throwable exception) {
        while (exception.getCause() != null) {
            exception = exception.getCause();
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQueryExecution(BJsonSchemaQuery[] queries, BComplex base, Context context) {
        List<Future<?>> list = this.executingQueries;
        synchronized (list) {
            if (this.executingQueries.isEmpty()) {
                Arrays.stream(queries).forEach(query -> {
                    Future future = ModuleThreadPool.getInstance((Type)query.getType()).submit(() -> this.executeQuery((BJsonSchemaQuery)((Object)query), base, context));
                    this.executingQueries.add(future);
                });
            }
        }
    }

    private void executeQuery(final BJsonSchemaQuery query, BComplex base, Context context) {
        long start = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Schema [%s] running query [%s] against base [%s]", this.schema.getName(), query.getName(), base.getName()));
        }
        try {
            BITable<?> results = query.execute(base, context);
            query.setLastResult(new QueryResultHolder(results));
        }
        catch (UnresolvedException e) {
            throw new UnresolvedException("Could not run query " + query.getQueryOrd(), e){

                public String toString() {
                    String s = query.getName();
                    String message = this.getLocalizedMessage();
                    return message != null ? s + ": " + message : s;
                }
            };
        }
        long time = System.currentTimeMillis() - start;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Schema [%s] completed query [%s] in [%s]", this.schema.getName(), query.getName(), time));
        }
        this.schema.getConfig().getDebug().getMetrics().queryResult(time);
        this.schema.getQueries().setLastQueryCompletedTimestamp(BAbsTime.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeQueryExecution() {
        List<Future<?>> list = this.executingQueries;
        synchronized (list) {
            this.executingQueries.clear();
        }
    }
}

