/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema.query;

import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="queryOrd", type="BOrd", defaultValue="BOrd.DEFAULT", flags=5, override=true), @NiagaraProperty(name="queryPattern", type="BString", defaultValue="BString.make(\"%baseHistoryOrd%?period=today|bql:select timestamp, value\")")})
public class BRelativeHistoryQuery
extends BJsonSchemaQuery {
    @Generated
    public static final Property queryOrd = BRelativeHistoryQuery.newProperty((int)5, (BValue)BOrd.DEFAULT, null);
    @Generated
    public static final Property queryPattern = BRelativeHistoryQuery.newProperty((int)0, (BValue)BString.make((String)"%baseHistoryOrd%?period=today|bql:select timestamp, value"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRelativeHistoryQuery.class);
    private static final String TOKEN = "%baseHistoryOrd%";
    private static final Pattern COMPILE = Pattern.compile("%baseHistoryOrd%", 16);

    @Generated
    public String getQueryPattern() {
        return this.getString(queryPattern);
    }

    @Generated
    public void setQueryPattern(String v) {
        this.setString(queryPattern, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BITable<?> execute(BComplex base, Context context) {
        BHistoryId historyId = BRelativeHistoryQuery.getHistoryId(base);
        if (historyId == null) {
            throw new UnresolvedException("Unable to find history id for base item " + JsonSchemaUtil.getSlotPath((BObject)base));
        }
        if (this.getQueryPattern().contains(TOKEN)) {
            String query = COMPILE.matcher(this.getQueryPattern()).replaceAll(Matcher.quoteReplacement("history:" + historyId.toString()));
            this.setQueryOrd(BOrd.make((String)query));
            return super.execute(base, context);
        }
        throw new UnresolvedException("Missing relative history token: %baseHistoryOrd%");
    }

    private static BHistoryId getHistoryId(BComplex base) {
        BHistoryConfig historyConfig = null;
        if (base instanceof BHistoryConfig) {
            historyConfig = (BHistoryConfig)base.as(BHistoryConfig.class);
        } else if (base instanceof BHistoryExt) {
            historyConfig = ((BHistoryExt)base.as(BHistoryExt.class)).getHistoryConfig();
        } else {
            for (Property property : base.getPropertiesArray()) {
                if (property.getType().is(BHistoryConfig.TYPE)) {
                    historyConfig = (BHistoryConfig)base.get(property).as(BHistoryConfig.class);
                    continue;
                }
                if (!property.getType().is(BHistoryExt.TYPE)) continue;
                historyConfig = ((BHistoryExt)base.get(property).as(BHistoryExt.class)).getHistoryConfig();
            }
        }
        return historyConfig != null ? historyConfig.getId() : null;
    }
}

