/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.outbound.schema;

import com.tridium.json.JSONException;
import com.tridium.json.JSONStringer;
import com.tridium.json.JSONWriter;
import com.tridium.util.IPrefixLoggable;
import com.tridium.util.PrefixLogUtil;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonProperty;
import com.tridiumx.jsonToolkit.outbound.schema.BIJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaBoundMember;
import com.tridiumx.jsonToolkit.outbound.schema.BJsonSchemaMember;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaTuningPolicy;
import com.tridiumx.jsonToolkit.outbound.schema.config.BJsonSchemaUpdateStrategy;
import com.tridiumx.jsonToolkit.outbound.schema.config.folder.BJsonSchemaConfigFolder;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BIPostProcessor;
import com.tridiumx.jsonToolkit.outbound.schema.postprocess.BJsonSchemaMetrics;
import com.tridiumx.jsonToolkit.outbound.schema.property.BJsonSchemaPropertyList;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQuery;
import com.tridiumx.jsonToolkit.outbound.schema.query.BJsonSchemaQueryFolder;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryFailException;
import com.tridiumx.jsonToolkit.outbound.schema.query.QueryRunner;
import com.tridiumx.jsonToolkit.outbound.schema.support.BSchemaEvent;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaConfigException;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaSecurity;
import com.tridiumx.jsonToolkit.outbound.schema.support.JsonSchemaUtil;
import com.tridiumx.jsonToolkit.util.LicenseLimit;
import com.tridiumx.jsonToolkit.util.ParentLegal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="output", type="String", defaultValue="BString.DEFAULT", flags=11, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"jsonToolkit:JsonOutputWidget\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"jsonToolkit:JsonOutputEditor\"))")}), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.down", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="lastUpdated", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="config", type="BJsonSchemaConfigFolder", defaultValue="new BJsonSchemaConfigFolder()"), @NiagaraProperty(name="queries", type="BJsonSchemaQueryFolder", defaultValue="new BJsonSchemaQueryFolder()")})
@NiagaraActions(value={@NiagaraAction(name="generateJson", flags=2064), @NiagaraAction(name="forceGenerateJson", flags=2064), @NiagaraAction(name="clearCache", flags=16), @NiagaraAction(name="clearOutput", flags=16), @NiagaraAction(name="executeQueries", flags=16), @NiagaraAction(name="minWriteExpired", flags=4)})
@NiagaraTopic(name="schemaModified", eventType="BSchemaEvent")
public class BJsonSchema
extends BJsonSchemaMember
implements LicenseLimit,
IPrefixLoggable {
    @Generated
    public static final Property output = BJsonSchema.newProperty((int)11, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:JsonOutputWidget")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"jsonToolkit:JsonOutputEditor"))));
    @Generated
    public static final Property enabled = BJsonSchema.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property status = BJsonSchema.newProperty((int)3, (BValue)BStatus.down, null);
    @Generated
    public static final Property faultCause = BJsonSchema.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property lastUpdated = BJsonSchema.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property config = BJsonSchema.newProperty((int)0, (BValue)new BJsonSchemaConfigFolder(), null);
    @Generated
    public static final Property queries = BJsonSchema.newProperty((int)0, (BValue)new BJsonSchemaQueryFolder(), null);
    @Generated
    public static final Action generateJson = BJsonSchema.newAction((int)2064, null);
    @Generated
    public static final Action forceGenerateJson = BJsonSchema.newAction((int)2064, null);
    @Generated
    public static final Action clearCache = BJsonSchema.newAction((int)16, null);
    @Generated
    public static final Action clearOutput = BJsonSchema.newAction((int)16, null);
    @Generated
    public static final Action executeQueries = BJsonSchema.newAction((int)16, null);
    @Generated
    public static final Action minWriteExpired = BJsonSchema.newAction((int)4, null);
    @Generated
    public static final Topic schemaModified = BJsonSchema.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonSchema.class);
    protected final ThreadLocal<Context> currentContext = new ThreadLocal();
    protected final QueryRunner queryRunner = new QueryRunner(this);
    private Clock.Ticket queryExecuteTicket = Clock.expiredTicket;
    private Clock.Ticket minWriteTicket = Clock.expiredTicket;
    private final AtomicBoolean requestDuringMinWritePeriod = new AtomicBoolean();
    private static final String DEFAULT_OUTPUT = BString.DEFAULT.toString();
    private String lastUser;
    private final Object mutex = new Object();

    @Generated
    public String getOutput() {
        return this.getString(output);
    }

    @Generated
    public void setOutput(String v) {
        this.setString(output, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Override
    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Override
    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BAbsTime getLastUpdated() {
        return (BAbsTime)this.get(lastUpdated);
    }

    @Generated
    public void setLastUpdated(BAbsTime v) {
        this.set(lastUpdated, (BValue)v, null);
    }

    @Generated
    public BJsonSchemaConfigFolder getConfig() {
        return (BJsonSchemaConfigFolder)this.get(config);
    }

    @Generated
    public void setConfig(BJsonSchemaConfigFolder v) {
        this.set(config, (BValue)v, null);
    }

    @Generated
    public BJsonSchemaQueryFolder getQueries() {
        return (BJsonSchemaQueryFolder)this.get(queries);
    }

    @Generated
    public void setQueries(BJsonSchemaQueryFolder v) {
        this.set(queries, (BValue)v, null);
    }

    @Generated
    public void generateJson() {
        this.invoke(generateJson, null, null);
    }

    @Generated
    public void forceGenerateJson() {
        this.invoke(forceGenerateJson, null, null);
    }

    @Generated
    public void clearCache() {
        this.invoke(clearCache, null, null);
    }

    @Generated
    public void clearOutput() {
        this.invoke(clearOutput, null, null);
    }

    @Generated
    public void executeQueries() {
        this.invoke(executeQueries, null, null);
    }

    @Generated
    public void minWriteExpired() {
        this.invoke(minWriteExpired, null, null);
    }

    @Generated
    public void fireSchemaModified(BSchemaEvent event) {
        this.fire(schemaModified, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void descendantsStarted() {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        this.setup();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
    }

    public void atSteadyState() {
        if (this.isRunning() && this.getEnabled() && this.getConfig().getTuningPolicy().getWriteOnStart()) {
            this.generateJson();
        }
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled)) {
            if (this.getEnabled()) {
                this.setup();
                if (this.getConfig().getTuningPolicy().getWriteOnEnabled()) {
                    this.generateJson();
                }
            } else {
                this.disableAll();
            }
        } else if (property.getName().equals(BJsonSchemaQueryFolder.queryInterval.getName()) || property.getName().equals(BJsonSchemaTuningPolicy.updateStrategy.getName())) {
            this.cancelQueryExecutionTimer();
            this.processQueries(context, false);
            this.cancelMinWritePublishTimer();
        } else if (property.equals(output)) {
            this.getConfig().getDebug().getMetrics().outputChanged(this.getOutput());
            PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> String.format("Json schema [%s] new output [%s]", this.getName(), this.getOutput()), (Object)this);
        }
        if (property.getName().equals(BJsonSchemaTuningPolicy.updateStrategy.getName())) {
            this.fireSchemaModified(this.requiresMemberSubscriptions() ? BSchemaEvent.subscriptionsEnabled : BSchemaEvent.subscriptionsDisabled);
        }
    }

    private void setup() {
        if (this.requiresMemberSubscriptions()) {
            this.fireSchemaModified(BSchemaEvent.subscriptionsEnabled);
        }
        this.processQueries(null, false);
    }

    @Override
    public void started() {
        this.initLicenseProperty();
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.disableAll();
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!ParentLegal.disableChecks && parent instanceof BJsonSchema) {
            throw new IllegalParentException(TYPE.getModule().getModuleName(), "cannotNestSchema", null);
        }
        return true;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        boolean check;
        boolean bl = check = (child instanceof BIJsonSchemaMember || child instanceof BIPostProcessor) && !(child instanceof BIJsonProperty) && !(child instanceof BJsonSchemaPropertyList);
        if (ParentLegal.disableChecks) {
            if (!check) {
                JsonSchemaUtil.logger.severe("Child not allowed on Schema: " + child.toDebugString() + " @ " + this.toDebugString());
            }
            return true;
        }
        return check;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value.getType().is(BIJsonSchemaMember.TYPE) && ((BIJsonSchemaMember[])this.getChildren(BIJsonSchemaMember.class)).length >= 1) {
            throw new JsonSchemaConfigException(this.getName() + ": Only 1 root member permitted");
        }
    }

    @Override
    public String getJsonName() {
        return "";
    }

    @Override
    public void process(JSONWriter jsonWriter, boolean jsonKeysValid) {
        this.processChildJsonMembers(jsonWriter, jsonKeysValid);
    }

    public BJsonSchemaMember getRoot() {
        BJsonSchemaMember[] children = (BJsonSchemaMember[])this.getChildren(BJsonSchemaMember.class);
        return children.length > 0 ? children[0] : null;
    }

    protected void disableAll() {
        this.cancelMinWritePublishTimer();
        this.cancelQueryExecutionTimer();
        if (this.isRunning()) {
            this.fireSchemaModified(BSchemaEvent.subscriptionsDisabled);
        }
        this.clearCache();
    }

    protected boolean startQueryExecutionTimer(Context context) {
        boolean timerStarted = false;
        if (this.getEnabled() && this.isRunning() && this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.cov && this.queryExecuteTicket.isExpired() && this.queryIntervalIsSet()) {
            this.queryExecuteTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getQueries().getQueryInterval(), (Action)executeQueries, null);
            timerStarted = true;
        }
        return timerStarted;
    }

    private void cancelQueryExecutionTimer() {
        if (!this.queryExecuteTicket.isExpired()) {
            this.queryExecuteTicket.cancel();
            this.queryExecuteTicket = Clock.expiredTicket;
        }
    }

    protected boolean shouldRunQueries() {
        return this.isRunning() && this.getEnabled() && this.queryIntervalIsSet() && this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.onDemandOnly;
    }

    protected boolean queryIntervalIsSet() {
        return this.getQueries().getQueryInterval().getMillis() > 0L;
    }

    protected void cancelMinWritePublishTimer() {
        if (!this.minWriteTicket.isExpired()) {
            PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> "Cancelling minWrite timer for schema: " + this.schemaName(), (Object)this);
            this.minWriteTicket.cancel();
            this.minWriteTicket = Clock.expiredTicket;
        }
    }

    private void updateMinWriteTimer() {
        BRelTime minWrite = this.getConfig().getTuningPolicy().getMinWriteTime();
        if (!minWrite.equals((Object)BRelTime.DEFAULT)) {
            this.cancelMinWritePublishTimer();
            PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> "Updating minWrite timer for schema: " + this.schemaName(), (Object)this);
            this.minWriteTicket = Clock.schedule((BComponent)this, (BRelTime)minWrite, (Action)minWriteExpired, null);
        }
    }

    public boolean requiresMemberSubscriptions() {
        return this.getConfig().getTuningPolicy().getUpdateStrategy() == BJsonSchemaUpdateStrategy.cov && !this.isRelative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestGenerateJson(Context context) {
        PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> String.format("requestGenerateJson called for schema %s", this.getName()), (Object)this);
        this.getConfig().getDebug().getMetrics().incrementRequestCounter();
        BRelTime minWrite = this.getConfig().getTuningPolicy().getMinWriteTime();
        if (minWrite.equals((Object)BRelTime.DEFAULT) || this.maxWriteTimeExceeded()) {
            this.generateAndOutputJson(context);
        } else if (!minWrite.equals((Object)BRelTime.DEFAULT)) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.minWriteTicket == null || this.minWriteTicket.isExpired() && !this.requestDuringMinWritePeriod.get()) {
                    this.generateAndOutputJson(context);
                } else {
                    PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> "Request during minWrite window, request deferred for schema: " + this.schemaName(), (Object)this);
                    this.requestDuringMinWritePeriod.set(true);
                }
            }
        }
    }

    public String currentUser() {
        Context ctx = this.currentContext.get();
        return ctx == null ? "system" : ctx.getUser().getUsername();
    }

    public boolean userHasPermission(BValue value) {
        return JsonSchemaSecurity.userHasReadPermission(value, this.currentContext.get());
    }

    private boolean maxWriteTimeExceeded() {
        BRelTime maxWrite = this.getConfig().getTuningPolicy().getMaxWriteTime();
        return maxWrite != BRelTime.DEFAULT && this.getLastUpdated().isBefore(BAbsTime.now().subtract(maxWrite));
    }

    public void doGenerateJson(Context context) {
        if (JsonSchemaUtil.logger.isLoggable(Level.FINEST)) {
            JsonSchemaUtil.logger.finest(String.format("Json Schema %s doGenerateJson called", this.getName()));
        }
        this.requestGenerateJson(context);
    }

    public void doForceGenerateJson(Context context) {
        this.generateAndOutputJson(context);
    }

    public void doMinWriteExpired(Context context) {
        if (this.requestDuringMinWritePeriod.get()) {
            PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> "Request was made during minWrite window, generate now for schema: " + this.schemaName(), (Object)this);
            this.requestDuringMinWritePeriod.set(false);
            this.doForceGenerateJson(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void generateAndOutputJson(Context context) {
        if (!this.getEnabled() || !this.isRunning()) {
            return;
        }
        LicenseLimit.checkExportLicensed();
        Object object = this.mutex;
        synchronized (object) {
            this.doWithContext(context, () -> {
                PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> String.format("doGenerateJson called for schema %s", this.getName()), (Object)this);
                this.processQueries(context);
                JSONStringer json = new JSONStringer();
                Throwable schemaGenException = null;
                try {
                    this.process((JSONWriter)json, false);
                }
                catch (JSONException | PermissionException e) {
                    schemaGenException = e;
                    String msg = this.getName() + " Failed to process json schema: " + e.getMessage();
                    if (JsonSchemaUtil.logger.isLoggable(Level.FINE)) {
                        msg = msg + '\n' + json.toString();
                    }
                    json = new JSONStringer();
                    JsonSchemaUtil.logger.log(Level.SEVERE, msg, e);
                }
                String output = json.toString();
                this.setOutput(output != null ? output : DEFAULT_OUTPUT);
                this.setLastUpdated(BAbsTime.now());
                this.updateMinWriteTimer();
                this.postProcessors((Exception)schemaGenException);
            });
        }
        PrefixLogUtil.logWithPrefix((Logger)JsonSchemaUtil.logger, (Level)Level.FINE, () -> String.format("doGenerateJson complete for schema %s", this.getName()), (Object)this);
    }

    protected void processQueries(Context context, boolean runSynchronously) {
        boolean timerStarted = this.startQueryExecutionTimer(context);
        if (this.shouldRunQueries() || timerStarted) {
            if (runSynchronously) {
                this.doExecuteQueries(context);
            } else {
                this.executeQueries();
            }
        }
    }

    protected void processQueries(Context context) {
        this.processQueries(context, true);
    }

    public void doExecuteQueries(Context context) {
        if (!this.isRunning()) {
            return;
        }
        this.doWithContext(context, () -> {
            try {
                this.queryRunner.executeQueries(this.getBaseObject(), this.currentContext.get());
            }
            catch (QueryFailException e) {
                JsonSchemaUtil.logger.severe(String.format("Json Schema [%s] query execution failed: [%s]", this.getName(), e.getMessage()));
            }
        });
    }

    public void doClearCache() {
        if (this.isRunning()) {
            this.fireSchemaModified(BSchemaEvent.cacheCleared);
        }
        for (BJsonSchemaQuery query : (BJsonSchemaQuery[])this.getQueries().getChildren(BJsonSchemaQuery.class)) {
            query.clearLastResult();
        }
    }

    public void doClearOutput() {
        this.setOutput(DEFAULT_OUTPUT);
        this.setLastUpdated(BAbsTime.DEFAULT);
    }

    public OrdTarget getOrdTarget(BJsonSchemaBoundMember member, BObject overrideBase) {
        return member.getBinding().resolve((BObject)(overrideBase != null ? overrideBase : this.getBaseObject()), this.currentContext.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithContext(Context context, Runnable runnable) {
        boolean contextAlreadySet;
        boolean bl = contextAlreadySet = this.currentContext.get() != null;
        if (!contextAlreadySet) {
            this.setCurrentContext(context);
        }
        try {
            runnable.run();
        }
        finally {
            if (!contextAlreadySet) {
                this.currentContext.remove();
            }
        }
    }

    private void setCurrentContext(Context context) {
        String user;
        if (context == null) {
            context = JsonSchemaSecurity.createServiceContext();
        }
        this.currentContext.set(context);
        if (context != null && context.getUser() != null && !(user = context.getUser().getName()).equals(this.lastUser)) {
            this.synchronousSchemaEvent(BSchemaEvent.cacheCleared);
            this.lastUser = user;
        }
    }

    public boolean isRelative() {
        return false;
    }

    public BJsonSchemaMetrics getMetrics() {
        return this.getConfig().getDebug().getMetrics();
    }

    public BComplex getBaseObject() {
        return Sys.getStation();
    }

    public String identifierForLogs() {
        return this.getName();
    }
}

