/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.jsonToolkit.inbound.routing;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.jsonToolkit.inbound.routing.BJsonArrayRouter;
import com.tridiumx.jsonToolkit.inbound.routing.RoutingFailedException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import org.jetbrains.annotations.NotNull;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sortField", type="BString", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="sortOrder", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(jsonToolkit:ascending)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(jsonToolkit:descending)%\"")}), @NiagaraProperty(name="sortDate", type="boolean", defaultValue="false")})
public class BJsonArraySortRouter
extends BJsonArrayRouter {
    @Generated
    public static final Property sortField = BJsonArraySortRouter.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property sortOrder = BJsonArraySortRouter.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(jsonToolkit:ascending)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(jsonToolkit:descending)%")));
    @Generated
    public static final Property sortDate = BJsonArraySortRouter.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJsonArraySortRouter.class);
    private static final LexiconModule LEX = LexiconModule.make(BJsonArraySortRouter.class);

    @Generated
    public String getSortField() {
        return this.getString(sortField);
    }

    @Generated
    public void setSortField(String v) {
        this.setString(sortField, v, null);
    }

    @Generated
    public boolean getSortOrder() {
        return this.getBoolean(sortOrder);
    }

    @Generated
    public void setSortOrder(boolean v) {
        this.setBoolean(sortOrder, v, null);
    }

    @Generated
    public boolean getSortDate() {
        return this.getBoolean(sortDate);
    }

    @Generated
    public void setSortDate(boolean v) {
        this.setBoolean(sortDate, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected List<Object> arrayToList(JSONArray array, String sortField) throws RoutingFailedException {
        ArrayList<Object> arrayList = new ArrayList<Object>(array.length());
        for (Object element : array) {
            if (element == null || JSONObject.NULL.equals(element)) {
                arrayList.add(null);
                continue;
            }
            if (element instanceof JSONArray) {
                arrayList.add(element.toString());
                continue;
            }
            if (element instanceof JSONObject) {
                arrayList.add(new ComparableJsonObject(element.toString(), this.getSortField()));
                continue;
            }
            if (this.getSortDate()) {
                Date dateValue = this.stringToDate(element);
                arrayList.add(new SortableDate(dateValue, element.toString()));
                continue;
            }
            arrayList.add(element);
        }
        arrayList.sort(this.isSortAscending() ? new JsonComparator() : new JsonComparator().reversed());
        return arrayList;
    }

    private boolean isSortAscending() {
        return this.getSortOrder();
    }

    public class SortableDate
    implements Comparable<SortableDate> {
        private final String inputString;
        private final Date inputDate;

        protected SortableDate(Date dateIn, String stringIn) {
            this.inputDate = dateIn;
            this.inputString = stringIn;
        }

        public String getInputString() {
            return this.inputString;
        }

        @Override
        public int compareTo(@NotNull SortableDate o) {
            return this.inputDate.compareTo(o.inputDate);
        }
    }

    private class ComparableJsonObject
    extends JSONObject
    implements Comparable {
        private final String sortField;

        private ComparableJsonObject(String source, String sortField) {
            super(source);
            this.sortField = sortField;
        }

        public int compareTo(Object o) {
            try {
                if (!(o instanceof JSONObject) || null == this.sortField || this.sortField.isEmpty()) {
                    return this.toString().compareTo(o.toString());
                }
                Object o1 = this.get(BJsonArraySortRouter.this.getSortField());
                Object o2 = ((JSONObject)o).get(BJsonArraySortRouter.this.getSortField());
                if (!(o1 instanceof Comparable)) {
                    o1 = o1.toString();
                }
                if (!(o2 instanceof Comparable)) {
                    o2 = o2.toString();
                }
                return ((Comparable)o1).compareTo(o2);
            }
            catch (RuntimeException exception) {
                throw new RuntimeException(LEX.getText("routingFailed", null, new Object[]{exception}));
            }
        }
    }

    private class JsonComparator
    implements Comparator<Object> {
        private JsonComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.getClass().equals(o2.getClass())) {
                return ((Comparable)o1).compareTo(o2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    }
}

