/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.js;

import com.tridium.web.js.NiagaraRequireJsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.naming.BOrd;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.BJsBuild;

public final class JsInfo {
    private final BOrd js;
    private final String buildId;
    public static final String[] STRINGS = new String[0];
    private static final String invalidErr = "Invalid JavaScript ORD: ";
    private static final Pattern modulePathPattern = Pattern.compile("^module://(.+\\.(js|css))$", 2);
    private static final Pattern cssFilePattern = Pattern.compile("^module://(.+)\\.(css)$");

    private JsInfo(BOrd js, String buildId) {
        if (js == null) {
            throw new IllegalArgumentException("js required");
        }
        this.js = js;
        this.buildId = buildId;
    }

    public static JsInfo make(BOrd js, String buildId) {
        return new JsInfo(js, buildId);
    }

    public static JsInfo make(BOrd js, Type buildType) {
        if (buildType == null || buildType.isAbstract() || !buildType.is(BJsBuild.TYPE)) {
            throw new IllegalArgumentException("BJsBuild subtype required");
        }
        BJsBuild build = (BJsBuild)buildType.getInstance();
        return new JsInfo(js, build.getId());
    }

    public static JsInfo make(BOrd js) {
        return new JsInfo(js, null);
    }

    public BOrd getJs() {
        return this.js;
    }

    public String getJsId() {
        return this.js.isNull() ? "" : JsInfo.toRequireJsId(this.js);
    }

    public String getBuildId() {
        return this.buildId;
    }

    private static Set<String> getBuiltFileIds(Collection<? extends BIWebResource> list) {
        HashSet<String> ids = new HashSet<String>();
        for (BIWebResource bIWebResource : list) {
            Collections.addAll(ids, bIWebResource.getRequireJsIds());
        }
        return ids;
    }

    @Deprecated
    public String[] getBuiltJsIds() {
        List<BJsBuild> builds = this.getBuilds();
        ArrayList<String> ids = new ArrayList<String>(JsInfo.getBuiltFileIds(builds));
        return ids.toArray(STRINGS);
    }

    public BIWebResource.DependencyGraph resolveDependencies() {
        return BIWebResource.resolve(this.getBuild().map(Collections::singletonList).orElse(Collections.emptyList()));
    }

    private Optional<BJsBuild> getBuild() {
        return BJsBuild.forId(this.buildId);
    }

    private List<BJsBuild> getBuilds() {
        ArrayList<BJsBuild> list = new ArrayList<BJsBuild>();
        this.getBuild().ifPresent(bJsBuild -> JsInfo.addBuilds(list, bJsBuild));
        return list;
    }

    private static void addBuilds(List<BJsBuild> list, BJsBuild build) {
        if (!build.isWebDevEnabled()) {
            list.add(build);
        }
        for (BJsBuild dep : build.getDependentBuilds()) {
            JsInfo.addBuilds(list, dep);
        }
    }

    @Deprecated
    public boolean hasBuiltJs() {
        return !this.getBuilds().isEmpty();
    }

    public static String toRequireJsId(BOrd ord) {
        String ordString = ord.toString();
        Matcher matcher = modulePathPattern.matcher(ordString);
        if (!matcher.find()) {
            throw new BajaRuntimeException(invalidErr + ordString);
        }
        String path = matcher.group(1);
        String requireJsModuleId = NiagaraRequireJsMapper.getInstance().pathToRequireJsModuleId(path);
        if (cssFilePattern.matcher(ordString).find()) {
            return "css!" + requireJsModuleId;
        }
        return requireJsModuleId;
    }
}

