/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web.js;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.WebDev;
import javax.baja.web.js.BIJavaScript;
import javax.baja.web.js.BIWebResource;
import javax.baja.web.js.JsInfo;

@NiagaraType
public abstract class BJsBuild
extends BSingleton
implements BIWebResource,
BIJavaScript {
    @Generated
    public static final Type TYPE = Sys.loadType(BJsBuild.class);
    private static final String[] EMPTY = new String[0];
    private final String id;
    private final BOrd[] builtFiles;
    private final String[] dependentBuildIds;
    private static boolean jsBuildErrorLogged = false;
    private Set<BIWebResource> webResources;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static Optional<BJsBuild> forId(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return CacheHolder.BY_ID.computeIfAbsent(id, i -> Optional.empty());
    }

    private static String[] typesToDependencies(Type[] types) {
        if (types == null) {
            throw new IllegalArgumentException("array of BIWebResource types required");
        }
        ArrayList<String> jsTypeIds = new ArrayList<String>();
        for (Type type : types) {
            if (type == null || type.isAbstract() || !type.is(BIWebResource.TYPE)) {
                throw new IllegalArgumentException("array of BIWebResource types required");
            }
            if (!(type.getInstance() instanceof BJsBuild)) continue;
            jsTypeIds.add(((BJsBuild)type.getInstance()).getId());
        }
        return jsTypeIds.toArray(new String[0]);
    }

    private void addWebResources(Type[] types) {
        this.webResources = new HashSet<BIWebResource>();
        for (Type type : types) {
            this.webResources.add((BIWebResource)type.getInstance());
        }
    }

    protected BJsBuild(String id, BOrd[] builtFiles) {
        this(id, builtFiles, EMPTY);
    }

    protected BJsBuild(String id, BOrd builtFile) {
        this(id, new BOrd[]{builtFile});
    }

    protected BJsBuild(String id, BOrd builtFile, String ... dependentBuildIds) {
        this(id, new BOrd[]{builtFile}, dependentBuildIds);
    }

    protected BJsBuild(String id, BOrd builtFile, Type ... dependentBuilds) {
        this(id, new BOrd[]{builtFile}, dependentBuilds);
    }

    protected BJsBuild(String id, BOrd[] builtFiles, String ... dependentBuildIds) {
        if (id == null) {
            throw new IllegalArgumentException("id required");
        }
        if (!BJsBuild.isArrayOfOrds(builtFiles)) {
            throw new IllegalArgumentException("built files required");
        }
        this.id = id;
        this.builtFiles = (BOrd[])builtFiles.clone();
        this.dependentBuildIds = (String[])dependentBuildIds.clone();
    }

    protected BJsBuild(String id, BOrd[] builtFiles, Type[] dependentTypes) {
        this(id, builtFiles, BJsBuild.typesToDependencies(dependentTypes));
        this.addWebResources(dependentTypes);
    }

    public String getId() {
        return this.id;
    }

    public BOrd[] getBuiltFiles() {
        return (BOrd[])this.builtFiles.clone();
    }

    @Override
    public BOrd[] getFiles() {
        return this.getBuiltFiles();
    }

    public BJsBuild[] getDependentBuilds() {
        return (BJsBuild[])Arrays.stream(this.dependentBuildIds).map(b -> BJsBuild.forId(b)).filter(Optional::isPresent).map(Optional::get).toArray(BJsBuild[]::new);
    }

    @Override
    public Set<BIWebResource> getDependencies() {
        if (this.webResources != null) {
            return Collections.unmodifiableSet(this.webResources);
        }
        HashSet<BIWebResource> dependencies = new HashSet<BIWebResource>();
        for (String buildId : this.dependentBuildIds) {
            Optional<BJsBuild> build = BJsBuild.forId(buildId);
            if (!build.isPresent()) {
                throw new RuntimeException("JsBuild " + buildId + " is not found");
            }
            dependencies.add(build.get());
        }
        return dependencies;
    }

    public boolean isWebDevEnabled() {
        return WebDev.get(this.getId()).isEnabled();
    }

    private static boolean isArrayOfOrds(BOrd[] ords) {
        if (ords == null || ords.length == 0) {
            return false;
        }
        for (BOrd ord : ords) {
            if (ord != null) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Optional<BJsBuild>> retrieveInstancesFromRegistry() {
        HashMap<String, Optional<BJsBuild>> map = new HashMap<String, Optional<BJsBuild>>();
        for (TypeInfo typeInfo : Sys.getRegistry().getTypes(TYPE.getTypeInfo())) {
            if (typeInfo.isAbstract()) continue;
            try {
                BJsBuild instance = (BJsBuild)typeInfo.getInstance();
                map.put(instance.getId(), Optional.of(instance));
            }
            catch (Exception e) {
                String message = "Unable to load BJsBuild type -> " + typeInfo;
                if (!jsBuildErrorLogged) {
                    Logger.getLogger("web.jsbuild").log(Level.SEVERE, message, e);
                    jsBuildErrorLogged = true;
                    continue;
                }
                Logger.getLogger("web.jsbuild").log(Level.FINE, message, e);
            }
        }
        return map;
    }

    @Override
    public final JsInfo getJsInfo(Context cx) {
        return this.getType() == TYPE ? JsInfo.make(BOrd.DEFAULT) : JsInfo.make(BOrd.DEFAULT, this.getType());
    }

    static /* synthetic */ Map access$000() {
        return BJsBuild.retrieveInstancesFromRegistry();
    }

    private static interface CacheHolder {
        public static final Map<String, Optional<BJsBuild>> BY_ID = BJsBuild.access$000();
    }
}

