/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.util.SecurableContext;
import com.tridium.web.WebEnv;
import com.tridium.web.WebSnoopHtmlWriter;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.baja.file.ExportOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.web.BWebProfileConfig;
import javax.baja.web.BWebService;
import javax.baja.web.BWebServlet;
import javax.baja.web.IWebEnv;
import javax.baja.web.UserAgent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class WebOp
extends ExportOp
implements SecurableContext {
    BWebService service;
    IWebEnv webEnv;
    BWebProfileConfig hxProfileConfig;
    BWebProfileConfig profileConfig;
    HttpServletRequest request;
    HttpServletResponse response;
    UserAgent userAgent;
    String lang;
    BWebServlet servlet;

    public WebOp(OrdTarget base, BWebService service, HttpServletRequest request, HttpServletResponse response) {
        super(base);
        this.service = service;
        this.request = request;
        this.response = response;
    }

    public BWebService getService() {
        return this.service;
    }

    public IWebEnv getWebEnv() {
        if (this.webEnv == null) {
            this.webEnv = this.initWebEnv();
        }
        return this.webEnv;
    }

    public IWebEnv initWebEnv() {
        HttpSession session = this.getRequest().getSession(true);
        this.webEnv = (IWebEnv)session.getAttribute("webenv");
        if (this.webEnv == null) {
            this.webEnv = WebEnv.make(this);
            session.setAttribute("webenv", (Object)this.webEnv);
        }
        return this.webEnv;
    }

    public BWebProfileConfig getProfileConfig() {
        return this.getProfileConfig(null);
    }

    public BWebProfileConfig getProfileConfig(Context cx) {
        if (this.profileConfig == null) {
            this.profileConfig = (BWebProfileConfig)((Object)this.getRequest().getSession(true).getAttribute("profileConfig"));
            if (this.profileConfig == null) {
                try {
                    this.profileConfig = this.getWebEnv().getWebProfileConfig(this.getUser());
                }
                catch (Exception e) {
                    BWebService.log.log(Level.SEVERE, "Cannot obtain profileConfig", e);
                }
            }
            if (this.profileConfig == null) {
                this.profileConfig = this.getWebEnv().makeWebProfileConfig();
            }
        }
        if (cx != null && cx.getFacets() != null && cx.getFacets().getb("preferHx", false)) {
            if (this.hxProfileConfig == null) {
                this.hxProfileConfig = (BWebProfileConfig)((Object)this.getRequest().getSession(true).getAttribute("hxProfileConfig"));
            }
            if (this.hxProfileConfig == null) {
                try {
                    this.hxProfileConfig = this.getWebEnv().getHxProfileConfig(this.profileConfig);
                    this.getRequest().getSession().setAttribute("hxProfileConfig", (Object)this.hxProfileConfig);
                }
                catch (Exception e) {
                    BWebService.log.log(Level.SEVERE, "Cannot obtain hxProfileConfig", e);
                }
            }
            return this.hxProfileConfig;
        }
        return this.profileConfig;
    }

    public String getPathInfo() {
        if (this.servlet != null) {
            String servletName = this.servlet.getServletName();
            return this.request.getRequestURI().substring(servletName.length() + 1);
        }
        return this.request.getPathInfo();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    public void setContentType(String mimeType) {
        this.getResponse().setContentType(mimeType);
    }

    public void setContentLength(int length) {
        this.getResponse().setContentLength(length);
    }

    public PrintWriter getWriter() throws IOException {
        return this.getResponse().getWriter();
    }

    public HtmlWriter getHtmlWriter() throws IOException {
        return new WebSnoopHtmlWriter(this, this.getWriter());
    }

    public UserAgent getUserAgent() {
        if (this.userAgent == null) {
            String header = this.request.getHeader("User-Agent");
            if (header == null) {
                return null;
            }
            try {
                this.userAgent = new UserAgent(header);
            }
            catch (Exception e) {
                BWebService.log.log(Level.SEVERE, "Invalid User-Agent: \"" + header + '\"', e);
            }
        }
        return this.userAgent;
    }

    public OutputStream getOutputStream() {
        try {
            return this.getResponse().getOutputStream();
        }
        catch (IOException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public String toUri(BOrd ord) {
        return WebUtil.toUri((OrdTarget)this, this.getRequest(), ord);
    }

    public String getLanguage() {
        if (this.lang == null) {
            this.lang = this.getRequest().getLocale().toLanguageTag();
        }
        return this.lang;
    }

    public void fw(Object o) {
        if (o instanceof BWebServlet) {
            this.servlet = (BWebServlet)o;
        }
    }

    public void redirectToHome() throws Exception {
        BOrd homePage = this.webEnv.getHomePage(this);
        this.getResponse().sendRedirect(WebUtil.getRedirect(this.getRequest(), WebUtil.toUri((OrdTarget)this, this.getRequest(), homePage)));
    }
}

