/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.util.Version;
import javax.servlet.http.HttpServletRequest;

public class UserAgent {
    public static final String MSIE = "MSIE";
    public static final String MOZILLA = "Mozilla";
    private String value;
    private Product product;
    private Product[] products;
    private String[] comments;
    private static final String AX_WEBSTART = "niagaraax/webstart";
    private static final String N4_WEBSTART = "niagara4/webstart";
    private static final String NIAGARA_WEB_LAUNCHER = "niagara/weblauncher";

    public UserAgent(String value) {
        this.value = value;
        int bs = value.indexOf(91);
        int be = value.indexOf(93);
        if (bs > 0 && be > 0) {
            value = value.substring(0, bs) + value.substring(be + 1);
        }
        Vector<Product> products = new Vector<Product>();
        Vector<String> comments = new Vector<String>();
        int cs = value.indexOf(40);
        int ce = value.indexOf(41);
        if (cs > 0 && ce > 0) {
            String commentList = value.substring(cs + 1, ce);
            value = value.substring(0, cs) + value.substring(ce + 1);
            StringTokenizer st = new StringTokenizer(commentList, ";");
            while (st.hasMoreTokens()) {
                String comment = st.nextToken().trim();
                comments.addElement(comment);
                if (!comment.startsWith(MSIE)) continue;
                try {
                    int space = comment.indexOf(32);
                    String name = comment.substring(0, space);
                    String verStr = comment.substring(space + 1);
                    Version ver = new Version(verStr);
                    products.addElement(new Product(name, verStr, ver));
                }
                catch (RuntimeException e) {
                    System.out.println("ERROR: Invalid MSIE User-Agent: " + comment);
                }
            }
        }
        StringTokenizer st = new StringTokenizer(value, " ");
        while (st.hasMoreTokens()) {
            products.addElement(UserAgent.parseProduct(st.nextToken()));
        }
        this.products = new Product[products.size()];
        products.copyInto(this.products);
        this.comments = new String[comments.size()];
        comments.copyInto(this.comments);
        this.product = this.products[0];
    }

    public static Product parseProduct(String token) {
        String name = token;
        String versionString = null;
        Version version = null;
        int slash = token.indexOf(47);
        if (slash > 0) {
            name = token.substring(0, slash);
            versionString = token.substring(slash + 1);
            try {
                version = new Version(versionString);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new Product(name, versionString, version);
    }

    @Deprecated
    public boolean isIE() {
        return this.getProduct().isIE();
    }

    public boolean isMozilla() {
        return this.getProduct().isMozilla();
    }

    @Deprecated
    public boolean isNiagaraAxWebStart() {
        return this.value.toLowerCase().contains(AX_WEBSTART);
    }

    @Deprecated
    public static boolean isNiagaraAxWebStart(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, AX_WEBSTART);
    }

    @Deprecated
    public boolean isNiagara4WebStart() {
        return this.value.toLowerCase().contains(N4_WEBSTART);
    }

    @Deprecated
    public static boolean isNiagara4WebStart(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, N4_WEBSTART);
    }

    @Deprecated
    public boolean isNiagaraWebLauncher() {
        return this.value.toLowerCase().contains(NIAGARA_WEB_LAUNCHER);
    }

    @Deprecated
    public static boolean isNiagaraWebLauncher(HttpServletRequest req) {
        return UserAgent.hasUserAgent(req, NIAGARA_WEB_LAUNCHER);
    }

    private static boolean hasUserAgent(HttpServletRequest req, String agentId) {
        String header = req.getHeader("User-Agent");
        return header != null ? header.toLowerCase().contains(agentId) : false;
    }

    public Product getProduct() {
        return this.product;
    }

    public Product[] getProducts() {
        return this.products;
    }

    public String[] getComments() {
        return this.comments;
    }

    public String toString() {
        return this.value;
    }

    public void dump() {
        int i;
        System.out.println("User-Agent: " + this.value);
        System.out.println("  Primary Product: " + this.product);
        System.out.println("  Products:");
        for (i = 0; i < this.products.length; ++i) {
            System.out.println("    " + this.products[i]);
        }
        System.out.println("  Comments:");
        for (i = 0; i < this.comments.length; ++i) {
            System.out.println("    " + this.comments[i]);
        }
    }

    public static class Product {
        public final String name;
        public final String versionString;
        public final Version version;

        public Product(String name, String versionString, Version version) {
            this.name = name;
            this.versionString = versionString;
            this.version = version;
        }

        @Deprecated
        public boolean isIE() {
            return this.name.equals(UserAgent.MSIE);
        }

        public boolean isMozilla() {
            return this.name.equals(UserAgent.MOZILLA);
        }

        public String toString() {
            if (this.versionString == null) {
                return this.name;
            }
            return this.name + "/" + this.version;
        }
    }
}

