/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.web;

import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.util.Objects;
import javax.baja.session.CsrfException;
import javax.baja.util.Lexicon;
import javax.servlet.http.HttpServletRequest;

public final class CsrfUtil {
    public static final String CSRF_TOKEN_NAME = "csrfToken";
    public static final String CSRF_TOKEN_HTTP_HEADER = "x-niagara-csrfToken";
    private static final Lexicon WEBLEX = Lexicon.make((String)"web");

    public static boolean verifyCsrfToken(HttpServletRequest req) throws IOException, CsrfException {
        String requestToken = WebUtil.getCsrfTokenFromRequest(req);
        return CsrfUtil.verifyCsrfToken(requestToken);
    }

    public static boolean verifyCsrfToken(String sessionToken, HttpServletRequest req) throws IOException, CsrfException {
        String requestToken = WebUtil.getCsrfTokenFromRequest(req);
        return CsrfUtil.verifyCsrfToken(sessionToken, requestToken);
    }

    public static boolean verifyCsrfToken(String token) throws IOException, CsrfException {
        NiagaraSuperSession session = SessionManager.getCurrentNiagaraSuperSession();
        if (session == null) {
            throw new CsrfException(WEBLEX.get("csrf.token.verify.error"));
        }
        return CsrfUtil.verifyCsrfToken(session.getCsrfToken(), token);
    }

    public static boolean verifyCsrfToken(String sessionToken, String token) throws IOException, CsrfException {
        if (Objects.isNull(token) || Objects.isNull(sessionToken)) {
            throw new CsrfException(WEBLEX.get("csrf.token.missing.error"));
        }
        if (!sessionToken.equals(token)) {
            throw new CsrfException(WEBLEX.get("csrf.token.invalid.error"));
        }
        return true;
    }
}

