/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.rpc;

import com.tridium.authn.BAuthenticationService;
import com.tridium.json.JSONObject;
import com.tridium.user.BUserPasswordConfiguration;
import com.tridium.web.rpc.BPasswordRpc;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.servlet.ServletException;

@NiagaraType
public class BChangeUserPasswordRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BChangeUserPasswordRpc.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(isSecure=false, permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static void changeUserPasswords(List<String> usernames, List<String> passwords, Context cx) throws Exception {
        BPasswordRpc.securityCheck(cx);
        BChangeUserPasswordRpc.doChangeUserPasswords(usernames, passwords, cx);
    }

    @NiagaraRpc(isSecure=false, permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static void validatePasswords(List<String> usernames, List<String> passwords, List<String> schemes, Context cx) throws Exception {
        BPasswordRpc.securityCheck(cx);
        BChangeUserPasswordRpc.doValidatePasswords(usernames, passwords, schemes, cx);
    }

    public static void doChangeUserPasswords(List<String> usernames, List<String> passwords, Context cx) throws JSONParseableException {
        if (usernames == null || passwords == null) {
            throw new JSONParseableException("Usernames and passwords required.");
        }
        if (usernames.size() != passwords.size()) {
            throw new JSONParseableException("Different number of usernames and passwords.");
        }
        JSONObject errors = null;
        String dup = BChangeUserPasswordRpc.findFirstDuplicate(usernames);
        if (dup != null) {
            errors = new JSONObject();
            errors.put(dup, (Object)("Duplicate username '" + dup + "'"));
            throw new JSONParseableException(errors);
        }
        for (int i = 0; i < usernames.size(); ++i) {
            String username = usernames.get(i);
            String usernameDisplay = SlotPath.unescape((String)username);
            String password = BChangeUserPasswordRpc.base64Decode(passwords.get(i));
            try {
                BAbstractAuthenticator auth;
                BUser user;
                try {
                    user = BChangeUserPasswordRpc.getUser(username, cx);
                    auth = user.getAuthenticator();
                }
                catch (Exception e) {
                    throw new Exception("Password reset failed.");
                }
                if (!(auth instanceof BPasswordCache)) {
                    throw new Exception("User does not have a password.");
                }
                Property passwordProp = auth.getProperty("password");
                if (Flags.isReadonly((BComplex)auth, (Slot)passwordProp) || Flags.isReadonly((BComplex)user, (Slot)user.getProperty("authenticator"))) {
                    throw new Exception("User's password is readonly.");
                }
                auth.set(passwordProp, (BValue)BPassword.make((String)password), cx);
                continue;
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new JSONObject();
                }
                errors.put(usernameDisplay, (Object)e.getMessage());
            }
        }
        if (errors != null) {
            throw new JSONParseableException(errors);
        }
    }

    public static void doValidatePasswords(List<String> usernames, List<String> passwords, List<String> schemes, Context cx) throws JSONParseableException {
        if (usernames == null || passwords == null || schemes == null) {
            throw new JSONParseableException("Schemes and passwords required.");
        }
        if (schemes.size() != passwords.size() || usernames.size() != passwords.size()) {
            throw new JSONParseableException("Different number of schemes, usernames, and passwords.");
        }
        BAuthenticationService authService = BChangeUserPasswordRpc.getService(BAuthenticationService.class);
        JSONObject errors = new JSONObject();
        boolean hasError = false;
        for (int i = 0; i < schemes.size(); ++i) {
            if (schemes.get(i) == null) continue;
            String schemeName = schemes.get(i);
            String username = usernames.get(i);
            String usernameDisplay = SlotPath.unescape((String)username);
            String password = BChangeUserPasswordRpc.base64Decode(passwords.get(i));
            try {
                BAuthenticationScheme scheme = authService.getAuthenticationScheme(schemeName);
                if (scheme instanceof BPasswordAuthenticationScheme) {
                    BAbstractAuthenticator authenticator;
                    BPasswordAuthenticationScheme passScheme = (BPasswordAuthenticationScheme)scheme;
                    BUser user = BChangeUserPasswordRpc.getUser(username, cx);
                    BUserPasswordConfiguration configuration = null;
                    if (user != null && (authenticator = user.getAuthenticator()) instanceof BPasswordAuthenticator) {
                        configuration = ((BPasswordAuthenticator)authenticator).getPasswordConfig();
                    }
                    BPasswordAuthenticator.checkPassword((BUser)user, (BPasswordAuthenticationScheme)passScheme, configuration, (BPassword)BPassword.make((String)password), (Context)cx);
                }
                errors.put(usernameDisplay, (Object)null);
                continue;
            }
            catch (Exception e) {
                hasError = true;
                errors.put(usernameDisplay, (Object)String.valueOf(e.getMessage()));
            }
        }
        if (hasError) {
            throw new JSONParseableException(errors);
        }
    }

    private static BUser getUser(String username, Context cx) throws ServletException {
        try {
            BUserService userService = BChangeUserPasswordRpc.getService(BUserService.class);
            BUser user = userService.getUser(SlotPath.unescape((String)username));
            if (user == null) {
                return null;
            }
            cx.getUser().checkWrite((BComponent)user, (Slot)user.getProperty("authenticator"));
            return user;
        }
        catch (Exception e) {
            throw new ServletException("Password reset failed.");
        }
    }

    private static String findFirstDuplicate(List<String> strings) {
        HashSet<String> set = new HashSet<String>(strings.size());
        for (String string : strings) {
            if (set.contains(string)) {
                return string;
            }
            set.add(string);
        }
        return null;
    }

    private static String base64Decode(String str) {
        return new String(Base64.getDecoder().decode(str), StandardCharsets.UTF_8);
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)Sys.getService((Type)Sys.getType(clazz));
    }

    public static class JSONParseableException
    extends Exception {
        public JSONParseableException(String error) {
            this(new JSONObject().put("", (Object)error));
        }

        public JSONParseableException(JSONObject errors) {
            super(errors.toString());
        }
    }
}

