/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.js;

import com.tridium.web.RequireJsUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.nre.function.BiConsumerCanThrowException;
import javax.baja.web.WebDev;

public class RequireJsMapper {
    private final Map<String, Function<String, String>> rjsToPathMap;
    private final Map<Function<String, Boolean>, Function<String, String>> pathToRjsMap;
    private final Pattern mappedPathPrefix;
    private static final Pattern JS_CSS_PATTERN = Pattern.compile("\\.(js|css)$", 2);

    public static RequireJsMapperBuilder builder() {
        return new RequireJsMapperBuilder();
    }

    protected RequireJsMapper(Map<String, Function<String, String>> rjsToPathMap, Map<Function<String, Boolean>, Function<String, String>> pathToRjsMap) {
        this.rjsToPathMap = rjsToPathMap;
        this.pathToRjsMap = pathToRjsMap;
        this.mappedPathPrefix = Pattern.compile("^(" + String.join((CharSequence)"|", rjsToPathMap.keySet()) + ")(/.*|$)");
    }

    public <E extends Exception> void eachPath(BiConsumerCanThrowException<String, String, E> consumer) throws E {
        for (Map.Entry<String, Function<String, String>> entry : this.rjsToPathMap.entrySet()) {
            String rjsId = entry.getKey();
            consumer.accept((Object)rjsId, (Object)entry.getValue().apply(rjsId));
        }
    }

    public String pathToRequireJsModuleId(String path) {
        String withoutPrefix = RequireJsMapper.stripModulePrefix(path);
        String rjsId = this.pathToRjsMap.entrySet().stream().filter(entry -> (Boolean)((Function)entry.getKey()).apply(withoutPrefix)).findFirst().map(entry -> (String)((Function)entry.getValue()).apply(withoutPrefix)).orElseGet(() -> "nmodule/" + withoutPrefix);
        return RequireJsMapper.stripJsAndCssExtension(rjsId);
    }

    public String requireJsModuleIdToPath(String requireJsModuleId, String modulePrefix) {
        Matcher mappedMatch = this.mappedPathPrefix.matcher(requireJsModuleId);
        if (mappedMatch.matches()) {
            String mappedPrefix = mappedMatch.group(1);
            String rest = mappedMatch.group(2);
            String mapping = this.rjsToPathMap.get(mappedPrefix).apply(mappedPrefix);
            return modulePrefix + RequireJsMapper.stripJsAndCssExtension(mapping + rest) + ".js";
        }
        return RequireJsUtil.NMODULE_PATTERN.matcher(requireJsModuleId).replaceFirst(modulePrefix) + ".js";
    }

    public static String stripModulePrefix(String path) {
        return RequireJsUtil.MODULE_PREFIX_PATTERN.matcher(path).replaceFirst("");
    }

    private static Function<String, String> replacePrefix(String prefix, String replacement) {
        Pattern pattern = Pattern.compile("^" + prefix);
        return path -> pattern.matcher((CharSequence)path).replaceFirst(replacement);
    }

    private static Function<String, Boolean> startsWith(String prefix) {
        return path -> path.startsWith(prefix);
    }

    public static String stripJsAndCssExtension(String path) {
        return JS_CSS_PATTERN.matcher(path).replaceAll("");
    }

    public static class RequireJsMapperBuilder {
        private final Map<String, Function<String, String>> rjsToPathMap = new HashMap<String, Function<String, String>>();
        private final Map<Function<String, Boolean>, Function<String, String>> pathToRjsMap = new LinkedHashMap<Function<String, Boolean>, Function<String, String>>();

        public RequireJsMapperBuilder directMapping(String rjsId, String path) {
            this.rjsToPathMap.put(rjsId, r -> path);
            this.pathToRjsMap.put(path::equals, p -> rjsId);
            return this;
        }

        public RequireJsMapperBuilder prefixMapping(String rjsPrefix, String directory) {
            this.rjsToPathMap.put(rjsPrefix, RequireJsMapper.replacePrefix(rjsPrefix, directory));
            this.pathToRjsMap.put(RequireJsMapper.startsWith(directory), RequireJsMapper.replacePrefix(directory, rjsPrefix));
            return this;
        }

        public RequireJsMapperBuilder webdevMapping(String rjsId, String unminified, String minified, String webdev) {
            this.rjsToPathMap.put(rjsId, r -> WebDev.get(webdev).isEnabled() ? unminified : minified);
            this.pathToRjsMap.put(minified::equals, p -> rjsId);
            this.pathToRjsMap.put(unminified::equals, p -> rjsId);
            return this;
        }

        public RequireJsMapper build() {
            return new RequireJsMapper(this.rjsToPathMap, this.pathToRjsMap);
        }
    }
}

