/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class CoffmanGrahamDagResolver<T> {
    private final Map<T, Node> objectToNode = new HashMap<T, Node>();

    public static <T> List<Set<T>> resolve(Collection<? extends T> objects, Function<T, Collection<T>> getDependencies) {
        CoffmanGrahamDagResolver<T> resolver = new CoffmanGrahamDagResolver<T>();
        for (T t : objects) {
            CoffmanGrahamDagResolver.addToGraph(t, getDependencies, resolver);
        }
        return resolver.resolve();
    }

    private static <T> void addToGraph(T dep, Function<T, Collection<T>> getDependencies, CoffmanGrahamDagResolver<T> resolver) {
        Collection<T> depDeps = getDependencies.apply(dep);
        resolver.add(dep, depDeps);
        for (T depDep : depDeps) {
            CoffmanGrahamDagResolver.addToGraph(depDep, getDependencies, resolver);
        }
    }

    @SafeVarargs
    public final CoffmanGrahamDagResolver<T> add(T object, T ... deps) {
        return this.add(object, (Collection<T>)Arrays.asList(deps));
    }

    public final CoffmanGrahamDagResolver<T> add(T object, Collection<T> deps) {
        this.addNode(object, deps);
        return this;
    }

    private void addNode(T object, Collection<T> deps) {
        Node node = this.getNode(object);
        for (T dep : deps) {
            node.deps.add(this.getNode(dep));
        }
    }

    private Node getNode(T object) {
        return this.objectToNode.computeIfAbsent(object, x$0 -> new Node(x$0));
    }

    public List<Set<T>> resolve() {
        ArrayList<Set<T>> levels = new ArrayList<Set<T>>();
        for (Node node : this.objectToNode.values()) {
            int depth = this.getLongestDependencyChainLength(node);
            while (depth >= levels.size()) {
                levels.add(new HashSet());
            }
            ((Set)levels.get(depth)).add(node.object);
        }
        return levels;
    }

    private int getLongestDependencyChainLength(Node node) {
        int maxDepth = 0;
        for (Node dep : node.deps) {
            maxDepth = Math.max(maxDepth, 1 + this.getLongestDependencyChainLength(dep));
        }
        return maxDepth;
    }

    protected class Node {
        private final Set<Node> deps = new HashSet<Node>();
        private final T object;

        private Node(T object) {
            this.object = object;
        }
    }
}

