/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web.filters;

import com.tridium.nre.util.SecurityManagerUtil;
import com.tridium.util.SpyUtil;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BLocalScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class OrdTargetFilter
implements Filter {
    private static final Lexicon lex = Lexicon.make((String)"web");

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        OrdQuery[] queries;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        Context cx = (Context)req.getAttribute("niagara.context");
        if (cx == null || cx.getUser() == null) {
            this.log(req, "No Context available");
            resp.sendError(400);
            return;
        }
        boolean needsDecoding = true;
        String query = req.getQueryString();
        String ordStr = req.getPathInfo();
        if (ordStr == null) {
            ordStr = query;
            query = null;
        } else if (ordStr.startsWith("/")) {
            ordStr = ordStr.substring(1, ordStr.length());
            if (query != null) {
                ordStr = ordStr + "?" + OrdTargetFilter.decodeUri(query);
            }
            needsDecoding = false;
        }
        BOrd ord = ordStr == null || ordStr.length() <= 1 ? BLocalScheme.ORD : OrdTargetFilter.toOrd(ordStr, needsDecoding);
        try {
            queries = ord.parse();
        }
        catch (Throwable e) {
            this.log(req, "Unable to parse ORD: " + ord, e);
            resp.sendError(400);
            return;
        }
        for (OrdQuery ordQuery : queries) {
            if (!ordQuery.getScheme().equals("sql")) continue;
            resp.sendError(403);
            return;
        }
        if (SpyUtil.isRadioactive((BOrd)ord)) {
            ord = SpyUtil.decontaminate((BOrd)ord);
        }
        try {
            BOrd o = ord.normalize();
            AccessControlContext privilegedContext = AccessController.doPrivileged(AccessController::getContext);
            AccessControlContext privilegedContextWithSubject = SecurityManagerUtil.addSubjectToContext((AccessControlContext)privilegedContext);
            AccessController.doPrivileged(() -> {
                OrdTarget target = o.resolve((BObject)BLocalHost.INSTANCE, cx);
                req.setAttribute("niagara.target", (Object)target);
                return null;
            }, privilegedContextWithSubject);
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        catch (AccessControlException a) {
            this.log(req, "Unable to resolve ORD", a);
            LocalizableRuntimeException e = new LocalizableRuntimeException("web", "web.ord.resolve.accessDenied", null, (Throwable)a);
            WebUtil.sendSafeErrorToUser(resp, 403, (Throwable)e, cx);
        }
        catch (Throwable e) {
            this.log(req, "Unable to resolve ORD", e);
            WebUtil.sendSafeErrorToUser(resp, 404, e, cx);
        }
    }

    private void log(HttpServletRequest req, String msg) {
        req.getServletContext().log(msg);
    }

    private void log(HttpServletRequest req, String msg, Throwable e) {
        req.getServletContext().log(msg, e);
    }

    public static String fromOrd(BOrd ord) throws URISyntaxException {
        if (ord.isNull()) {
            return "/ord";
        }
        URI uri = new URI(null, null, "/ord/" + ord.toString(), null);
        return uri.toASCIIString();
    }

    public static BOrd toOrd(String path) throws UnsupportedEncodingException {
        return OrdTargetFilter.toOrd(path, true);
    }

    private static BOrd toOrd(String path, boolean needsDecoding) throws UnsupportedEncodingException {
        if (path.isEmpty()) {
            return BOrd.NULL;
        }
        if (needsDecoding) {
            return BOrd.make((String)OrdTargetFilter.decodeUri(path));
        }
        return BOrd.make((String)path);
    }

    private static String decodeUri(String uri) throws UnsupportedEncodingException {
        return URLDecoder.decode(uri.replace("+", "%2B"), "UTF-8");
    }
}

