/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.util.Href2Ord;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Optional;
import javax.baja.io.HtmlWriter;
import javax.baja.nre.util.TextUtil;

public abstract class SnoopHtmlWriter
extends HtmlWriter {
    private int c0;
    private int c1;
    private int c2;
    private int c3;
    private int c4;
    private int c5;
    private int c6;
    private int c7;
    private boolean inElement;
    private boolean inTagName;
    private boolean translateOnQuote;
    private boolean inTranslation;
    private boolean cancelTranslation;
    private int translateClose;
    private final StringBuilder hrefBuf = new StringBuilder();
    private final StringBuilder tagBuf = new StringBuilder();
    protected Href2Ord href2Ord;
    protected boolean ignoreNoSnoop = false;

    protected SnoopHtmlWriter(Writer out) {
        super(out);
    }

    protected void pipe(Reader reader) throws IOException {
        int n;
        int len = 4096;
        char[] buf = new char[len];
        while ((n = reader.read(buf, 0, len)) >= 0) {
            this.write(buf, 0, n);
        }
        this.flush();
    }

    public void print(String s) {
        this.write(s, 0, s.length());
    }

    public void write(char[] c) {
        this.write(c, 0, c.length);
    }

    public void write(char[] c, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(c[i + off]);
        }
    }

    public void write(String s) {
        this.write(s, 0, s.length());
    }

    public void write(String s, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i + off));
        }
    }

    public void write(int c) {
        if (!this.ignoreNoSnoop && !this.cancelTranslation && this.c0 == 64 && this.c1 == 110 && this.c2 == 111 && this.c3 == 115 && this.c4 == 110 && this.c5 == 111 && this.c6 == 111 && this.c7 == 112) {
            this.cancelTranslation = true;
        }
        if (!this.cancelTranslation) {
            if (c == 60) {
                this.enterElementTag();
            } else if (c == 62) {
                this.exitElementTag();
            } else if (this.translateOnQuote && (c == 34 || c == 39)) {
                this.enterTranslation(c);
            } else if (this.inTranslation) {
                if (c == this.translateClose) {
                    this.exitTranslation();
                } else {
                    this.hrefBuf.append((char)c);
                    return;
                }
            }
            this.c0 = this.c1;
            this.c1 = this.c2;
            this.c2 = this.c3;
            this.c3 = this.c4;
            this.c4 = this.c5;
            this.c5 = this.c6;
            this.c6 = this.c7;
            this.c7 = TextUtil.toLowerCase((char)((char)c));
            if (this.inElement) {
                if (this.inTagName) {
                    boolean whitespace = SnoopHtmlWriter.isWhiteSpace(this.c7);
                    if (whitespace && this.tagBuf.length() > 0) {
                        this.inTagName = false;
                    } else if (this.tagBuf.length() != 0 || this.c7 != 60) {
                        this.tagBuf.append((char)this.c7);
                    }
                } else if (this.c4 == 115 && this.c5 == 114 && this.c6 == 99 && this.c7 == 61 || this.c3 == 115 && this.c4 == 114 && this.c5 == 99 && SnoopHtmlWriter.isWhiteSpace(this.c6) && SnoopHtmlWriter.isWhiteSpaceOrEquals(this.c7)) {
                    this.translateOnQuote = true;
                } else if (this.c3 == 104 && this.c4 == 114 && this.c5 == 101 && this.c6 == 102 && this.c7 == 61 || this.c2 == 104 && this.c3 == 114 && this.c4 == 101 && this.c5 == 102 && SnoopHtmlWriter.isWhiteSpace(this.c6) && SnoopHtmlWriter.isWhiteSpaceOrEquals(this.c7)) {
                    this.translateOnQuote = true;
                } else if (this.c1 == 97 && this.c2 == 99 && this.c3 == 116 && this.c4 == 105 && this.c5 == 111 && this.c6 == 110 && this.c7 == 61 || this.c0 == 97 && this.c1 == 99 && this.c2 == 116 && this.c3 == 105 && this.c4 == 111 && this.c5 == 110 && SnoopHtmlWriter.isWhiteSpace(this.c6) && SnoopHtmlWriter.isWhiteSpaceOrEquals(this.c7)) {
                    this.translateOnQuote = true;
                }
            }
            if (this.c3 == 117 && this.c4 == 114 && this.c5 == 108 && this.c6 == 40) {
                if (this.c7 == 34 || this.c7 == 39) {
                    this.enterTranslation(this.c7);
                } else {
                    this.enterTranslation(41);
                    this.hrefBuf.append((char)c);
                    return;
                }
            }
        }
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private void enterElementTag() {
        this.inElement = true;
        this.inTagName = true;
        this.inTranslation = false;
        this.translateOnQuote = false;
        this.tagBuf.setLength(0);
    }

    private void exitElementTag() {
        this.inElement = false;
        this.inTagName = false;
        this.inTranslation = false;
        this.translateOnQuote = false;
    }

    private void enterTranslation(int closeChar) {
        this.inTranslation = true;
        this.translateOnQuote = false;
        this.translateClose = closeChar;
        this.hrefBuf.setLength(0);
    }

    private void exitTranslation() {
        this.inTranslation = false;
        this.c7 = 0;
        this.c6 = 0;
        this.c5 = 0;
        this.c4 = 0;
        this.c3 = 0;
        this.c2 = 0;
        this.c1 = 0;
        this.c0 = 0;
        Optional<String> tag = this.tagBuf.length() > 0 ? Optional.of(this.tagBuf.toString()) : Optional.empty();
        String href = this.hrefBuf.toString();
        String uri = this.hrefToUri(href, tag);
        try {
            int len = uri.length();
            for (int i = 0; i < len; ++i) {
                this.out.write(uri.charAt(i));
            }
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    private static boolean isWhiteSpaceOrEquals(int c) {
        return c == 61 || SnoopHtmlWriter.isWhiteSpace(c);
    }

    protected abstract String hrefToUri(String var1, Optional<String> var2);
}

