/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.web;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BDigestAuthenticationScheme;
import com.tridium.authn.BSSOConfiguration;
import com.tridium.authn.LoginFailureCause;
import com.tridium.json.JSONObject;
import com.tridium.nre.util.tuple.Pair;
import com.tridium.sys.license.BLicenseExpirationNotificationSettings;
import com.tridium.sys.license.BSMANotificationSettings;
import com.tridium.sys.license.LicenseNotFoundException;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.user.BGlobalPasswordConfiguration;
import com.tridium.web.CookieUtil;
import com.tridium.web.Template;
import com.tridium.web.authn.FormsAndSchemesHandler;
import com.tridium.web.servlets.LoginSupport;
import com.tridium.web.servlets.WebStartServlet;
import com.tridium.web.session.NiagaraWebSession;
import com.tridium.web.session.WebSessionUtil;
import java.io.IOException;
import java.security.AccessController;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.BClientEnvironments;
import javax.baja.web.BLoginTemplate;
import javax.baja.web.BWebService;
import javax.baja.web.UserAgent;
import javax.baja.web.authn.BILoginHTMLForm;
import javax.baja.web.mobile.BMobileClientEnvironment;
import javax.baja.xml.XWriter;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.owasp.encoder.Encode;

@NiagaraType
@NiagaraSingleton
public final class BDefaultLoginTemplate
extends BLoginTemplate {
    @Generated
    public static final BDefaultLoginTemplate INSTANCE = new BDefaultLoginTemplate();
    @Generated
    public static final Type TYPE = Sys.loadType(BDefaultLoginTemplate.class);
    private static final String xuaCompatibleContent = XWriter.safeToString((String)AccessController.doPrivileged(() -> System.getProperty("niagara.profile.X-UA-Compatible-content", "IE=edge")), (boolean)false);
    private static final BOrd loginTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/loginN4.vm");
    private static final BOrd logoTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/logoN4.vm");
    private static final BOrd loginCssTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/loginCssN4.vm");
    private static final BOrd eulaTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/eulaN4.vm");
    private static final BOrd preLoginTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/preLoginFormN4.vm");
    private static final BOrd ssoSectionTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/ssoForm.vm");
    private static final BOrd ssoButtonTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/ssoButton.vm");
    private static final BOrd passwordExpirationTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/passwordExpirationFormN4.vm");
    private static final BOrd networkPasswordExpirationTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/networkPasswordExpirationFormN4.vm");
    private static final BOrd webstartTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/webstartN4.vm");
    private static final BOrd schemeSelectTemplate = BOrd.make((String)"module://web/com/tridium/web/rc/schemeSelect.vm");
    private static final String LEX_WEB_REMEMBER = "sso.web.remember";
    private static final String LEX_WEB_REMEMBER_STATION = "sso.web.remember.stationOnly";
    private static final String LEX_WEB_REMEMBER_DOMAIN = "sso.web.remember.domain";
    private static final String LEX_WEB_EULA = "sso.web.eula.message";
    private static final String LEX_SMA_EXPIRATION_DATE = "login.eula.smaExpirationDate";
    private static final String LEX_LICENSE_EXPIRATION_DATE = "login.eula.licenseExpirationDate";
    private static final String MOBILE_DOWNLOAD_LINK = AccessController.doPrivileged(() -> System.getProperty("niagara.webstart.jnlp.mobileDownloadLink"));
    private Lexicon lex;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BDefaultLoginTemplate() {
    }

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.lex = Lexicon.make((String)"web", (Locale)request.getLocale());
        BWebService service = BWebService.getMainService();
        BasicContext context = new BasicContext(null, request.getLocale().toLanguageTag());
        String username = this.getRequestedUsername(request);
        String innerForm = this.getInnerForm(username, (Context)context, request);
        String extraForms = this.getExtraForms(username, (Context)context, request);
        String action = username == null ? "login" : "j_security_check";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("compatibilityContent", xuaCompatibleContent);
        map.put("title", this.getTitle((Context)context));
        map.put("login", this.lex.getHtmlSafe("login"));
        map.put("logo", service.get("logo") == null ? "" : Template.process(logoTemplate, true));
        map.put("loginCss", service.get("loginCss") == null ? "" : Template.process(loginCssTemplate, true));
        map.put("action", action);
        map.put("loginForm", innerForm);
        map.put("extraForms", extraForms);
        HashMap<String, String> eulaMap = new HashMap<String, String>();
        eulaMap.put("loginEulaPretext", this.lex.getHtmlSafe("login.eula.preText"));
        eulaMap.put("loginEulaLinkSubText", this.lex.getHtmlSafe("login.eula.linkSubText"));
        eulaMap.put("loginEulaLink", Encode.forJavaScript((String)this.lex.getHtmlSafe("login.eula.eulaLinkTitle")));
        eulaMap.put("loginEulaLinkThirdParty", Encode.forJavaScript((String)this.lex.getHtmlSafe("login.eula.thirdPartyLicensesLinkTitle")));
        map.put("eula", Template.process(eulaMap, eulaTemplate, true));
        map.put("autoLogoffInformation", this.lex.getHtmlSafe("login.autoLogoffInformation"));
        String webstartDiv = "";
        if (this.shouldAddWebStartJnlpLink(service, request)) {
            HashMap<String, String> webstartTemplateParams = new HashMap<String, String>();
            webstartTemplateParams.put("wbLiteLink", this.getWbLiteAnchorText(request, this.lex));
            webstartTemplateParams.put("webStartJnlpDownloadClass", UserAgent.isNiagara4WebStart(request) || UserAgent.isNiagaraWebLauncher(request) ? "webStartJnlpDownloadHidden" : "");
            webstartDiv = Template.process(webstartTemplateParams, webstartTemplate, true);
        }
        NLicenseManager lm = (NLicenseManager)Sys.getLicenseManager();
        String vendor = Sys.getBajaVendor();
        try {
            long licenseExpiration = lm.getLicenseExpiration(vendor);
            map.put("licenseExpiration", this.getLicenseExpirationNotice(licenseExpiration, (Context)context));
        }
        catch (LicenseNotFoundException e) {
            log.log(Level.SEVERE, "Unable to find license for the given vendor or found an invalid license.", e);
        }
        Optional maintenanceExpiration = lm.getLicenseMaintenanceExpiration(vendor);
        map.put("sma", this.getSMAExpirationNotice(maintenanceExpiration.orElse(null), (Context)context));
        map.put("webstart", webstartDiv);
        String loginFailed = this.lex.getHtmlSafe("login.failed");
        LoginFailureCause loginFailureCause = this.getLoginFailureCause(request, response);
        if (loginFailureCause != null) {
            String loginFailureInfo;
            loginFailed = Encode.forHtml((String)loginFailureCause.getDefaultFailureTitle(request.getLocale()));
            loginFailed = loginFailed + "<br />" + Encode.forHtml((String)loginFailureCause.getDefaultFailureMessage(request.getLocale()));
            if (loginFailureCause.equals((Object)LoginFailureCause.SESSION_TIMEOUT)) {
                loginFailed = this.lex.getHtmlSafe("login.autoLogoffInformation");
            }
            if ((loginFailureInfo = this.getLoginFailureInfo(request, response)) != null) {
                loginFailed = loginFailed + ": " + Encode.forHtml((String)loginFailureInfo);
            }
        }
        map.put("loginFailed", loginFailed);
        map.put("resetMessage", this.makeResetMessage(request, (Context)context));
        map.put("noScript", this.lex.getHtmlSafe("no.javascript"));
        String html = Template.process(map, loginTemplate, true);
        response.getWriter().print(html);
    }

    private String getTitle(Context ctx) {
        String title = Sys.getStation().getStationDisplayName(ctx);
        return title != null ? Encode.forHtml((String)title) : "";
    }

    private String getWbLiteAnchorText(HttpServletRequest request, Lexicon lex) {
        String wbLiteHref = "/webstart/nwl";
        String lexKey = "login.nwl.link";
        boolean webLauncher = UserAgent.isNiagaraWebLauncher(request);
        boolean n4WebStart = UserAgent.isNiagara4WebStart(request);
        boolean axWebStart = UserAgent.isNiagaraAxWebStart(request);
        if (webLauncher || n4WebStart) {
            String initialPath = "/";
            String originURI = LoginSupport.getOriginUri(request);
            if (originURI != null) {
                initialPath = originURI;
            }
            wbLiteHref = WebStartServlet.makeWbLitePath(initialPath);
            lexKey = axWebStart ? "login.nwl.other" : "login.nwl.new";
        }
        String wbLiteFileLink = "<a id=\"niagara_webLauncherExternalLink\" href=\"" + wbLiteHref + "\">" + lex.getHtmlSafe("login.webstart.link") + "</a>";
        String text = lex.getHtmlSafeText(lexKey, new Object[]{""}) + wbLiteFileLink;
        if (axWebStart && webLauncher) {
            text = "<div class=\"webstartVersionWarning\">" + lex.getHtmlSafe("login.webLauncher.differentVer") + "<br />" + text + "</div>";
        }
        return text;
    }

    @Override
    public BOrd resourceToOrd(String path) {
        return BOrd.make((String)("module://web/com/tridium/web/rc" + path));
    }

    private String getRequestedUsername(HttpServletRequest request) {
        return LoginSupport.getRequestedUsername(request);
    }

    private LoginFailureCause getLoginFailureCause(HttpServletRequest request, HttpServletResponse response) {
        String loginFailureCause = null;
        Cookie loginFailureCauseCookie = CookieUtil.getCookieFromName(request, "niagara_failure_cause");
        if (loginFailureCauseCookie != null) {
            loginFailureCause = loginFailureCauseCookie.getValue();
            response.addCookie(CookieUtil.createCookie("niagara_failure_cause", "", 0));
        }
        if (loginFailureCause == null) {
            loginFailureCause = request.getParameter("loginFailureCause");
        }
        if (loginFailureCause != null) {
            try {
                return LoginFailureCause.valueOf((String)loginFailureCause);
            }
            catch (IllegalArgumentException e) {
                return LoginFailureCause.GENERIC;
            }
        }
        return null;
    }

    private String getLoginFailureInfo(HttpServletRequest request, HttpServletResponse response) {
        String loginFailureInfo;
        block3: {
            Cookie loginFailureInfoCookie;
            loginFailureInfo = null;
            if (loginFailureInfo == null && (loginFailureInfoCookie = CookieUtil.getCookieFromName(request, "niagara_failure_info")) != null) {
                try {
                    loginFailureInfo = new String(Base64.getDecoder().decode(loginFailureInfoCookie.getValue()));
                    response.addCookie(CookieUtil.createCookie("niagara_failure_info", "", 0));
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINER)) break block3;
                    log.log(Level.FINER, "Could not generate login failure info from cookie - format is invalid", e);
                }
            }
        }
        return loginFailureInfo;
    }

    private Pair<BAuthenticationScheme, BILoginHTMLForm> getSchemeAndFormBuilder(HttpServletRequest request, @NotNull String username, Context context) {
        BAuthenticationScheme authnScheme;
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        if (authnService.getStrictAuthentication()) {
            authnScheme = LoginSupport.getSelectedAuthenticationScheme(request);
        } else {
            try {
                authnScheme = userService.getAuthenticationSchemeForUser(username);
            }
            catch (Exception e) {
                authnScheme = new BDigestAuthenticationScheme();
            }
        }
        BILoginHTMLForm formBuilder = FormsAndSchemesHandler.getInstance().getLoginFormFromRequest(request).orElse((BILoginHTMLForm)authnScheme.getAgentOn(BILoginHTMLForm.class));
        if (formBuilder == null) {
            authnScheme = new BDigestAuthenticationScheme();
            formBuilder = (BILoginHTMLForm)authnScheme.getAgentOn(BILoginHTMLForm.class);
        }
        context = new BasicContext(context, BFacets.make((String)"initUsername", (String)Encode.forHtmlAttribute((String)username)));
        formBuilder.initialize(request, authnScheme, context);
        return new Pair((Object)authnScheme, (Object)formBuilder);
    }

    private String getInnerForm(String username, Context context, HttpServletRequest request) throws IOException {
        if (username != null) {
            Long expTime;
            Boolean reset;
            context = new BasicContext(context, BFacets.make((String)"initUsername", (String)Encode.forHtmlAttribute((String)username)));
            Pair<BAuthenticationScheme, BILoginHTMLForm> pair = this.getSchemeAndFormBuilder(request, username, context);
            BAuthenticationScheme authnScheme = (BAuthenticationScheme)pair.getFirst();
            BILoginHTMLForm innerFormBuilder = (BILoginHTMLForm)pair.getSecond();
            NiagaraWebSession session = WebSessionUtil.getSession(request, false);
            Boolean bl = reset = session == null ? null : (Boolean)session.getAttribute("forceReset");
            if (reset != null && reset.booleanValue()) {
                BGlobalPasswordConfiguration config = ((BPasswordAuthenticationScheme)authnScheme).getGlobalPasswordConfiguration();
                BPasswordStrength strength = config.getPasswordStrength();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("pwdStrength", this.getPasswordStrengthJSON(strength));
                String error = (String)session.getAttribute("resetError");
                session.removeAttribute("resetError");
                if (error != null) {
                    String alert = "alert('Error resetting password:\n\n" + error + "');";
                    alert = alert.replace("\n", "\\n");
                    map.put("resetError", alert);
                } else {
                    map.put("resetError", "");
                }
                return Template.process(map, innerFormBuilder.getLoginFormHTML(context, true));
            }
            Long l = expTime = session == null ? null : (Long)session.getAttribute("passwordExpires");
            if (expTime != null) {
                Lexicon lex = Lexicon.make((String)"fox", (String)context.getLanguage());
                BAbsTime exp = BAbsTime.make((long)expTime);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("passExpTitle", lex.getHtmlSafe("fox.login.password.expirationTitle"));
                Boolean networkUser = (Boolean)session.getAttribute("networkUser");
                if (networkUser != null && networkUser.booleanValue()) {
                    map.put("passExpMessage", lex.getHtmlSafeText("fox.network.user.password.expiring", new Object[]{exp}));
                    map.put("ok", lex.getHtmlSafe("fox.login.passwordResetMessage.dialog.ok"));
                    return Template.process(map, networkPasswordExpirationTemplate);
                }
                map.put("passExpMessage", lex.getHtmlSafeText("fox.user.password.expiring", new Object[]{exp}));
                map.put("no", lex.getHtmlSafe("fox.login.passwordResetMessage.dialog.No"));
                map.put("yes", lex.getHtmlSafe("fox.login.passwordResetMessage.dialog.Yes"));
                return Template.process(map, passwordExpirationTemplate);
            }
            return innerFormBuilder.getLoginFormHTML(context, false);
        }
        BWebService service = BWebService.getMainService();
        Lexicon lex = Lexicon.make((String)"web", (String)context.getLanguage());
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("userName", lex.getHtmlSafe("login.username"));
        innerMap.put("login", lex.getHtmlSafe("login"));
        innerMap.put("autocomplete", service.getAllowUsernameAutocomplete() ? "on" : "off");
        innerMap.put("schemeSelect", this.getSchemeSelect(context));
        return Template.process(innerMap, preLoginTemplate, true);
    }

    private String getExtraForms(String username, Context context, HttpServletRequest request) throws IOException {
        Boolean reset;
        BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        BSSOConfiguration ssoConfiguration = authnService.getSsoConfiguration();
        Lexicon lex = Lexicon.make((String)"web", (String)context.getLanguage());
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        Boolean bl = reset = session == null ? null : (Boolean)session.getAttribute("forceReset");
        if (reset != null && reset.booleanValue()) {
            return "";
        }
        StringBuilder ssoButtonsHTML = new StringBuilder();
        authnService.getSupportedSchemes().stream().filter(scheme -> scheme instanceof BSSOAuthenticationScheme).map(scheme -> (BSSOAuthenticationScheme)scheme).forEach(ssoScheme -> {
            try {
                HashMap<String, String> buttonMap = new HashMap<String, String>();
                buttonMap.put("loginButtonText", Encode.forHtmlContent((String)ssoScheme.getLoginButtonText()));
                Optional helpHTML = ssoScheme.getHelpHTML();
                buttonMap.put("helpLinkText", helpHTML.isPresent() ? Encode.forHtmlContent((String)lex.getHtmlSafe("sso.web.help", "Help")) : "");
                buttonMap.put("helpHTML", ssoScheme.getHelpHTML().orElse(""));
                buttonMap.put("ssoId", Encode.forHtml((String)ssoScheme.getName()));
                ssoButtonsHTML.append(Template.process(buttonMap, ssoButtonTemplate, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        String extraForms = "";
        if (ssoButtonsHTML.length() > 0) {
            HashMap<String, String> ssoMap = new HashMap<String, String>();
            String hidden = username != null && !authnService.getSsoConfiguration().getDisplaySSOSchemesOnLoginPage() ? "hidden" : "";
            String rememberChoice = lex.getHtmlSafe(LEX_WEB_REMEMBER);
            String rememberDomain = ssoConfiguration.getRememberMyChoiceDomain();
            rememberDomain = rememberDomain == null || rememberDomain.isEmpty() ? lex.getHtmlSafe(LEX_WEB_REMEMBER_STATION) : lex.getHtmlSafeText(LEX_WEB_REMEMBER_DOMAIN, new Object[]{rememberDomain});
            String rememberText = String.format("%s<br>(%s)", rememberChoice, rememberDomain);
            ssoMap.put("hidden", hidden);
            ssoMap.put("rememberText", rememberText);
            ssoMap.put("ssoButtons", ssoButtonsHTML.toString());
            ssoMap.put("ssoEulaText", lex.getHtmlSafe(LEX_WEB_EULA));
            extraForms = extraForms + Template.process(ssoMap, ssoSectionTemplate, true);
        }
        return extraForms;
    }

    private String getSchemeSelect(Context context) throws IOException {
        String schemeSelect = "";
        BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        if (authnService.getStrictAuthentication()) {
            String defaultSchemeName = authnService.getDefaultSchemeWithAgent(BILoginHTMLForm.class).getName();
            List schemes = authnService.getSchemesWithAgent(BILoginHTMLForm.class);
            StringBuilder schemeOptions = new StringBuilder();
            for (BAuthenticationScheme scheme : schemes) {
                String schemeName = scheme.getName();
                String displayName = scheme.getDisplayName(context);
                String selected = "";
                if (schemeName.equals(defaultSchemeName)) {
                    selected = " selected";
                }
                schemeOptions.append("<option value=\"").append(schemeName).append('\"').append(selected).append('>').append(Encode.forHtml((String)displayName)).append("</option>\n");
            }
            HashMap<String, String> schemeSelectMap = new HashMap<String, String>();
            schemeSelectMap.put("scheme", this.lex.getHtmlSafe("login.scheme"));
            schemeSelectMap.put("schemes", schemeOptions.toString());
            schemeSelect = Template.process(schemeSelectMap, schemeSelectTemplate, true);
        }
        return schemeSelect;
    }

    private String makeResetMessage(HttpServletRequest request, Context context) throws IOException {
        Boolean reset;
        String username = this.getRequestedUsername(request);
        NiagaraWebSession session = WebSessionUtil.getSession(request, false);
        Boolean bl = reset = session == null ? null : (Boolean)session.getAttribute("forceReset");
        if (reset != null && reset.booleanValue()) {
            BILoginHTMLForm formBuilder = (BILoginHTMLForm)this.getSchemeAndFormBuilder(request, username, context).getSecond();
            context = new BasicContext(context, BFacets.make((String)"initUsername", (String)Encode.forHtmlAttribute((String)username)));
            return formBuilder.getResetMessageHTML(request, context);
        }
        return "";
    }

    private String getPasswordStrengthJSON(BPasswordStrength pwdStrength) {
        JSONObject obj = new JSONObject();
        obj.put("minimumDigits", pwdStrength.getMinimumDigits());
        obj.put("minimumLength", pwdStrength.getMinimumLength());
        obj.put("minimumLowerCase", pwdStrength.getMinimumLowerCase());
        obj.put("minimumSpecial", pwdStrength.getMinimumSpecial());
        obj.put("minimumUpperCase", pwdStrength.getMinimumUpperCase());
        obj.put("maximumLength", pwdStrength.getMaximumLength());
        return obj.toString();
    }

    private boolean shouldAddWebStartJnlpLink(BWebService service, HttpServletRequest req) {
        if (!this.isLicensedForWebStart(service)) {
            return false;
        }
        if (!service.getWebStartConfig().getWebStartEnabled()) {
            return false;
        }
        String userAgent = req.getHeader("user-agent");
        if (userAgent != null && this.isMobileEnvironment(userAgent, service)) {
            return this.shouldAddJnlpLinkForMobile();
        }
        return true;
    }

    private boolean isMobileEnvironment(String ua, BWebService service) {
        BMobileClientEnvironment env;
        SlotCursor cursor;
        BClientEnvironments envs = service.getClientEnvironments();
        return envs != null && (cursor = envs.getProperties()).next(BMobileClientEnvironment.class) && (env = (BMobileClientEnvironment)cursor.get()).matchesUserAgentPattern(ua);
    }

    private boolean isLicensedForWebStart(BWebService service) {
        try {
            Feature feature = service.getLicenseFeature();
            return feature.getb("ui", false) && feature.getb("ui.wb", false);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean shouldAddJnlpLinkForMobile() {
        if (MOBILE_DOWNLOAD_LINK != null) {
            return "true".equals(MOBILE_DOWNLOAD_LINK);
        }
        return false;
    }

    private String getSMAExpirationNotice(Long lme, Context context) {
        String smaExpNotice = null;
        String className = "class=\"sma-callout\"";
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BSMANotificationSettings smaSettings = userService.getSMANotificationSettings();
        if (smaSettings.getEnabled() && lme != null) {
            int noDaysUntilExpiry = BAbsTime.now().delta(BAbsTime.make((long)lme)).getDays();
            if (noDaysUntilExpiry <= 0) {
                smaExpNotice = this.lex.getHtmlSafeText("login.eula.smaExpired");
            } else if (smaSettings.getExpirationReminder() >= noDaysUntilExpiry && smaSettings.getShowExpirationReminder()) {
                smaExpNotice = this.lex.getHtmlSafeText("login.eula.smaReminder", new Object[]{noDaysUntilExpiry});
            } else if (smaSettings.getShowExpirationDate() && !lme.equals(Long.MAX_VALUE)) {
                smaExpNotice = this.getExpirationDateText(LEX_SMA_EXPIRATION_DATE, lme, context);
                className = "";
            }
        }
        return smaExpNotice != null && !smaExpNotice.equals("") ? "<br><div id=\"sma\" " + className + ">" + smaExpNotice + "</div>" : "";
    }

    private String getLicenseExpirationNotice(Long le, Context cx) {
        String licExpNotice = null;
        String className = "class=\"sma-callout\"";
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BLicenseExpirationNotificationSettings licenseSettings = userService.getLicenseExpirationNotificationSettings();
        if (licenseSettings.getEnabled()) {
            int noDaysUntilExpiry = BAbsTime.now().delta(BAbsTime.make((long)le)).getDays();
            if (noDaysUntilExpiry <= 0) {
                licExpNotice = this.lex.getHtmlSafeText("login.eula.licenseExpired");
            } else if (licenseSettings.getExpirationReminder() >= noDaysUntilExpiry && licenseSettings.getShowExpirationReminder()) {
                licExpNotice = this.lex.getHtmlSafeText("login.eula.licenseReminder", new Object[]{noDaysUntilExpiry});
            } else if (licenseSettings.getShowExpirationDate() && !le.equals(Long.MAX_VALUE)) {
                licExpNotice = this.getExpirationDateText(LEX_LICENSE_EXPIRATION_DATE, le, cx);
                className = "";
            }
        }
        return licExpNotice != null && !licExpNotice.equals("") ? "<br><div id=\"sma\" " + className + ">" + licExpNotice + "</div><br>" : "";
    }

    private String getExpirationDateText(String lexKey, Long exp, Context cx) {
        String notice = this.lex.getHtmlSafeText(lexKey, new Object[]{"{{INSERTDATEHERE}}"});
        String encodedDate = Encode.forHtml((String)BAbsTime.make((long)exp).toDateString(cx));
        String expirationDate = "<span class=\"sma-date\">" + encodedDate + "</span>";
        return notice.replace("{{INSERTDATEHERE}}", expirationDate);
    }
}

