/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.azureUtils;

import com.tridium.azureUtils.AzureIotSasTokenUtils;
import com.tridium.azureUtils.AzureSasException;
import com.tridium.azureUtils.Storable;
import java.util.HashMap;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="azureHost", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="azureDeviceId", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="apiVersion", type="String", defaultValue="BString.make(\"2018-06-30\")"), @NiagaraProperty(name="sharedAccessKeyStored", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="userName", type="String", defaultValue="BString.DEFAULT", flags=65), @NiagaraProperty(name="nextTokenExpiryPeriod", type="BRelTime", defaultValue="BRelTime.makeDays(1)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"day\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeMinutes(10)"), @Facet(name="BFacets.MAX", value="BRelTime.makeDays(365)")})})
public class BAzureSasTokenParameters
extends BComponent
implements Storable {
    @Generated
    public static final Property azureHost = BAzureSasTokenParameters.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property azureDeviceId = BAzureSasTokenParameters.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property apiVersion = BAzureSasTokenParameters.newProperty((int)0, (BValue)BString.make((String)"2018-06-30"), null);
    @Generated
    public static final Property sharedAccessKeyStored = BAzureSasTokenParameters.newProperty((int)65, (boolean)false, null);
    @Generated
    public static final Property userName = BAzureSasTokenParameters.newProperty((int)65, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property nextTokenExpiryPeriod = BAzureSasTokenParameters.newProperty((int)0, (BValue)BRelTime.makeDays((int)1), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"day")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)10))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeDays((int)365))));
    @Generated
    public static final Type TYPE = Sys.loadType(BAzureSasTokenParameters.class);
    private String sharedAccessKey;
    private static final long MAX_EXPIRY = BRelTime.makeDays((int)365).getMillis();
    public static final String KEYRING_ENTRY_TYPE = "AzureSharedAccessKey";
    private static final Lexicon LEX = Lexicon.make(BAzureSasTokenParameters.class);
    private static final Map<Property, String> VALIDATION_PROPERTIES = new HashMap<Property, String>();
    private static final BIcon icon;

    @Generated
    public String getAzureHost() {
        return this.getString(azureHost);
    }

    @Generated
    public void setAzureHost(String v) {
        this.setString(azureHost, v, null);
    }

    @Generated
    public String getAzureDeviceId() {
        return this.getString(azureDeviceId);
    }

    @Generated
    public void setAzureDeviceId(String v) {
        this.setString(azureDeviceId, v, null);
    }

    @Generated
    public String getApiVersion() {
        return this.getString(apiVersion);
    }

    @Generated
    public void setApiVersion(String v) {
        this.setString(apiVersion, v, null);
    }

    @Generated
    public boolean getSharedAccessKeyStored() {
        return this.getBoolean(sharedAccessKeyStored);
    }

    @Generated
    public void setSharedAccessKeyStored(boolean v) {
        this.setBoolean(sharedAccessKeyStored, v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BRelTime getNextTokenExpiryPeriod() {
        return (BRelTime)this.get(nextTokenExpiryPeriod);
    }

    @Generated
    public void setNextTokenExpiryPeriod(BRelTime v) {
        this.set(nextTokenExpiryPeriod, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BAzureSasTokenParameters make(String azureHost, String deviceId, String sharedAccessKey, String username) {
        BAzureSasTokenParameters params = new BAzureSasTokenParameters();
        params.setAzureHost(azureHost);
        params.setAzureDeviceId(deviceId);
        params.setUserName(username);
        params.sharedAccessKey = sharedAccessKey;
        return params;
    }

    public void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    @Override
    public String getStoreValue() {
        return this.sharedAccessKey;
    }

    @Override
    public String getStoreEntryType() {
        return KEYRING_ENTRY_TYPE;
    }

    @Override
    public void load(String storedValue) {
        this.sharedAccessKey = storedValue;
    }

    @Override
    public void store(String storeKey) throws AzureSasException {
        Storable.super.store(storeKey);
        this.setSharedAccessKeyStored(true);
    }

    public void validate(String storeKey) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Can only generate a token in a running station");
        }
        VALIDATION_PROPERTIES.forEach((prop, lexKey) -> {
            if (prop.getType().equals(BString.TYPE) && ((BString)this.get((Property)prop).as(BString.class)).getString().isEmpty() || prop.getType().equals(BPassword.TYPE) && ((BPassword)this.get((Property)prop).as(BPassword.class)).isDefault()) {
                throw new IllegalStateException(LEX.getText(lexKey));
            }
        });
        if (this.getNextTokenExpiryPeriod().getMillis() < 1L || this.getNextTokenExpiryPeriod().getMillis() > MAX_EXPIRY) {
            throw new IllegalStateException(LEX.getText("azure.sas.expiryRange"));
        }
        try {
            AzureIotSasTokenUtils.loadFromKeyRing(storeKey, this);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static {
        VALIDATION_PROPERTIES.put(azureHost, "azure.sas.missingHost");
        VALIDATION_PROPERTIES.put(azureDeviceId, "azure.sas.missingDevName");
        icon = BIcon.make((BIcon)BIcon.std((String)"keys.png"), (BIcon)BIcon.std((String)"badges/gear.png"));
    }
}

