/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.azureUtils;

import com.tridium.azureUtils.AzureSasException;
import com.tridium.azureUtils.AzureSasTokenParameters;
import com.tridium.azureUtils.BAzureIotSasToken;
import com.tridium.azureUtils.BAzureSasTokenParameters;
import com.tridium.azureUtils.Storable;
import com.tridium.nre.security.KeyRing;
import com.tridium.nre.security.SecurityInitializer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.util.Lexicon;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class AzureIotSasTokenUtils {
    private static final Clock CLOCK = Clock.systemUTC();
    private static final String HOST_TOKEN_NAME = "HostName";
    private static final String DEVICE_ID_TOKEN_NAME = "DeviceId";
    private static final String SHARED_KEY_TOKEN_NAME = "SharedAccessKey";
    private static final Logger LOG = Logger.getLogger("abstractMqttDriver.authenticator.azure");
    private static final Lexicon LEX = Lexicon.make(AzureIotSasTokenUtils.class);

    private AzureIotSasTokenUtils() {
    }

    public static AzureSasTokenParameters getParametersForConnectionString(String connectionString, String apiVersion) {
        if (connectionString == null || connectionString.isEmpty()) {
            throw new IllegalArgumentException("Can not generate Azure token parameters from empty connection string value");
        }
        if (apiVersion == null || apiVersion.isEmpty()) {
            throw new IllegalArgumentException("Can not generate Azure token parameters from empty api-version value");
        }
        String[] pairs = connectionString.split(";");
        HashMap<String, String> tokens = new HashMap<String, String>();
        Arrays.stream(pairs).forEach(pair -> {
            String[] keyValue = pair.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Empty Azure connection parameter");
            }
            tokens.put(keyValue[0], keyValue[1]);
        });
        String azureHost = AzureIotSasTokenUtils.extractTokenValue(tokens, HOST_TOKEN_NAME);
        String azureDeviceId = AzureIotSasTokenUtils.extractTokenValue(tokens, DEVICE_ID_TOKEN_NAME);
        String sharedAccessKey = AzureIotSasTokenUtils.extractTokenValue(tokens, SHARED_KEY_TOKEN_NAME);
        String userName = String.format("%s/%s/?api-version=%s", azureHost, azureDeviceId, apiVersion);
        return new AzureSasTokenParameters(azureHost, azureDeviceId, sharedAccessKey, userName);
    }

    private static String extractTokenValue(Map<String, String> tokens, String tokenName) {
        String val = tokens.get(tokenName);
        if (val == null) {
            throw new IllegalArgumentException("Missing Azure connection parameter: " + tokenName);
        }
        return val;
    }

    public static BAzureIotSasToken generateSasToken(BAzureSasTokenParameters parameters, String storeKey) throws Exception {
        String resourceUri = String.format("%s/devices/%s", parameters.getAzureHost(), parameters.getAzureDeviceId());
        AzureIotSasTokenUtils.fine("Generating SAS token for uri: " + resourceUri);
        AzureIotSasTokenUtils.loadFromKeyRing(storeKey, parameters);
        String sharedAccessKey = parameters.getStoreValue();
        BAzureIotSasToken token = AzureIotSasTokenUtils.generateNewSasToken(sharedAccessKey, parameters.getNextTokenExpiryPeriod(), resourceUri);
        token.store(storeKey);
        AzureIotSasTokenUtils.fine("Generated new token, will expire at: " + token.getNextExpiryTime());
        return token;
    }

    private static BAzureIotSasToken generateNewSasToken(String azureDeviceKey, BRelTime expiryPeriod, String resourceUri) throws Exception {
        long expirySeconds = Instant.now(CLOCK).getEpochSecond() + (long)expiryPeriod.getSeconds();
        String stringToSign = URLEncoder.encode(resourceUri, StandardCharsets.UTF_8.name()) + '\n' + expirySeconds;
        byte[] decodedKey = Base64.getDecoder().decode(azureDeviceKey);
        Mac sha256HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(decodedKey, "HmacSHA256");
        sha256HMAC.init(secretKey);
        Base64.Encoder encoder = Base64.getEncoder();
        String signature = new String(encoder.encode(sha256HMAC.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
        String token = String.format("SharedAccessSignature sr=%s&sig=%s&se=%s", URLEncoder.encode(resourceUri, StandardCharsets.UTF_8.name()), URLEncoder.encode(signature, StandardCharsets.UTF_8.name()), expirySeconds);
        return BAzureIotSasToken.make(token, BAbsTime.now(), BAbsTime.make((long)(expirySeconds * 1000L)));
    }

    public static void saveToKeyRing(String storeKey, Storable storable) throws AzureSasException {
        String alias = AzureIotSasTokenUtils.getKeyRingAlias(storable.getStoreEntryType(), storeKey);
        KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
        String storeValue = storable.getStoreValue();
        if (storeValue == null) {
            throw new AzureSasException(LEX.getText("missing.keyring.value"));
        }
        try {
            keyRing.setKey(alias, storable.getStoreValue().getBytes(StandardCharsets.UTF_8), true);
        }
        catch (Exception e) {
            throw new AzureSasException(LEX.getText("failed.keyring.entry", new Object[]{storable.getStoreEntryType()}));
        }
    }

    public static void loadFromKeyRing(String storeKey, Storable storable) throws Exception {
        String alias = AzureIotSasTokenUtils.getKeyRingAlias(storable.getStoreEntryType(), storeKey);
        KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
        byte[] value = keyRing.getKey(alias);
        if (value == null) {
            throw new AzureSasException(LEX.getText("missing.keyring.entry", new Object[]{storable.getStoreEntryType()}));
        }
        storable.load(new String(value, StandardCharsets.UTF_8));
    }

    public static void removeFromKeyRing(String storeKey, String ... entryTypes) throws Exception {
        KeyRing keyRing = SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing();
        for (String entryType : entryTypes) {
            keyRing.removeKey(AzureIotSasTokenUtils.getKeyRingAlias(entryType, storeKey));
        }
    }

    private static String getKeyRingAlias(String entryType, String storeKey) throws AzureSasException {
        if (entryType == null || entryType.isEmpty()) {
            throw new AzureSasException(LEX.getText("missing.keyring.entryType"));
        }
        if (storeKey == null || storeKey.isEmpty()) {
            throw new AzureSasException(LEX.getText("missing.keyring.storeKey"));
        }
        return entryType + '_' + storeKey;
    }

    private static void fine(String message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(message);
        }
    }
}

