/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.template.file.EmbeddedPxSource;
import com.tridium.util.CompUtil;
import java.io.InputStream;
import java.util.List;
import javax.baja.agent.BPxView;
import javax.baja.file.types.text.BPxFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.sys.BComponent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class EmbeddedPxScanner {
    public static void findPxAndImageOrds(EmbeddedPxSource fileSource, BComponent root, List<String> pxList, List<String> imageList) {
        BPxView[] pxViews;
        for (BPxView view : pxViews = (BPxView[])CompUtil.getDescendants((BComponent)root, BPxView.class)) {
            String pxOrd = view.getPxFile().encodeToString();
            if (pxOrd == null || pxList.contains(pxOrd)) continue;
            pxList.add(pxOrd);
            BOrd ord = view.getPxFile();
            try {
                XElem rootElement;
                BPxFile file = fileSource.getPxFile(ord);
                try (InputStream in = file.getInputStream();){
                    rootElement = XParser.make((InputStream)in).parse();
                }
                EmbeddedPxScanner.findPxIncludeOrds(fileSource, rootElement, pxList, imageList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void findPxIncludeOrds(EmbeddedPxSource fileSource, XElem element, List<String> pxList, List<String> imageList) {
        XElem[] children;
        for (XElem child : children = element.elems()) {
            block29: {
                String name = child.name();
                if ("PxInclude".equals(name)) {
                    try {
                        XElem rootElement;
                        String ord = child.get("ord");
                        if (ord == null || pxList.contains(ord) || !ord.startsWith("file:")) break block29;
                        pxList.add(ord);
                        BPxFile nextFile = fileSource.getPxFile(BOrd.make((String)ord));
                        try (InputStream in = nextFile.getInputStream();){
                            rootElement = XParser.make((InputStream)in).parse();
                        }
                        EmbeddedPxScanner.findPxIncludeOrds(fileSource, rootElement, pxList, imageList);
                    }
                    catch (Exception ord) {}
                } else if ("Image".equals(name)) {
                    try {
                        String ord = child.get("value");
                        if (ord != null && !imageList.contains(ord) && ord.startsWith("file:")) {
                            imageList.add(ord);
                        }
                    }
                    catch (Exception ord) {}
                } else if ("INumericToSimple".equals(name) || "IEnumToSimple".equals(name)) {
                    if (child.attrIndex("map") != -1) {
                        String[] entries;
                        String map = child.get("map");
                        map = map.substring(map.indexOf(32) + 1);
                        for (String entry : entries = map.split(";")) {
                            int index = entry.indexOf(61);
                            String possibleOrd = entry.substring(index + 1);
                            if (!possibleOrd.startsWith("file:")) continue;
                            try {
                                BOrd.make((String)possibleOrd).parse();
                            }
                            catch (NullOrdException | SyntaxException e) {
                                continue;
                            }
                            if (imageList.contains(possibleOrd) || !possibleOrd.startsWith("file:")) continue;
                            imageList.add(possibleOrd);
                        }
                    }
                } else {
                    String ord;
                    int index = child.attrIndex("image");
                    if (index != -1 && (ord = child.get("image")) != null && !imageList.contains(ord) && ord.startsWith("file:")) {
                        imageList.add(ord);
                    }
                }
            }
            EmbeddedPxScanner.findPxIncludeOrds(fileSource, child, pxList, imageList);
        }
    }

    private EmbeddedPxScanner() {
    }
}

