/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class NameTree {
    static String MACRO_PREFIX = "$";
    private final Map<String, NameTree> children = new HashMap<String, NameTree>();

    public NameTree() {
    }

    public NameTree(NameTree other) {
        this();
        for (Map.Entry<String, NameTree> entry : other.children.entrySet()) {
            this.children.put(entry.getKey(), entry.getValue() == null ? null : new NameTree(entry.getValue()));
        }
    }

    public boolean isEmpty() {
        for (NameTree child : this.children.values()) {
            if (child != null && child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void add(String leafName) {
        this.children.putIfAbsent(leafName, null);
    }

    public NameTree get(String branchName) {
        NameTree result = this.children.getOrDefault(branchName, null);
        if (result == null) {
            result = new NameTree();
            this.children.put(branchName, result);
        }
        return result;
    }

    public boolean has(String name) {
        return this.children.containsKey(name);
    }

    public boolean hasBranch(String branchName) {
        return this.children.getOrDefault(branchName, null) != null;
    }

    public boolean hasLeaf(String leafName) {
        return this.children.containsKey(leafName) && this.children.get(leafName) == null;
    }

    public NameTree fetch(String branchName) {
        return this.children.getOrDefault(branchName, null);
    }

    public Set<String> getNames() {
        return this.children.keySet();
    }

    public Set<String> getAllNames() {
        TreeSet<String> result = new TreeSet<String>();
        this.gatherAllNames(result);
        return result;
    }

    public void replaceMacro(String macroName, String newName) {
        String macroKey = MACRO_PREFIX + macroName;
        if (this.hasLeaf(macroKey)) {
            if (!this.has(newName)) {
                this.add(newName);
            }
            this.children.remove(macroKey);
        }
        for (NameTree childTree : this.children.values()) {
            if (childTree == null) continue;
            childTree.replaceMacro(macroName, newName);
        }
    }

    public void removeMacro(String macroName) {
        String macroKey = MACRO_PREFIX + macroName;
        this.children.remove(macroKey);
        for (NameTree childTree : this.children.values()) {
            if (childTree == null) continue;
            childTree.removeMacro(macroName);
        }
    }

    private void gatherAllNames(Set<String> result) {
        result.addAll(this.children.keySet());
        for (NameTree childTree : this.children.values()) {
            if (childTree == null) continue;
            childTree.gatherAllNames(result);
        }
    }
}

