/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.BTemplateConfig;
import com.tridium.template.api.TemplateType;
import com.tridium.template.api.impl.DeployedTemplateSource;
import java.util.Objects;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;

public class InstalledApplicationTemplateSource
extends DeployedTemplateSource {
    public static InstalledApplicationTemplateSource make(BStation station) {
        Objects.requireNonNull(station);
        BTemplateConfig config = BTemplateConfig.getConfigForApplication(station);
        if (config != null) {
            return new InstalledApplicationTemplateSource(station, config);
        }
        return null;
    }

    public InstalledApplicationTemplateSource(BStation station) {
        super((BComponent)station, BTemplateConfig.getConfigForApplication(station));
    }

    private InstalledApplicationTemplateSource(BStation station, BTemplateConfig config) {
        super((BComponent)station, config);
    }

    @Override
    public TemplateType getTemplateType() {
        return TemplateType.APPLICATION;
    }

    @Override
    protected String getFileExtension() {
        return "napl";
    }
}

