/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template;

import com.tridium.template.BTemplateConfig;
import com.tridium.template.BTemplateSignature;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.file.BINtplFile;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="configuration", type="BTemplateConfig", defaultValue="new BTemplateConfig()"), @NiagaraProperty(name="templateSignature", type="BTemplateSignature", defaultValue="BTemplateSignature.DEFAULT", flags=5)})
public class BApplicationService
extends BAbstractService {
    @Generated
    public static final Property configuration = BApplicationService.newProperty((int)0, (BValue)new BTemplateConfig(), null);
    @Generated
    public static final Property templateSignature = BApplicationService.newProperty((int)5, (BValue)BTemplateSignature.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BApplicationService.class);
    private static final Type[] TYPES = new Type[]{TYPE};
    private static final Logger LOGGER = Logger.getLogger("template");

    @Generated
    public BTemplateConfig getConfiguration() {
        return (BTemplateConfig)this.get(configuration);
    }

    @Generated
    public void setConfiguration(BTemplateConfig v) {
        this.set(configuration, (BValue)v, null);
    }

    @Generated
    public BTemplateSignature getTemplateSignature() {
        return (BTemplateSignature)this.get(templateSignature);
    }

    @Generated
    public void setTemplateSignature(BTemplateSignature v) {
        this.set(templateSignature, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return TYPES;
    }

    public void started() {
        this.updateSignature();
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static String getApplicationId(Context cx) {
        BTemplateConfig config = BApplicationService.getApplicationConfig();
        if (config != null) {
            try {
                return config.getUID().encodeToString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static String getApplicationVersion(Context cx) {
        BTemplateConfig config = BApplicationService.getApplicationConfig();
        if (config != null) {
            return config.getManifest().version;
        }
        return "";
    }

    private static BTemplateConfig getApplicationConfig() {
        BApplicationService applicationService;
        BApplicationService[] serviceArray;
        BServiceContainer services;
        BStation station = Sys.getStation();
        if (station != null && (services = station.getServices()) != null && (serviceArray = (BApplicationService[])services.getChildren(BApplicationService.class)) != null && serviceArray.length > 0 && (applicationService = serviceArray[0]) != null) {
            return applicationService.getConfiguration();
        }
        return null;
    }

    private void updateSignature() {
        if (!this.getTemplateSignature().equals((Object)BTemplateSignature.DEFAULT)) {
            return;
        }
        BTemplateConfig config = this.getConfiguration();
        try (BINtplFile file = UpgradeUtil.getDeployedNtplFile(config, "^applicationTemplate/", "napl");){
            String signatureString = file.getTemplateManifest().bogSignature;
            this.setTemplateSignature((BTemplateSignature)BTemplateSignature.DEFAULT.decodeFromString(signatureString));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not update template signature.", e);
        }
    }
}

