/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.oracle.BOracleDatabase;
import com.tridium.rdb.oracle.OracleQuery;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.BRdbmsScheme;
import javax.baja.rdb.BRdbmsSession;
import javax.baja.rdb.RdbmsQuery;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType(ordScheme="oracle")
@NiagaraSingleton
public class BOracleScheme
extends BRdbmsScheme {
    @Generated
    public static final BOracleScheme INSTANCE = new BOracleScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BOracleScheme.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BOracleScheme() {
        super("oracle");
    }

    public void pickle(BISession session, XElem pickle) {
        BOracleDatabase db = (BOracleDatabase)((BRdbmsSession)session).getDatabase();
        pickle.addAttr("host", db.getHostname());
        pickle.addAttr("port", Integer.toString(db.getPort()));
        pickle.addAttr("sid", db.getServiceName());
    }

    public BISession unpickle(XElem pickle) {
        return BRdbmsSession.make((BHost)BHost.getHost((String)pickle.get("host")), (RdbmsQuery)new OracleQuery(pickle.geti("port", 0), pickle.get("sid")), (BRdbmsScheme)this);
    }

    public BRdbms newDatabase(BHost host, RdbmsQuery query) {
        OracleQuery oq = (OracleQuery)query;
        return new BOracleDatabase(BOrd.make((String)("ip:" + host.toString())), oq.port, oq.sid);
    }

    public String getAuthName() {
        return "Oracle";
    }

    public OrdQuery parse(String queryBody) {
        return new OracleQuery(queryBody);
    }
}

