/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.oracle;

import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.jdbc.trans.BSqlType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"rdbOracle:OracleDatabase"})})
public class BOracleDeprecatedDialect
extends BRdbmsDeprecatedDialect {
    @Generated
    public static final Type TYPE = Sys.loadType(BOracleDeprecatedDialect.class);
    private static final String ORACLE_INTERNAL_SCHEMA_QUERY = "select owner from dba_logstdby_skip where statement_opt = 'INTERNAL SCHEMA'";
    private static final String SELECT_DESC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT * FROM (SELECT %s, ID FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC) WHERE ROWNUM <= %s), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_ID = "WITH recs AS (SELECT * FROM (SELECT %s FROM %s WHERE %s >= ? AND %s <= ? ORDER BY %s DESC) WHERE ROWNUM <= %s), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String SELECT_DESC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT * FROM (SELECT %s, ID FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC) WHERE ROWNUM <= %s), rStats AS (SELECT MIN(recs.ID) AS LST_ID_R0B, COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, LST_ID_R0B, RST_SZ_R0B from recs, rStats";
    private static final String SELECT_ASC_QUERY_BY_HISTORY_TYPE = "WITH recs AS (SELECT * FROM (SELECT %s FROM %s WHERE %s = ? AND %s >= ? AND %s <= ? ORDER BY %s DESC) WHERE ROWNUM <= %s), rStats AS (SELECT COUNT(*) AS RST_SZ_R0B FROM recs) SELECT %s, RST_SZ_R0B from recs, rStats ORDER BY %s ASC";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_ID = "SELECT * FROM (SELECT %s FROM %s WHERE %s %s ? ORDER BY %s %s) WHERE ROWNUM <= 1";
    private static final String BOUNDARY_REC_QUERY_BY_HISTORY_TYPE = "SELECT * FROM (SELECT %s FROM %s WHERE %s = ? AND %s %s ? ORDER BY %s %s) WHERE ROWNUM <= 1";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean tableExists(BRdbms db, Connection conn, String tableName) throws SQLException {
        try (ResultSet rs = conn.getMetaData().getTables(null, db.getUserName().toUpperCase(), tableName, new String[]{"TABLE"});){
            boolean bl = rs.next();
            return bl;
        }
    }

    protected float getMaxFloat() {
        return Float.POSITIVE_INFINITY;
    }

    protected float getMinFloat() {
        return Float.NEGATIVE_INFINITY;
    }

    protected double getMaxDouble() {
        return Double.POSITIVE_INFINITY;
    }

    protected double getMinDouble() {
        return Double.NEGATIVE_INFINITY;
    }

    public String makeAddColumnSql(String tableName, String columnName, BSqlType columnType, int columnSize, String defaultValue) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(tableName).append(" ");
        sql.append("ADD ").append(columnName).append(" ").append(this.getDataType(columnType));
        if (columnSize > -1) {
            sql.append("(" + columnSize + ") ");
        } else {
            sql.append(" ");
        }
        sql.append("DEFAULT ");
        if (columnType.equals((Object)BSqlType.sqlVarchar) || columnType.equals((Object)BSqlType.sqlNVarchar)) {
            defaultValue = "'" + defaultValue + "'";
        }
        sql.append(defaultValue).append(" NOT NULL");
        return sql.toString();
    }

    public String makeAlterColumnTypeSql(String tableName, String columnName, BSqlType targetType, int columnSize) {
        String sql = "ALTER TABLE " + tableName + " MODIFY (" + columnName + " " + this.getDataType(targetType) + "(" + columnSize + "))";
        return sql;
    }

    public String makeCreateIndexSql(String indexName, String tableName, String columnNames, boolean online) {
        String idx = "CREATE INDEX " + indexName + " ON " + tableName + " (" + columnNames + ')';
        if (online) {
            idx = idx + " ONLINE";
        }
        return idx;
    }

    public boolean supportsOnlineIndexCreation() {
        return true;
    }

    public String makeDropIndexSql(String indexName, String tableName) {
        return "DROP INDEX " + indexName;
    }

    public String getSqlType(Type type, BFacets facets) {
        int width = this.getVarcharSize(facets);
        if (type.equals(BString.TYPE)) {
            return this.getStringType(width);
        }
        if (type.equals(BInteger.TYPE)) {
            return "INT";
        }
        if (type.equals(BLong.TYPE)) {
            return "INT";
        }
        if (type.equals(BFloat.TYPE)) {
            return "REAL";
        }
        if (type.equals(BDouble.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(BAbsTime.TYPE)) {
            return "TIMESTAMP";
        }
        if (type.equals(BRelTime.TYPE)) {
            return "INT";
        }
        if (type.equals(BBoolean.TYPE)) {
            return "CHAR(1)";
        }
        if (type.equals(BStatus.TYPE)) {
            return "INT";
        }
        if (type.equals(BTrendFlags.TYPE)) {
            return "INT";
        }
        return this.getStringType(width);
    }

    private String getStringType(int width) {
        if (this.database != null && this.database.getUseUnicodeEncodingScheme()) {
            return "NVARCHAR2(" + width + ")";
        }
        return "VARCHAR2(" + width + ")";
    }

    public List<String> getCatalogs(DatabaseMetaData metaData) throws SQLException {
        Set<String> oracleInternalSchemas = BOracleDeprecatedDialect.getInternalSchemaNames(metaData);
        ArrayList<String> schemaList = new ArrayList<String>();
        schemaList.add("");
        try (ResultSet resultSet = metaData.getSchemas();){
            while (resultSet.next()) {
                String schema = resultSet.getString("TABLE_SCHEM");
                if (schema == null || schema.isEmpty() || oracleInternalSchemas.contains(schema)) continue;
                schemaList.add(schema);
            }
        }
        return schemaList;
    }

    public ResultSet getTables(DatabaseMetaData metaData, String schema, String[] typeFilter) throws SQLException {
        return metaData.getTables(null, schema, null, typeFilter);
    }

    private static Set<String> getInternalSchemaNames(DatabaseMetaData metaData) throws SQLException {
        HashSet<String> schemaSet = new HashSet<String>();
        try (PreparedStatement statement = metaData.getConnection().prepareStatement(ORACLE_INTERNAL_SCHEMA_QUERY);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                schemaSet.add(rs.getString(1));
            }
        }
        return schemaSet;
    }

    public long getTimestampAccuracy() {
        return 1L;
    }

    public String getPrimaryKeySql() {
        return "INT PRIMARY KEY";
    }

    public int getMaxTableName() {
        return 128;
    }

    public int getMaxIndexName() {
        return 128;
    }

    public int getMaxColumnName() {
        return 128;
    }

    public int getMaxSequenceName() {
        return 128;
    }

    public boolean hasSequences() {
        return true;
    }

    public boolean allowsUnicode() {
        return false;
    }

    public String makeTimeQuerySql(String columns, String tableName, boolean isDescendingQuery, int limit) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, timestampCol, timestampCol, limit, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, timestampCol, timestampCol, limit, columns, timestampCol);
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                if (isDescendingQuery) {
                    return String.format(SELECT_DESC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, limit, columns);
                }
                return String.format(SELECT_ASC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, timestampCol, timestampCol, limit, columns, timestampCol);
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }

    public String makeBoundaryRecordQuerySql(String columns, String tableName, boolean newestOrOldest) {
        String timestampCol = this.makeColumnName("TIMESTAMP");
        switch (this.database.getExportMode().getOrdinal()) {
            case 0: {
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_ID, columns, tableName, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
            case 1: {
                String historyIdCol = this.makeColumnName("HISTORY_ID");
                return String.format(BOUNDARY_REC_QUERY_BY_HISTORY_TYPE, columns, tableName, historyIdCol, timestampCol, newestOrOldest ? ">" : "<", timestampCol, newestOrOldest ? "ASC" : "DESC");
            }
        }
        throw new IllegalStateException("Unsupported RDB export mode");
    }
}

