/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.entityIo.json;

import com.tridium.json.JSONException;
import com.tridium.json.JSONWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.entityIo.json.JsonEntityConst;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tag.io.EntityEncoder;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public final class JsonEntityEncoder
implements EntityEncoder,
JsonEntityConst {
    public static final String SHOULD_ENCODE_TAGS_KEY = "jsonEntityEncoderShouldEncodeTags";
    private static final BFacets SHOULD_ENCODE_TAGS_FACET = BFacets.make((String)"jsonEntityEncoderShouldEncodeTags", (boolean)true);
    private static final BFacets SHOULD_NOT_ENCODE_TAGS_FACET = BFacets.make((String)"jsonEntityEncoderShouldEncodeTags", (boolean)false);
    public static final String SHOULD_ENCODE_RELATIONS_KEY = "jsonEntityEncoderShouldEncodeRelations";
    private static final BFacets SHOULD_ENCODE_RELATIONS_FACET = BFacets.make((String)"jsonEntityEncoderShouldEncodeRelations", (boolean)true);
    private static final BFacets SHOULD_NOT_ENCODE_RELATIONS_FACET = BFacets.make((String)"jsonEntityEncoderShouldEncodeRelations", (boolean)false);
    public static final Options ENCODE_TAGS_AND_RELATIONS = new Options(true, true);
    public static final Options NO_TAGS_OR_RELATIONS = new Options(false, false);
    private static final boolean ALLOW_EMPTY = true;
    private final OutputStream out;
    private final Options options;
    private JSONWriter jout;
    private Writer writer;
    private final Buffer buffer = new Buffer();
    private volatile boolean root = true;

    public JsonEntityEncoder(File f) throws IOException {
        this(f, ENCODE_TAGS_AND_RELATIONS);
    }

    public JsonEntityEncoder(File f, Options options) throws IOException {
        Objects.requireNonNull(f);
        this.out = new BufferedOutputStream(new FileOutputStream(f));
        this.options = options != null ? options : ENCODE_TAGS_AND_RELATIONS;
        this.init();
    }

    public JsonEntityEncoder(OutputStream out) throws IOException {
        this(out, ENCODE_TAGS_AND_RELATIONS);
    }

    public JsonEntityEncoder(OutputStream out, Options options) throws IOException {
        Objects.requireNonNull(out);
        this.out = out;
        this.options = options != null ? options : ENCODE_TAGS_AND_RELATIONS;
        this.init();
    }

    public static String encodeToString(Entity e) throws IOException {
        return JsonEntityEncoder.encodeToString(e, ENCODE_TAGS_AND_RELATIONS);
    }

    public static String encodeToString(Entity e, Options options) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonEntityEncoder encoder = new JsonEntityEncoder(os, options);){
            encoder.encode(e);
        }
        return os.toString();
    }

    public static String encodeToString(Collection<Entity> c) throws IOException {
        return JsonEntityEncoder.encodeToString(c, ENCODE_TAGS_AND_RELATIONS);
    }

    public static String encodeToString(Collection<Entity> c, Options options) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonEntityEncoder encoder = new JsonEntityEncoder(os, options);){
            int count = 0;
            for (Entity e : c) {
                encoder.encode(e, "e" + count);
                ++count;
            }
        }
        return os.toString();
    }

    public void close() throws IOException {
        try {
            if (!this.root) {
                this.jout.endObject();
            }
            this.flush();
            this.out.close();
            this.buffer.reset();
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public void encode(Entity entity, String name) throws IOException {
        try {
            if (this.root) {
                if (name == null) {
                    this.jout.object();
                    this.encodeEntity(entity);
                    this.jout.endObject();
                } else {
                    this.jout.object();
                    this.root = false;
                    this.jout.key(name).object();
                    this.encodeEntity(entity);
                    this.jout.endObject();
                }
            } else {
                if (name == null) {
                    throw new IllegalArgumentException("Non-Root JSON object must be named");
                }
                this.jout.key(name).object();
                this.encodeEntity(entity);
                this.jout.endObject();
            }
        }
        catch (JSONException e) {
            this.flush();
            System.out.println("JSONException encoding, output so far is " + this.out);
            throw new IOException(e);
        }
    }

    private void init() {
        this.writer = new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8);
        this.jout = new JSONWriter((Appendable)this.writer);
        this.root = true;
    }

    private void flush() throws IOException {
        try {
            this.writer.flush();
            int size = this.buffer.size();
            if (size > 0) {
                this.out.write(this.buffer.getBytes(), 0, size);
                this.out.flush();
            }
            this.buffer.reset();
        }
        catch (Exception x) {
            throw new IOException(x);
        }
    }

    public void encodeEntity(Entity e) throws JSONException, IOException {
        if (e == null) {
            this.jout.value(null);
        } else {
            Optional maybeOrd;
            if (this.options.shouldEncodeTags()) {
                JsonEntityEncoder.encodeTags(this.jout, e.tags(), false, "tags");
            }
            if (this.options.shouldEncodeRelations()) {
                JsonEntityEncoder.encodeRelations(this.jout, e.relations(), false, "relations");
            }
            if ((maybeOrd = e.getOrdToEntity()).isPresent()) {
                this.jout.key("ord").value(maybeOrd.get());
            }
        }
    }

    public void encodeTags(Tags tags) throws JSONException, IOException {
        JsonEntityEncoder.encodeTags(this.jout, tags, true, "tags");
    }

    public static void encodeTags(JSONWriter jout, Tags tags) throws JSONException, IOException {
        JsonEntityEncoder.encodeTags(jout, tags, true, null);
    }

    private static void encodeTags(JSONWriter jout, Tags tags, boolean allowEmpty, String key) throws JSONException, IOException {
        Objects.requireNonNull(tags);
        ArrayList<Id> multisWritten = new ArrayList<Id>();
        boolean objectStarted = false;
        if (allowEmpty) {
            JsonEntityEncoder.startObject(jout, key);
            objectStarted = true;
        }
        for (Tag tag : tags) {
            Id id;
            if (!objectStarted) {
                JsonEntityEncoder.startObject(jout, key);
                objectStarted = true;
            }
            if (multisWritten.contains(id = tag.getId())) continue;
            if (tags.isMulti(id)) {
                multisWritten.add(id);
                Collection vals = tags.getValues(id);
                Iterator it = vals.iterator();
                BIDataValue value = (BIDataValue)it.next();
                JsonEntityEncoder.key(jout, id.toString(), value);
                jout.array();
                JsonEntityEncoder.encodeValue(jout, value);
                while (it.hasNext()) {
                    value = (BIDataValue)it.next();
                    JsonEntityEncoder.encodeValue(jout, value);
                }
                jout.endArray();
                continue;
            }
            JsonEntityEncoder.encodeSingleTag(jout, tag);
        }
        if (objectStarted) {
            jout.endObject();
        }
    }

    private static void startObject(JSONWriter jout, String key) {
        if (key != null) {
            jout.key(key);
        }
        jout.object();
    }

    public void encodeSingleTag(Tag tag) throws JSONException, IOException {
        JsonEntityEncoder.encodeSingleTag(this.jout, tag);
    }

    public static void encodeSingleTag(JSONWriter jout, Tag tag) throws JSONException, IOException {
        block2: {
            BIDataValue value = tag.getValue();
            try {
                JsonEntityEncoder.key(jout, tag.getId().toString(), value);
                JsonEntityEncoder.encodeValue(jout, value);
            }
            catch (JSONException e) {
                String msg = e.getMessage();
                if (msg != null && msg.startsWith("Duplicate key")) break block2;
                throw e;
            }
        }
    }

    public void encodeRelations(Relations relations) throws JSONException, IOException {
        JsonEntityEncoder.encodeRelations(this.jout, relations, true, "relations");
    }

    public static void encodeRelations(JSONWriter jout, Relations relations) throws JSONException, IOException {
        JsonEntityEncoder.encodeRelations(jout, relations, true, null);
    }

    private static void encodeRelations(JSONWriter jout, Relations relations, boolean allowEmpty, String key) throws JSONException, IOException {
        Objects.requireNonNull(relations);
        boolean arrayStarted = false;
        if (allowEmpty) {
            JsonEntityEncoder.startArray(jout, key);
            arrayStarted = true;
        }
        for (Relation rel : relations) {
            if (!arrayStarted) {
                JsonEntityEncoder.startArray(jout, key);
                arrayStarted = true;
            }
            JsonEntityEncoder.encodeRelation(jout, rel);
        }
        if (arrayStarted) {
            jout.endArray();
        }
    }

    private static void startArray(JSONWriter jout, String key) {
        if (key != null) {
            jout.key(key);
        }
        jout.array();
    }

    public void encodeRelation(Relation rel) throws JSONException, IOException {
        JsonEntityEncoder.encodeRelation(this.jout, rel);
    }

    public static void encodeRelation(JSONWriter jout, Relation rel) throws JSONException, IOException {
        jout.object();
        jout.key("rId").value((Object)rel.getId().toString());
        jout.key("inbound").value(rel.isInbound());
        Entity target = rel.getEndpoint();
        if (target != null) {
            Optional optOrd = target.getOrdToEntity();
            if (optOrd.isPresent()) {
                jout.key("entityOrd").value(optOrd.get());
            }
        } else if (rel.getEndpointOrd() != null) {
            jout.key("entityOrd").value((Object)rel.getEndpointOrd());
        }
        if (!rel.tags().isEmpty()) {
            jout.key("tags");
            JsonEntityEncoder.encodeTags(jout, rel.tags());
        }
        jout.endObject();
    }

    private static void key(JSONWriter jout, String id, BIDataValue value) throws JSONException {
        Objects.requireNonNull(value);
        Type type = value.getType();
        if (type.is(BMarker.TYPE)) {
            jout.key(id + 'M');
        } else if (type.is(BString.TYPE)) {
            jout.key(id + 'S');
        } else if (type.is(BDouble.TYPE)) {
            jout.key(Double.isFinite(((BDouble)value.as(BDouble.class)).getDouble()) ? id + 'D' : id + 'N');
        } else if (type.is(BInteger.TYPE)) {
            jout.key(id + 'I');
        } else if (type.is(BBoolean.TYPE)) {
            jout.key(id + 'B');
        } else if (type.is(BFloat.TYPE)) {
            jout.key(Float.isFinite(((BFloat)value.as(BFloat.class)).getFloat()) ? id + 'F' : id + 'N');
        } else if (type.is(BLong.TYPE)) {
            jout.key(id + 'L');
        } else if (type.is(BAbsTime.TYPE)) {
            jout.key(id + 'A');
        } else if (type.is(BOrd.TYPE)) {
            jout.key(id + 'O');
        } else if (type.is(BDynamicEnum.TYPE)) {
            jout.key(id + 'Y');
        } else if (type.is(BEnumRange.TYPE)) {
            jout.key(id + 'G');
        } else if (type.is(BRelTime.TYPE)) {
            jout.key(id + 'R');
        } else if (type.is(BTimeZone.TYPE)) {
            jout.key(id + 'Z');
        } else if (type.is(BUnit.TYPE)) {
            jout.key(id + 'U');
        } else {
            jout.key(id + 'J');
        }
    }

    private static void encodeValue(JSONWriter jout, BIDataValue v) throws JSONException, IOException {
        Objects.requireNonNull(v);
        Type type = v.getType();
        if (type.is(BMarker.TYPE)) {
            jout.value(null);
        } else if (type.is(BString.TYPE)) {
            jout.value((Object)v.as(BString.class));
        } else if (type.is(BDouble.TYPE)) {
            double d = ((BDouble)v.as(BDouble.class)).getDouble();
            if (Double.isNaN(d)) {
                jout.value((Object)"dNaN");
            } else if (Double.isFinite(d)) {
                jout.value(d);
            } else {
                jout.value((Object)(Math.signum(d) > 0.0 ? "dpInf" : "dnInf"));
            }
        } else if (type.is(BInteger.TYPE)) {
            jout.value((long)((BInteger)v.as(BInteger.class)).getInt());
        } else if (type.is(BBoolean.TYPE)) {
            jout.value(((BBoolean)v.as(BBoolean.class)).getBoolean());
        } else if (type.is(BFloat.TYPE)) {
            float f = ((BFloat)v.as(BFloat.class)).getFloat();
            if (Float.isNaN(f)) {
                jout.value((Object)"fNaN");
            } else if (Float.isFinite(f)) {
                jout.value((double)f);
            } else {
                jout.value((Object)(Math.signum(f) > 0.0f ? "fpInf" : "fnInf"));
            }
        } else if (type.is(BLong.TYPE)) {
            jout.value(((BLong)v.as(BLong.class)).getLong());
        } else if (type.is(BDynamicEnum.TYPE)) {
            jout.value((Object)((BDynamicEnum)v.as(BDynamicEnum.class)).encodeToString());
        } else if (type.is(BTimeZone.TYPE)) {
            jout.value((Object)((BTimeZone)v.as(BTimeZone.class)).encodeToString());
        } else if (type.is(BUnit.TYPE)) {
            jout.value((Object)((BUnit)v.as(BUnit.class)).encodeToString());
        } else if (type.is(BEnumRange.TYPE)) {
            jout.value((Object)v);
        } else if (type.is(BAbsTime.TYPE)) {
            jout.value((Object)((BAbsTime)v.as(BAbsTime.class)).encodeToString());
        } else if (type.is(BRelTime.TYPE)) {
            jout.value((Object)((BRelTime)v.as(BRelTime.class)).encodeToString());
        } else if (type.is(BOrd.TYPE)) {
            jout.value((Object)v);
        } else {
            jout.value((Object)v);
        }
    }

    public static Context makeShouldEncodeTagsContext(Context cx) {
        return cx == null ? SHOULD_ENCODE_TAGS_FACET : new BasicContext(cx, SHOULD_ENCODE_TAGS_FACET);
    }

    public static Context makeShouldNotEncodeTagsContext(Context cx) {
        return cx == null ? SHOULD_NOT_ENCODE_TAGS_FACET : new BasicContext(cx, SHOULD_NOT_ENCODE_TAGS_FACET);
    }

    public static boolean shouldEncodeTags(Context cx) {
        return cx == null || BBoolean.FALSE != cx.getFacet(SHOULD_ENCODE_TAGS_KEY);
    }

    public static Context makeShouldEncodeRelationsContext(Context cx) {
        return cx == null ? SHOULD_ENCODE_RELATIONS_FACET : new BasicContext(cx, SHOULD_ENCODE_RELATIONS_FACET);
    }

    public static Context makeShouldNotEncodeRelationsContext(Context cx) {
        return cx == null ? SHOULD_NOT_ENCODE_RELATIONS_FACET : new BasicContext(cx, SHOULD_NOT_ENCODE_RELATIONS_FACET);
    }

    public static boolean shouldEncodeRelations(Context cx) {
        return cx == null || BBoolean.FALSE != cx.getFacet(SHOULD_ENCODE_RELATIONS_KEY);
    }

    public static class Options {
        private final boolean shouldEncodeTags;
        private final boolean shouldEncodeRelations;

        public Options(boolean shouldEncodeTags, boolean shouldEncodeRelations) {
            this.shouldEncodeTags = shouldEncodeTags;
            this.shouldEncodeRelations = shouldEncodeRelations;
        }

        public boolean shouldEncodeTags() {
            return this.shouldEncodeTags;
        }

        public boolean shouldEncodeRelations() {
            return this.shouldEncodeRelations;
        }
    }

    static class Buffer
    extends ByteArrayOutputStream {
        Buffer() {
        }

        byte[] getBytes() {
            return this.buf;
        }
    }
}

