/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.entityIo.json;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.entityIo.json.JsonEntityConst;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tags;
import javax.baja.tag.io.EntityDecoder;
import javax.baja.tag.util.BasicEntity;
import javax.baja.tag.util.RelationSet;
import javax.baja.tag.util.TagSet;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public final class JsonEntityDecoder
implements EntityDecoder,
JsonEntityConst {
    private final JSONTokener tokener;
    private final Reader reader;

    public JsonEntityDecoder(Reader reader) throws JSONException {
        Objects.requireNonNull(reader);
        this.reader = reader;
        this.tokener = new JSONTokener(reader);
    }

    public JsonEntityDecoder(InputStream in) throws JSONException {
        this(new InputStreamReader(in));
    }

    public static Entity decodeFromString(String encodedString) throws IOException {
        try {
            StringReader rdr = new StringReader(encodedString);
            JsonEntityDecoder dec = new JsonEntityDecoder(rdr);
            return dec.decode();
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public static void mergeFromString(String encodedString, Entity entity) throws IOException {
        try {
            StringReader rdr = new StringReader(encodedString);
            JsonEntityDecoder dec = new JsonEntityDecoder(rdr);
            dec.merge(entity);
        }
        catch (JSONException x) {
            throw new IOException(x);
        }
    }

    public static Collection<Entity> decodeEntities(Reader r) throws IOException {
        try {
            ArrayList<Entity> list = new ArrayList<Entity>();
            JsonEntityDecoder dec = new JsonEntityDecoder(r);
            JSONObject root = new JSONObject(dec.tokener);
            Iterator it = root.keys();
            while (it.hasNext()) {
                list.add(dec.decodeEntity(root.getJSONObject(it.next().toString())));
            }
            return list;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Entity decode() throws IOException {
        try {
            JSONObject jsonObject = new JSONObject(this.tokener);
            return this.decodeEntity(jsonObject);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public Entity decodeEntity(JSONObject jsonObject) throws JSONException, IOException {
        JSONArray relationsArr;
        JSONObject tagsObj;
        String ordstr;
        BOrd ord = null;
        TagSet tags = new TagSet();
        RelationSet relations = new RelationSet();
        if (jsonObject.has("ord") && (ordstr = JSONUtil.getString((JSONObject)jsonObject, (String)"ord")) != null) {
            ord = BOrd.make((String)ordstr);
        }
        if ((tagsObj = jsonObject.optJSONObject("tags")) != null) {
            tags = this.decodeTags(tagsObj);
        }
        if ((relationsArr = jsonObject.optJSONArray("relations")) != null) {
            relations = this.decodeRelations(relationsArr);
        }
        return new BasicEntity(ord, (Tags)tags, (Relations)relations);
    }

    public Tags decodeTags(JSONObject jsonObject) throws JSONException, IOException {
        TagSet tags = new TagSet();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            char valueType = key.charAt(key.length() - 1);
            Object val = jsonObject.get(key);
            Id id = Id.newId((String)key.substring(0, key.length() - 1));
            if (val instanceof JSONArray) {
                if (tags.contains(id) && !tags.isMulti(id)) {
                    BIDataValue existing = (BIDataValue)tags.get(id).get();
                    tags.removeAll(id);
                    tags.addMulti(id, existing);
                }
                JSONArray array = (JSONArray)val;
                int len = array.length();
                for (int i = 0; i < len; ++i) {
                    tags.addMulti(id, JsonEntityDecoder.toDataValue(valueType, array.get(i)));
                }
                continue;
            }
            if (tags.contains(id) && tags.isMulti(id)) {
                if (jsonObject.isNull(key)) {
                    tags.addMulti(id, (BIDataValue)BMarker.MARKER);
                    continue;
                }
                tags.addMulti(id, JsonEntityDecoder.toDataValue(valueType, val));
                continue;
            }
            if (jsonObject.isNull(key)) {
                tags.set(id, (BIDataValue)BMarker.MARKER);
                continue;
            }
            tags.set(id, JsonEntityDecoder.toDataValue(valueType, val));
        }
        return tags;
    }

    public Relations decodeRelations(JSONArray jsonArray) throws JSONException, IOException {
        RelationSet relations = new RelationSet();
        int len = jsonArray.length();
        for (int i = 0; i < len; ++i) {
            relations.add(this.decodeRelation(jsonArray.getJSONObject(i)));
        }
        return relations;
    }

    public Relation decodeRelation(JSONObject jsonObject) throws JSONException, IOException {
        Id id = Id.newId((String)JSONUtil.getString((JSONObject)jsonObject, (String)"rId"));
        boolean inbound = jsonObject.optBoolean("inbound", true);
        BOrd entityOrd = BOrd.make((String)jsonObject.optString("entityOrd"));
        Object tags = jsonObject.has("tags") ? this.decodeTags(jsonObject.getJSONObject("tags")) : new TagSet();
        return new BasicRelation(id, entityOrd, (Tags)tags, inbound);
    }

    private static BIDataValue toDataValue(char type, Object o) throws IOException {
        switch (type) {
            case 'M': {
                return BMarker.MARKER;
            }
            case 'B': {
                return BBoolean.make((boolean)((Boolean)o));
            }
            case 'D': {
                return BDouble.make((double)((Number)o).doubleValue());
            }
            case 'I': {
                return BInteger.make((int)((Number)o).intValue());
            }
            case 'F': {
                return BFloat.make((float)((Number)o).floatValue());
            }
            case 'L': {
                return BLong.make((long)((Number)o).longValue());
            }
            case 'S': {
                return BString.make((String)o.toString());
            }
            case 'A': {
                return (BIDataValue)BAbsTime.DEFAULT.decodeFromString(o.toString());
            }
            case 'O': {
                return BOrd.make((String)o.toString());
            }
            case 'Y': {
                return (BIDataValue)BDynamicEnum.DEFAULT.decodeFromString(o.toString());
            }
            case 'G': {
                return (BIDataValue)BEnumRange.DEFAULT.decodeFromString(o.toString());
            }
            case 'R': {
                return (BIDataValue)BRelTime.DEFAULT.decodeFromString(o.toString());
            }
            case 'Z': {
                return (BIDataValue)BTimeZone.DEFAULT.decodeFromString(o.toString());
            }
            case 'U': {
                return (BIDataValue)BUnit.DEFAULT.decodeFromString(o.toString());
            }
            case 'N': {
                return JsonEntityDecoder.nonStandard(o.toString());
            }
            case 'J': {
                return BString.make((String)o.toString());
            }
        }
        throw new IllegalArgumentException("unknown value type: '" + type + '\'');
    }

    private static BIDataValue nonStandard(String s) {
        if ("fNaN".equals(s)) {
            return BFloat.NaN;
        }
        if ("fpInf".equals(s)) {
            return BFloat.POSITIVE_INFINITY;
        }
        if ("fnInf".equals(s)) {
            return BFloat.NEGATIVE_INFINITY;
        }
        if ("dNaN".equals(s)) {
            return BDouble.NaN;
        }
        if ("dpInf".equals(s)) {
            return BDouble.POSITIVE_INFINITY;
        }
        if ("dnInf".equals(s)) {
            return BDouble.NEGATIVE_INFINITY;
        }
        throw new IllegalArgumentException("unknown nonstandard value:" + s);
    }
}

