/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.entityIo;

import java.util.Optional;
import javax.baja.tag.Entity;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public final class EntityIOUtil {
    public static String str(Entity e) {
        return e.getOrdToEntity() + "; tags:" + e.tags().getAll().size() + "; relations:" + e.relations().getAll().size();
    }

    public static String str(Relation r) {
        return r.getId() + ":" + r.getEndpoint() + " tags:" + r.tags().getAll().size();
    }

    public static String str(Tag t) {
        return t.getId() + ":" + t.getValue();
    }

    public static void dumpEntity(Entity e) {
        EntityIOUtil.dumpEntity("", e, "");
    }

    public static void dumpEntity(String msg, Entity e) {
        EntityIOUtil.dumpEntity(msg, e, "");
    }

    public static void dumpEntity(String msg, Entity e, String indent) {
        Optional o2e;
        if (msg != null) {
            System.out.println(indent + msg);
        }
        if ((o2e = e.getOrdToEntity()) == null || !o2e.isPresent()) {
            System.out.println(indent + "no ord");
        } else {
            System.out.println(indent + "ord=" + o2e.get());
        }
        if (e.tags().isEmpty()) {
            System.out.println(indent + "no tags");
        } else {
            EntityIOUtil.dumpTags("tags", e.tags(), indent);
        }
        if (e.relations().isEmpty()) {
            System.out.println(indent + "no relations");
        } else {
            EntityIOUtil.dumpRelations("relations", e.relations(), indent);
        }
    }

    public static void dumpTags(String msg, Entity entity) {
        if (entity == null) {
            System.out.println(msg + ": null entity!!");
        } else {
            EntityIOUtil.dumpTags(msg, entity.tags());
        }
    }

    public static void dumpTags(String msg, Tags tags) {
        EntityIOUtil.dumpTags(msg, tags, "");
    }

    public static void dumpTags(String msg, Tags tags, String indent) {
        if (msg != null) {
            System.out.println(indent + msg);
        }
        if (tags == null) {
            System.out.println(" null tags!");
        }
        for (Tag t : tags) {
            System.out.println(indent + " id=" + t.getId() + "; val=" + t.getValue() + " [" + t.getValue().getType() + "]");
        }
    }

    public static void dumpRelations(String msg, Relations relations) {
        EntityIOUtil.dumpRelations(msg, relations, "");
    }

    public static void dumpRelations(String msg, Relations relations, String indent) {
        if (msg != null) {
            System.out.println(indent + msg);
        }
        for (Relation r : relations) {
            System.out.println(indent + " id=" + r.getId());
            System.out.println(indent + " endpointOrd=" + r.getEndpointOrd());
            System.out.println(indent + " inbound=" + r.isInbound());
            System.out.println(indent + " outbound=" + r.isOutbound());
            Entity e = r.getEndpoint();
            if (e != null) {
                EntityIOUtil.dumpEntity("relEntity", r.getEndpoint(), indent + " ");
            }
            EntityIOUtil.dumpTags("relTags", r.tags(), indent + " ");
            System.out.println();
        }
    }
}

