/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.point;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.BInfinityPointDeviceExt;
import com.tridium.andoverInfinity.comm.req.BInfinityPointDisableRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityPointEnableRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityReadPointRequest;
import com.tridium.andoverInfinity.identify.BInfinityPointId;
import com.tridium.andoverInfinity.identify.BInfinityReadPointParams;
import com.tridium.andoverInfinity.identify.BInfinityWritePointParams;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddf.point.BDdfProxyExt;
import java.util.logging.Level;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="readParameters", type="BDdfIdParams", defaultValue="new BInfinityReadPointParams()", facets={@Facet(value="MGR_INCLUDE")}, override=true), @NiagaraProperty(name="writeParameters", type="BDdfIdParams", defaultValue="new BInfinityWritePointParams()", facets={@Facet(value="MGR_INCLUDE")}, override=true), @NiagaraProperty(name="pointId", type="BDdfIdParams", defaultValue="new BInfinityPointId()", facets={@Facet(value="MGR_INCLUDE")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal")})
@NiagaraActions(value={@NiagaraAction(name="sendEnableCommand"), @NiagaraAction(name="sendDisableCommand")})
public class BInfinityProxyExt
extends BDdfProxyExt
implements BIPollable {
    @Generated
    public static final Property readParameters = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityReadPointParams(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property writeParameters = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityWritePointParams(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property pointId = BInfinityProxyExt.newProperty((int)0, (BValue)new BInfinityPointId(), (BFacets)MGR_INCLUDE);
    @Generated
    public static final Property pollFrequency = BInfinityProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Action sendEnableCommand = BInfinityProxyExt.newAction((int)0, null);
    @Generated
    public static final Action sendDisableCommand = BInfinityProxyExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityProxyExt.class);
    private boolean pointDisabledInPanel = false;
    BInfinityNetwork net;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public void sendEnableCommand() {
        this.invoke(sendEnableCommand, null, null);
    }

    @Generated
    public void sendDisableCommand() {
        this.invoke(sendDisableCommand, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceExtType() {
        return BInfinityPointDeviceExt.TYPE;
    }

    public BInfinityNetwork getInfinityNetwork() {
        if (this.net != null) {
            return this.net;
        }
        return (BInfinityNetwork)this.getNetwork();
    }

    public BIDdfReadRequest makePollRequest() {
        BInfinityReadPointRequest req = (BInfinityReadPointRequest)super.makePollRequest();
        req.setNetwork(this.getInfinityNetwork());
        return req;
    }

    public void doSendEnableCommand() {
        if (!this.isRunning()) {
            return;
        }
        BInfinityReadPointParams rdparms = (BInfinityReadPointParams)this.getReadParameters();
        String pointName = rdparms.getPointName();
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("do enable command on " + pointName);
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPointEnableRequest(this));
    }

    public void doSendDisableCommand() {
        if (!this.isRunning()) {
            return;
        }
        BInfinityReadPointParams rdparms = (BInfinityReadPointParams)this.getReadParameters();
        String pointName = rdparms.getPointName();
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("do disable command on " + pointName);
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPointDisableRequest(this));
    }
}

