/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.InfinityUtil;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.RequiresNetworkAccess;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BInfinityPollForControllerInfoRequest
extends BDdfRequest
implements Vt100Const,
RequiresNetworkAccess {
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityPollForControllerInfoRequest.class);
    BInfinityNetwork network;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityPollForControllerInfoRequest:processReceive(), mode=" + cursorModes[mode]);
        BInfinityDeviceId id = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
        switch (mode) {
            case 129: {
                for (int i = 5; i < 21; ++i) {
                    StringTokenizer tok;
                    String line = this.network.getScreen().getFullLine(i).substring(1, 40).trim();
                    if (line.length() == 0) continue;
                    if (line.startsWith("Name")) {
                        tok = new StringTokenizer(line);
                        tok.nextToken();
                        String name = tok.nextToken();
                        System.out.println(name + ":" + id.getControllerName());
                        if (name.equalsIgnoreCase(id.getControllerName())) continue;
                        throw new DdfResponseException("name incorrect:" + line);
                    }
                    if (line.startsWith("Description")) continue;
                    if (line.startsWith("Serial Number")) {
                        tok = new StringTokenizer(line);
                        tok.nextToken();
                        tok.nextToken();
                        String sn = tok.nextToken();
                        System.out.println(sn);
                        id.setSerialNumber(sn);
                        continue;
                    }
                    if (!line.startsWith("Model")) continue;
                    tok = new StringTokenizer(line);
                    tok.nextToken();
                    String model = tok.nextToken();
                    System.out.println(model);
                    id.setModel(model);
                    return new BInfinityAckWithData("\u001bOSve");
                }
                throw new DdfResponseException("error parsing controller info");
            }
            case 34: {
                for (int i = 5; i < 21; ++i) {
                    String name;
                    String line = this.network.getScreen().getFullLine(i).substring(1, 79).trim();
                    StringTokenizer tok = new StringTokenizer(line);
                    if (tok.countTokens() == 0 || tok.countTokens() != 4 || !(name = tok.nextToken()).equalsIgnoreCase(id.getControllerName())) continue;
                    tok.nextToken();
                    String idnum = tok.nextToken();
                    System.out.println("found " + name + ":" + idnum);
                    id.setId(idnum);
                    return new BInfinitySuccessResponse();
                }
                throw new DdfResponseException("error parsing controller info");
            }
        }
        this.network.getLogger().fine("error retrieving controller info, mode=" + cursorModes[mode]);
        throw new DdfResponseException("error retrieving controller info, mode=" + cursorModes[mode]);
    }

    public byte[] toByteArray() {
        int mode = this.network.getScreen().getMode();
        StringBuffer sb = new StringBuffer();
        this.network.getLogger().fine("BInfinityPollForControllerInfoRequest:toByteArray(), mode=" + cursorModes[mode]);
        switch (mode) {
            case 0: 
            case 1: {
                if (this.network.isConnected()) {
                    return "\u001a".getBytes();
                }
                return ("window" + this.network.getNetworkDevice().getUserName() + "\t").getBytes();
            }
            case 4: {
                if (this.network.getScreen().isInsertMode()) {
                    sb.append("\u001bi");
                    this.network.getScreen().resetInsertMode();
                }
                InfinityUtil.addMoveCursorCommands(this.network.getScreen(), sb);
                InfinityUtil.addChangeDeviceCommands(this.network.getScreen(), sb);
                break;
            }
            case 3: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 132: {
                return this.network.getScreen().getRecovery(mode).getBytes();
            }
            default: {
                String recovery = this.network.getScreen().getRecovery(mode);
                sb.append(recovery);
            }
        }
        BInfinityDeviceId id = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
        sb.append("\u001bOSEe" + id.getControllerName() + "\r");
        return sb.toString().getBytes();
    }

    @Override
    public void setNetwork(BInfinityNetwork network) {
        this.network = network;
    }
}

