/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm.req;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.rsp.BInfinityAckWithData;
import com.tridium.andoverInfinity.comm.rsp.BInfinitySuccessResponse;
import com.tridium.andoverInfinity.identify.BInfinityDeviceId;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.req.BDdfRequest;
import com.tridium.ddf.comm.req.BIDdfCustomRequest;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BInfinityLogonSequenceRequest
extends BDdfRequest
implements BIDdfCustomRequest,
Vt100Const {
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityLogonSequenceRequest.class);
    BInfinityNetwork network;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BInfinityLogonSequenceRequest() {
    }

    public BInfinityLogonSequenceRequest(BInfinityNetwork net) {
        this.network = net;
        this.setResponseTimeout(BRelTime.makeSeconds((int)10));
    }

    public BIDdfResponse processReceive(IDdfDataFrame iDevDataFrame) throws DdfResponseException {
        int mode = this.network.getScreen().getMode();
        this.network.getLogger().fine("BInfinityLogonSequenceRequest:processReceive(), mode=" + cursorModes[mode]);
        this.setResponseTimeout(BRelTime.makeSeconds((int)10));
        switch (mode) {
            case 10: {
                return new BInfinityAckWithData(this.network.getScreen().getRecovery(mode));
            }
            case 11: {
                return new BInfinityAckWithData(this.network.getScreen().getRecovery(mode));
            }
            case 4: {
                BInfinityDeviceId networkId = (BInfinityDeviceId)this.network.getNetworkDevice().getDeviceId();
                String name = this.network.getScreen().parseNetworkControllerNameFromLine1();
                if (name != null) {
                    networkId.setControllerName(name);
                }
                return new BInfinitySuccessResponse();
            }
        }
        throw new DdfResponseException("Invalid response");
    }

    public byte[] toByteArray() {
        this.network.getLogger().fine("BInfinityLogonSequenceRequest:toByteArray()");
        return "window".getBytes();
    }

    public void processErrorResponse(DdfResponseException errorRsp) {
    }

    public void processLateResponse(BIDdfResponse devRsp) {
    }

    public void processResponse(BIDdfResponse devRsp) {
        this.network.setConnected(true);
    }

    public void processTimeout() {
        this.network.setConnected(false);
    }
}

