/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity.comm;

import com.tridium.andoverInfinity.BInfinityNetwork;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.ddf.DdfFacets;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddfSerial.comm.BDdfSerialNullReceiver;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="responseTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(25)", facets={@Facet(value="DdfFacets.combine(DdfFacets.MGR_INCLUDE, BFacets.make(BFacets.SHOW_MILLISECONDS,BBoolean.FALSE), BFacets.make(BFacets.MIN,BRelTime.SECOND), BFacets.make(BFacets.MAX,BRelTime.MINUTE))")}, override=true), @NiagaraProperty(name="elapsedTimeForEndOfMessage", type="BRelTime", defaultValue="BRelTime.makeSeconds(3)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.FALSE, BFacets.MIN, BRelTime.makeSeconds(1), BFacets.MAX, BRelTime.MINUTE)")}), @NiagaraProperty(name="elapsedTimeAfterPromptForEndOfMessage", type="BRelTime", defaultValue="BRelTime.make(100L)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.TRUE, BFacets.MIN, BRelTime.make(5), BFacets.MAX, BRelTime.make(2000))")}), @NiagaraProperty(name="elapsedTimeWhileInBackupModeForEndOfMessage", type="BRelTime", defaultValue="BRelTime.makeSeconds(15)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(4), BFacets.MAX, BRelTime.MINUTE)")}), @NiagaraProperty(name="elapsedTimeWhileInBuildingListForEndOfMessage", type="BRelTime", defaultValue="BRelTime.makeSeconds(15)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(4), BFacets.MAX, BRelTime.MINUTE)")}), @NiagaraProperty(name="trackBufferUtilization", type="boolean", defaultValue="false"), @NiagaraProperty(name="bufferUtilization", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="bufferUtilizationMax", type="int", defaultValue="0", flags=3)})
public class BInfinitySerialReceiver
extends BDdfSerialNullReceiver
implements Vt100Const {
    @Generated
    public static final Property responseTimeout = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)25), (BFacets)DdfFacets.combine((BFacets)DdfFacets.MGR_INCLUDE, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.MINUTE)));
    @Generated
    public static final Property elapsedTimeForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)3), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.makeSeconds((int)1), (String)"max", (BIDataValue)BRelTime.MINUTE));
    @Generated
    public static final Property elapsedTimeAfterPromptForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.make((long)100L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)5L), (String)"max", (BIDataValue)BRelTime.make((long)2000L)));
    @Generated
    public static final Property elapsedTimeWhileInBackupModeForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)4), (String)"max", (BIDataValue)BRelTime.MINUTE));
    @Generated
    public static final Property elapsedTimeWhileInBuildingListForEndOfMessage = BInfinitySerialReceiver.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)4), (String)"max", (BIDataValue)BRelTime.MINUTE));
    @Generated
    public static final Property trackBufferUtilization = BInfinitySerialReceiver.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property bufferUtilization = BInfinitySerialReceiver.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property bufferUtilizationMax = BInfinitySerialReceiver.newProperty((int)3, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinitySerialReceiver.class);
    private int state = 0;
    private static final int FRAME_DONE = 6;
    private static final int WAITING_FOR_MORE = 7;
    private static final int TERMINAL_MODE = 8;
    long lastCharTime;

    @Generated
    public BRelTime getElapsedTimeForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeForEndOfMessage);
    }

    @Generated
    public void setElapsedTimeForEndOfMessage(BRelTime v) {
        this.set(elapsedTimeForEndOfMessage, (BValue)v, null);
    }

    @Generated
    public BRelTime getElapsedTimeAfterPromptForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeAfterPromptForEndOfMessage);
    }

    @Generated
    public void setElapsedTimeAfterPromptForEndOfMessage(BRelTime v) {
        this.set(elapsedTimeAfterPromptForEndOfMessage, (BValue)v, null);
    }

    @Generated
    public BRelTime getElapsedTimeWhileInBackupModeForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeWhileInBackupModeForEndOfMessage);
    }

    @Generated
    public void setElapsedTimeWhileInBackupModeForEndOfMessage(BRelTime v) {
        this.set(elapsedTimeWhileInBackupModeForEndOfMessage, (BValue)v, null);
    }

    @Generated
    public BRelTime getElapsedTimeWhileInBuildingListForEndOfMessage() {
        return (BRelTime)this.get(elapsedTimeWhileInBuildingListForEndOfMessage);
    }

    @Generated
    public void setElapsedTimeWhileInBuildingListForEndOfMessage(BRelTime v) {
        this.set(elapsedTimeWhileInBuildingListForEndOfMessage, (BValue)v, null);
    }

    @Generated
    public boolean getTrackBufferUtilization() {
        return this.getBoolean(trackBufferUtilization);
    }

    @Generated
    public void setTrackBufferUtilization(boolean v) {
        this.setBoolean(trackBufferUtilization, v, null);
    }

    @Generated
    public int getBufferUtilization() {
        return this.getInt(bufferUtilization);
    }

    @Generated
    public void setBufferUtilization(int v) {
        this.setInt(bufferUtilization, v, null);
    }

    @Generated
    public int getBufferUtilizationMax() {
        return this.getInt(bufferUtilizationMax);
    }

    @Generated
    public void setBufferUtilizationMax(int v) {
        this.setInt(bufferUtilizationMax, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void resetStatistics() {
        this.setBufferUtilization(0);
        this.setBufferUtilizationMax(0);
        super.resetStatistics();
    }

    private void updateBufferUtilization() throws Exception {
        if (this.getTrackBufferUtilization()) {
            int bytesInBuffer = this.getSerialCommunicator().getSerialInputStream().available();
            this.setBufferUtilization(bytesInBuffer);
            if (bytesInBuffer > this.getBufferUtilizationMax()) {
                this.setBufferUtilizationMax(bytesInBuffer);
            }
        }
    }

    protected IDdfDataFrame doReceiveFrame() throws Exception {
        this.resetReceiveBuffer();
        if (this.state == 8) {
            this.updateBufferUtilization();
            this.readByteToBuffer();
            return this.getInternalBuffer();
        }
        this.state = 7;
        while (this.state != 6) {
            this.updateBufferUtilization();
            this.readByteToBuffer();
            if (this.getSerialCommunicator().getSerialInputStream().available() != 0 || this.getInternalBuffer().getFrameSize() <= 0) continue;
            if (this.getNetwork().getBackupModeActive()) {
                if (Clock.ticks() - this.lastCharTime > this.getElapsedTimeWhileInBackupModeForEndOfMessage().getMillis()) {
                    if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
                        this.getNetwork().getLogger().fine("SerialReceiver timed out while backup mode active");
                    }
                    this.state = 6;
                    continue;
                }
                if (!this.getNetwork().getScreen().isBackupmodeNewLine()) continue;
                this.state = 6;
                continue;
            }
            if (this.getNetwork().getScreen().getMode() == 139) {
                if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeWhileInBuildingListForEndOfMessage().getMillis()) continue;
                if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
                    this.getNetwork().getLogger().fine("SerialReceiver timed out on BUILDING_LIST clause");
                }
                this.state = 6;
                continue;
            }
            if (this.getNetwork().getScreen().isCursorOnPrompt()) {
                if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeAfterPromptForEndOfMessage().getMillis()) continue;
                if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
                    this.getNetwork().getLogger().fine("SerialReceiver end of message because prompt detected");
                }
                this.state = 6;
                continue;
            }
            if (Clock.ticks() - this.lastCharTime <= this.getElapsedTimeForEndOfMessage().getMillis()) continue;
            if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
                this.getNetwork().getLogger().fine("SerialReceiver end of message because of normal time out");
            }
            this.state = 6;
        }
        return this.getInternalBuffer();
    }

    protected int readByte() throws Exception {
        return this.getSerialCommunicator().getSerialInputStream().read();
    }

    protected void readByteToBuffer() throws Exception {
        int b = this.readByte();
        if (b != -1) {
            this.lastCharTime = Clock.ticks();
            this.getInternalBuffer().write(b);
            this.getNetwork().getScreen().processByte((char)(b & 0xFF));
        }
    }

    private BInfinityNetwork getNetwork() {
        return (BInfinityNetwork)this.getSerialCommunicator().getDdfSerialNetwork();
    }
}

