/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.andoverInfinity;

import com.tridium.andoverInfinity.BInfinetDevice;
import com.tridium.andoverInfinity.BInfinityDeviceFolder;
import com.tridium.andoverInfinity.BInfinityNetworkDevice;
import com.tridium.andoverInfinity.comm.BInfinityCommunicator;
import com.tridium.andoverInfinity.comm.BInfinityLine;
import com.tridium.andoverInfinity.comm.BVt100;
import com.tridium.andoverInfinity.comm.CursorPosition;
import com.tridium.andoverInfinity.comm.Vt100Const;
import com.tridium.andoverInfinity.comm.req.BInfinityInitializeScreenRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityKeystrokeRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityPollForControllerInfoRequest;
import com.tridium.andoverInfinity.comm.req.BInfinityReloadInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySaveInfinetRequest;
import com.tridium.andoverInfinity.comm.req.BInfinitySetTimeRequest;
import com.tridium.andoverInfinity.discover.BInfinityDeviceDiscoveryPreferences;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import com.tridium.ddfSerial.comm.BDdfSerialCommunicator;
import com.tridium.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="communicator", type="BValue", defaultValue="new BInfinityCommunicator()", override=true), @NiagaraProperty(name="discoveryPreferences", type="BDdfDiscoveryPreferences", defaultValue="new BInfinityDeviceDiscoveryPreferences()", override=true), @NiagaraProperty(name="automaticallySetTime", type="boolean", defaultValue="true"), @NiagaraProperty(name="syncTimeFrequency", type="BRelTime", defaultValue="BRelTime.makeHours(1)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeMinutes(1))")}), @NiagaraProperty(name="restoreFile", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="networkDevice", type="BInfinityNetworkDevice", defaultValue="new BInfinityNetworkDevice()"), @NiagaraProperty(name="backupModeActive", type="boolean", defaultValue="false", flags=6), @NiagaraProperty(name="pageUpPageDown", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"use esc seq\",\"use control code\")")})})
@NiagaraActions(value={@NiagaraAction(name="syncTime"), @NiagaraAction(name="refresh"), @NiagaraAction(name="setTerminalModeActive", parameterType="BBoolean", defaultValue="BBoolean.FALSE", flags=4), @NiagaraAction(name="backupModeActivate", flags=4), @NiagaraAction(name="reload", parameterType="BBlob", defaultValue="BBlob.DEFAULT", flags=2052), @NiagaraAction(name="abortReload", flags=4), @NiagaraAction(name="retrieveNetworkDeviceInfo"), @NiagaraAction(name="dumpScreenBuffer"), @NiagaraAction(name="keystrokesCommand", parameterType="BString", defaultValue="BString.make(\"\")", flags=2052), @NiagaraAction(name="getMode"), @NiagaraAction(name="loadScreenBufferFromFile", parameterType="BBlob", defaultValue="BBlob.DEFAULT", flags=2052), @NiagaraAction(name="saveScreenBufferToFile", returnType="BBlob", flags=2052)})
@NiagaraTopics(value={@NiagaraTopic(name="terminalUpdated", flags=4), @NiagaraTopic(name="backupModeDone", flags=4), @NiagaraTopic(name="reloadModeDone", flags=4)})
public class BInfinityNetwork
extends BDdfSerialNetwork {
    @Generated
    public static final Property communicator = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityCommunicator(), null);
    @Generated
    public static final Property discoveryPreferences = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityDeviceDiscoveryPreferences(), null);
    @Generated
    public static final Property automaticallySetTime = BInfinityNetwork.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property syncTimeFrequency = BInfinityNetwork.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeMinutes((int)1)));
    @Generated
    public static final Property restoreFile = BInfinityNetwork.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property networkDevice = BInfinityNetwork.newProperty((int)0, (BValue)new BInfinityNetworkDevice(), null);
    @Generated
    public static final Property backupModeActive = BInfinityNetwork.newProperty((int)6, (boolean)false, null);
    @Generated
    public static final Property pageUpPageDown = BInfinityNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"use esc seq", (String)"use control code"));
    @Generated
    public static final Action syncTime = BInfinityNetwork.newAction((int)0, null);
    @Generated
    public static final Action refresh = BInfinityNetwork.newAction((int)0, null);
    @Generated
    public static final Action setTerminalModeActive = BInfinityNetwork.newAction((int)4, (BValue)BBoolean.FALSE, null);
    @Generated
    public static final Action backupModeActivate = BInfinityNetwork.newAction((int)4, null);
    @Generated
    public static final Action reload = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Action abortReload = BInfinityNetwork.newAction((int)4, null);
    @Generated
    public static final Action retrieveNetworkDeviceInfo = BInfinityNetwork.newAction((int)0, null);
    @Generated
    public static final Action dumpScreenBuffer = BInfinityNetwork.newAction((int)0, null);
    @Generated
    public static final Action keystrokesCommand = BInfinityNetwork.newAction((int)2052, (BValue)BString.make((String)""), null);
    @Generated
    public static final Action getMode = BInfinityNetwork.newAction((int)0, null);
    @Generated
    public static final Action loadScreenBufferFromFile = BInfinityNetwork.newAction((int)2052, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Action saveScreenBufferToFile = BInfinityNetwork.newAction((int)2052, null);
    @Generated
    public static final Topic terminalUpdated = BInfinityNetwork.newTopic((int)4, null);
    @Generated
    public static final Topic backupModeDone = BInfinityNetwork.newTopic((int)4, null);
    @Generated
    public static final Topic reloadModeDone = BInfinityNetwork.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInfinityNetwork.class);
    private boolean connected = true;
    private BVt100 screen;
    private final Object stringLock = new Object();
    private String keystrokes = "";
    private boolean terminalModeActive = false;
    private boolean reloadModeActive = false;
    private Clock.Ticket timeSyncTicket;
    private boolean shouldAbortReload = false;

    @Generated
    public boolean getAutomaticallySetTime() {
        return this.getBoolean(automaticallySetTime);
    }

    @Generated
    public void setAutomaticallySetTime(boolean v) {
        this.setBoolean(automaticallySetTime, v, null);
    }

    @Generated
    public BRelTime getSyncTimeFrequency() {
        return (BRelTime)this.get(syncTimeFrequency);
    }

    @Generated
    public void setSyncTimeFrequency(BRelTime v) {
        this.set(syncTimeFrequency, (BValue)v, null);
    }

    @Generated
    public BOrd getRestoreFile() {
        return (BOrd)this.get(restoreFile);
    }

    @Generated
    public void setRestoreFile(BOrd v) {
        this.set(restoreFile, (BValue)v, null);
    }

    @Generated
    public BInfinityNetworkDevice getNetworkDevice() {
        return (BInfinityNetworkDevice)this.get(networkDevice);
    }

    @Generated
    public void setNetworkDevice(BInfinityNetworkDevice v) {
        this.set(networkDevice, (BValue)v, null);
    }

    @Generated
    public boolean getBackupModeActive() {
        return this.getBoolean(backupModeActive);
    }

    @Generated
    public void setBackupModeActive(boolean v) {
        this.setBoolean(backupModeActive, v, null);
    }

    @Generated
    public boolean getPageUpPageDown() {
        return this.getBoolean(pageUpPageDown);
    }

    @Generated
    public void setPageUpPageDown(boolean v) {
        this.setBoolean(pageUpPageDown, v, null);
    }

    @Generated
    public void syncTime() {
        this.invoke(syncTime, null, null);
    }

    @Generated
    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Generated
    public void setTerminalModeActive(BBoolean parameter) {
        this.invoke(setTerminalModeActive, (BValue)parameter, null);
    }

    @Generated
    public void backupModeActivate() {
        this.invoke(backupModeActivate, null, null);
    }

    @Generated
    public void reload(BBlob parameter) {
        this.invoke(reload, (BValue)parameter, null);
    }

    @Generated
    public void abortReload() {
        this.invoke(abortReload, null, null);
    }

    @Generated
    public void retrieveNetworkDeviceInfo() {
        this.invoke(retrieveNetworkDeviceInfo, null, null);
    }

    @Generated
    public void dumpScreenBuffer() {
        this.invoke(dumpScreenBuffer, null, null);
    }

    @Generated
    public void keystrokesCommand(BString parameter) {
        this.invoke(keystrokesCommand, (BValue)parameter, null);
    }

    @Generated
    public void getMode() {
        this.invoke(getMode, null, null);
    }

    @Generated
    public void loadScreenBufferFromFile(BBlob parameter) {
        this.invoke(loadScreenBufferFromFile, (BValue)parameter, null);
    }

    @Generated
    public BBlob saveScreenBufferToFile() {
        return (BBlob)this.invoke(saveScreenBufferToFile, null, null);
    }

    @Generated
    public void fireTerminalUpdated(BValue event) {
        this.fire(terminalUpdated, event, null);
    }

    @Generated
    public void fireBackupModeDone(BValue event) {
        this.fire(backupModeDone, event, null);
    }

    @Generated
    public void fireReloadModeDone(BValue event) {
        this.fire(reloadModeDone, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "andoverInfinity");
    }

    public void started() throws Exception {
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.setFlags((Slot)ping, 4);
        this.screen = new BVt100();
        this.screen.setNetwork(this);
        if (this.getAutomaticallySetTime()) {
            this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
        }
        super.started();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.refresh();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.timeSyncTicket != null) {
            this.timeSyncTicket.cancel();
        }
        this.timeSyncTicket = null;
    }

    public void changed(Property p, Context cx) {
        if ((p == syncTimeFrequency || p == automaticallySetTime) && this.isRunning()) {
            if (this.timeSyncTicket != null) {
                this.timeSyncTicket.cancel();
            }
            if (this.getAutomaticallySetTime()) {
                this.timeSyncTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getSyncTimeFrequency(), (Action)syncTime, null);
            }
        }
        super.changed(p, cx);
    }

    public final Type getDeviceType() {
        return BInfinetDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BInfinityDeviceFolder.TYPE;
    }

    public void doRefresh() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doRefresh");
        }
        BInfinityInitializeScreenRequest initReq = new BInfinityInitializeScreenRequest(this);
        if (this.getDdfCommunicator() == null) {
            this.getLogger().warning("Communicator is null");
        } else {
            try {
                this.getDdfCommunicator().communicate((BIDdfRequest)initReq);
            }
            catch (Exception e) {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.WARNING, "Refresh: failed to communicate", e);
                }
                this.getLogger().log(Level.WARNING, "Refresh: failed to communicate: " + e.getMessage());
            }
        }
    }

    public void doSetTerminalModeActive(BBoolean activate) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doSetTerminalModeActive");
        }
        this.terminalModeActive = activate.getBoolean();
    }

    public void doBackupModeActivate() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doBackupModeActivate");
        }
        BInfinitySaveInfinetRequest req = new BInfinitySaveInfinetRequest();
        BDdfSerialCommunicator communicator = (BDdfSerialCommunicator)this.getDdfCommunicator();
        communicator.communicate((BIDdfRequest)req);
    }

    public void doReload(BBlob blob) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doReload");
        }
        this.getLogger().finest(new String(blob.copyBytes()));
        BInfinityReloadInfinetRequest req = new BInfinityReloadInfinetRequest();
        req.setFileContents(blob);
        this.getDdfCommunicator().communicate((BIDdfRequest)req);
    }

    public void doAbortReload() {
        this.setShouldAbortReload(true);
    }

    public void doKeystrokesCommand(BString cmd) {
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doKeystrokesCommand");
        }
        this.getLogger().finest("doKeystrokes:" + cmd.getString());
        if (this.terminalModeActive || this.getBackupModeActive() || this.reloadModeActive) {
            if (this.terminalModeActive) {
                this.getLogger().finest("doKeystrokesCommand:terminalModeActive");
            }
            if (this.getBackupModeActive()) {
                this.getLogger().finest("doKeystrokesCommand:backupModeActive");
            }
            if (this.reloadModeActive) {
                this.getLogger().finest("doKeystrokesCommand:reloadModeActive");
            }
            this.receiveKeystrokes(cmd.getString());
            BInfinityKeystrokeRequest rawReq = new BInfinityKeystrokeRequest(this.getKeystrokes().getBytes());
            this.getDdfCommunicator().communicate((BIDdfRequest)rawReq);
        }
    }

    public void doRetrieveNetworkDeviceInfo() {
        if (!this.isRunning()) {
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doRetrieveNetworkDeviceInfo");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
    }

    public void doSyncTime() {
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doSyncTime");
        }
        this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinitySetTimeRequest());
    }

    public BBlob doSaveScreenBufferToFile() {
        return BBlob.make((byte[])this.getScreen().screenBufferToString().getBytes());
    }

    public void doLoadScreenBufferFromFile(BBlob fileBlob) {
        int i;
        if (!this.isRunning()) {
            return;
        }
        if (this.getNetwork().getLogger().isLoggable(Level.FINE)) {
            this.getNetwork().getLogger().fine("doLoadTestBuffer");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileBlob.copyBytes())));
        String[] buffer = new String[49];
        int newLine = 1;
        int newCol = 1;
        for (i = 0; i < 49; ++i) {
            if (i < 24) {
                try {
                    buffer[i] = in.readLine().substring(0, 80);
                    this.getScreen().setContentLine(i, buffer[i]);
                }
                catch (IOException e) {
                    this.getScreen().setContentLine(i, " ");
                }
                continue;
            }
            if (i < 48) {
                try {
                    buffer[i] = in.readLine().substring(0, 80);
                    this.getScreen().setFormatLine(i - 24, buffer[i]);
                }
                catch (IOException e) {
                    this.getScreen().setContentLine(i, " ");
                }
                continue;
            }
            if (i != 48) continue;
            try {
                buffer[i] = in.readLine();
                int start = buffer[i].indexOf(91);
                int colon = buffer[i].indexOf(58, start);
                int end = buffer[i].indexOf(93);
                newLine = Integer.parseInt(buffer[i].substring(start + 1, colon));
                newCol = Integer.parseInt(buffer[i].substring(colon + 1, end));
                this.getScreen().setPosition(new CursorPosition(newLine, newCol));
                continue;
            }
            catch (IOException | StringIndexOutOfBoundsException exception) {
                // empty catch block
            }
        }
        for (i = 0; i < 24; ++i) {
            this.fireTerminalUpdated((BValue)new BInfinityLine(i, i, newLine, newCol, buffer[i], buffer[i + 24]));
        }
    }

    public BINavNode[] getNavChildren() {
        Object[] kids = super.getNavChildren();
        return (BINavNode[])ArrayUtil.addOne((Object[])kids, (Object)((Object)this.getNetworkDevice()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveKeystrokes(String more) {
        Object object = this.stringLock;
        synchronized (object) {
            this.keystrokes = this.keystrokes + more;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeystrokes() {
        String latestKeystrokes;
        Object object = this.stringLock;
        synchronized (object) {
            latestKeystrokes = this.keystrokes;
            this.keystrokes = "";
        }
        return latestKeystrokes;
    }

    public BVt100 getScreen() {
        return this.screen;
    }

    public int getLine() {
        return this.screen.getCursorPosition().getLine();
    }

    public CursorPosition getCursorPosition() {
        return this.screen.getCursorPosition();
    }

    public void doDumpScreenBuffer() {
        this.getScreen().doDumpScreen();
    }

    public void doGetMode() {
        this.getLogger().finest("Mode:" + Vt100Const.cursorModes[this.getScreen().getMode()]);
        this.getLogger().finest("Insert is " + (this.getScreen().isInsertMode() ? "on" : "off"));
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        if (!this.isRunning()) {
            return;
        }
        if (connected) {
            if (this.isDown()) {
                this.getDdfCommunicator().communicate((BIDdfRequest)new BInfinityPollForControllerInfoRequest());
            }
            this.pingOk();
        } else {
            this.pingFail("not connected");
        }
        this.connected = connected;
    }

    public boolean isTerminalModeActive() {
        return this.terminalModeActive;
    }

    public boolean isReloadModeActive() {
        return this.reloadModeActive;
    }

    public void setReloadModeActive(boolean reloadModeActive) {
        this.reloadModeActive = reloadModeActive;
    }

    public Logger getLogger() {
        return super.getLogger();
    }

    public boolean isShouldAbortReload() {
        return this.shouldAbortReload;
    }

    public void setShouldAbortReload(boolean shouldAbortReload) {
        this.shouldAbortReload = shouldAbortReload;
    }
}

