/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.cloud.client.NiagaraMessageType;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.point.BCloudPointDeviceExt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.sys.BAbsTime;

public class BatchPointUpdater
implements Runnable {
    private final BCloudPointDeviceExt pointDeviceExt;
    private final BPollFrequency rate;
    private final Logger log;

    BatchPointUpdater(BCloudPointDeviceExt pointDeviceExt, BPollFrequency rate) {
        this.pointDeviceExt = pointDeviceExt;
        this.rate = rate;
        this.log = Logger.getLogger("ncloud.point." + BatchPointUpdater.rateName(rate));
    }

    @Override
    public void run() {
        int batchSize = this.pointDeviceExt.getBatchSize();
        this.log.finest(() -> String.format("BatchPointUpdater.run(%s), batch size:%s", this.rate, batchSize));
        try {
            BControlPoint[] points = this.pointDeviceExt.getPoints();
            BCloudDevice device = this.pointDeviceExt.getCloudDevice();
            BICloudConnector connector = device.resolveConnector();
            if (!this.canUpdate(device, connector)) {
                return;
            }
            ArrayList updates = new ArrayList();
            Arrays.stream(points).filter(pt -> pt.isRunning() && !CloudUtilities.cloudProxy(pt).isFatalFault()).filter(pt -> CloudUtilities.cloudProxy(pt).getPollFrequency() == this.rate).forEach(pt -> CloudUtilities.cloudProxy(pt).addBatchUpdate(updates));
            if (!updates.isEmpty()) {
                int batchCounter = 0;
                do {
                    List<?> batch = BatchPointUpdater.batch(updates, batchCounter, batchSize);
                    batchCounter += batch.size();
                    CloudEncodeMsg ptHistoryMsg = this.pointDeviceExt.getCloudDevice().getFactory().createHistoryUpdateMsg(NiagaraMessageType.loPriPoint);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("PointValues", batch);
                    connector.sendMessage(ptHistoryMsg.encode(properties), ptHistoryMsg.getProperties(properties)).whenComplete((resp, err) -> {
                        if (err != null) {
                            this.log.warning(() -> String.format("Batch point update failed for point count %d at %s:%s", batch.size(), this.rate, err));
                            this.log.logp(Level.FINE, "BatchPointUpdater", "connector.sendMessage()", "Batch point update error", (Throwable)err);
                            batch.forEach(ptUpdate -> ptUpdate.getProxyExt().writeFail("Batch point update failed: " + err.getLocalizedMessage()));
                        } else {
                            this.log.fine(() -> String.format("Batch point update sent: point count %d at %s", batch.size(), this.rate));
                            batch.forEach(ptUpdate -> {
                                ptUpdate.getProxyExt().writeOk(ptUpdate.getProxyExt().getWriteValue());
                                ptUpdate.getProxyExt().setLastSentToCloud(BAbsTime.now());
                            });
                        }
                    });
                } while (batchCounter < updates.size());
            } else {
                this.log.finest(() -> String.format("No batch point updates for %s", this.rate));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Exception in batch update for " + this.rate + ": " + e, this.log.isLoggable(Level.FINE) ? e : null);
        }
    }

    private boolean canUpdate(BCloudDevice device, BICloudConnector connector) {
        if (device.isDisabled()) {
            this.log.config("Cloud Device is disabled");
            return false;
        }
        if (connector == null) {
            this.log.config("Cloud Connector is null");
            return false;
        }
        if (!connector.isConnected()) {
            this.log.config("Cloud Connector is disconnected");
            return false;
        }
        return true;
    }

    public static List<?> batch(List<?> fullList, int start, int batchSize) {
        int len = fullList.size();
        if (start + batchSize > len) {
            return fullList.subList(start, fullList.size());
        }
        return fullList.subList(start, start + batchSize);
    }

    private static String rateName(BPollFrequency rate) {
        switch (rate.getOrdinal()) {
            case 0: {
                return "priority";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "background";
            }
        }
        return "default";
    }
}

