/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.point;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.nc.point.BCloudLearnConfig;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BCloudPointDiscoveryPreferences;
import com.tridium.nc.point.BCloudPointFolder;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.sys.station.Station;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

@NiagaraType
public class BCloudPointLearnJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BCloudPointLearnJob.class);
    private final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    private Exception jobException;
    private final BCloudPointDeviceExt pointDeviceExt;
    private BCloudLearnConfig learnConfig;
    public static final String CLOUD_POINT_FOLDER_NONDUP_SUFFIX = "_cpf";
    public static final String CLOUD_PROXY_POINT_NONDUP_SUFFIX = "_pxy";
    private static final int MAX_SIBLING_ATTEMPTS = 10;

    public Type getType() {
        return TYPE;
    }

    public BCloudPointLearnJob() {
        this.pointDeviceExt = null;
    }

    public BCloudPointLearnJob(BCloudPointDeviceExt pointDeviceExt, BCloudLearnConfig learnConfig) {
        this.pointDeviceExt = pointDeviceExt;
        this.learnConfig = learnConfig;
    }

    public void run(Context context) throws Exception {
        this.log().start("nCloudDriver", "point.discover.start", null);
        try {
            BCloudPointDiscoveryPreferences prefs = (BCloudPointDiscoveryPreferences)this.learnConfig.getDiscoveryPreferences().newCopy();
            BITable result = (BITable)prefs.getPointQuery().resolve((BObject)this.pointDeviceExt).get();
            TableCursor c = result.cursor();
            String pointDevExtSlotPath = this.pointDeviceExt.getSlotPath().toString();
            BComponent currentParent = null;
            int discoveredCount = 0;
            int addedCount = 0;
            while (this.isJobRunning() && c.next()) {
                BControlPoint discoveredPoint = (BControlPoint)c.get();
                BComponent newParent = discoveredPoint.getParent().asComponent();
                if (newParent != currentParent) {
                    if (currentParent != null) {
                        this.log().message(String.format(this.lexicon.getText("point.learn.discoveredAddedCount"), currentParent.getSlotPath().getBody(), discoveredCount, addedCount));
                    }
                    currentParent = newParent;
                    discoveredCount = 0;
                    addedCount = 0;
                }
                if (BCloudPointLearnJob.isInCloudPoints(discoveredPoint, pointDevExtSlotPath)) continue;
                ++discoveredCount;
                BComponent folder = this.addCloudPointFolders(discoveredPoint.getSlotPath(), (BComponent)this.pointDeviceExt);
                if (!this.addPoint(discoveredPoint, folder)) continue;
                ++addedCount;
            }
            this.log().message(String.format(this.lexicon.getText("point.learn.discoveredAddedCount"), currentParent.getSlotPath().getBody(), discoveredCount, addedCount));
            this.log().message(this.lexicon.getText("point.learn.learnCompleteSaving"));
            Station.saveSync((BJob)this);
        }
        catch (Exception e) {
            this.jobException = e;
        }
        this.end();
    }

    private static boolean isInCloudPoints(BControlPoint newPoint, String existingSlotPath) {
        String pointSlotPath = newPoint.getSlotPath().toString();
        return pointSlotPath.startsWith(existingSlotPath);
    }

    private BComponent addCloudPointFolders(SlotPath pointSlotPath, BComponent folder) {
        String[] path = pointSlotPath.getNames();
        for (int i = 0; i < path.length - 1; ++i) {
            BCloudPointFolder pointFolder = null;
            BValue pathVal = folder.get(path[i]);
            if (pathVal == null) {
                pointFolder = new BCloudPointFolder();
                folder.add(path[i], (BValue)pointFolder, BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
            } else if (pathVal instanceof BCloudPointFolder) {
                pointFolder = (BCloudPointFolder)pathVal;
            } else {
                String cpfNameBase;
                String cpfName = cpfNameBase = path[i] + CLOUD_POINT_FOLDER_NONDUP_SUFFIX;
                BValue cpfCandidate = folder.get(cpfName);
                int attempts = 1;
                do {
                    if (cpfCandidate == null) {
                        pointFolder = new BCloudPointFolder();
                        folder.add(cpfName, (BValue)pointFolder, BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
                        this.log().message(String.format(this.lexicon.getText("point.learn.cloudPointFolderWithAlternateName"), path[i], cpfName));
                        break;
                    }
                    if (cpfCandidate instanceof BCloudPointFolder) {
                        pointFolder = (BCloudPointFolder)cpfCandidate;
                        break;
                    }
                    cpfName = cpfNameBase + attempts++;
                    cpfCandidate = folder.get(cpfName);
                } while (attempts <= 10);
                if (pointFolder == null) {
                    this.log().message(String.format(this.lexicon.getText("point.learn.couldNotCreateSiblingCpf"), pointSlotPath, folder.getSlotPath()));
                    break;
                }
            }
            folder = pointFolder;
        }
        return folder;
    }

    private boolean addPoint(BControlPoint point, BComponent parent) {
        String ptNameBase;
        String name = point.getName();
        BValue kid = parent.get(name);
        if (kid == null) {
            this.addProxy(parent, name, point);
            return true;
        }
        if (BCloudPointLearnJob.isProxy(kid, point.getSlotPathOrd())) {
            this.log().message(String.format(this.lexicon.getText("point.learn.alreadyAdded"), point.getSlotPath()));
            return false;
        }
        int attempts = 1;
        String ptName = ptNameBase = name + CLOUD_PROXY_POINT_NONDUP_SUFFIX;
        BValue ptCandidate = parent.get(ptName);
        while (attempts < 10 && ptCandidate != null) {
            if (BCloudPointLearnJob.isProxy(ptCandidate, point.getSlotPathOrd())) {
                this.log().message(String.format(this.lexicon.getText("point.learn.alreadyAdded"), point.getSlotPath()));
                return false;
            }
            ptName = ptNameBase + attempts++;
            ptCandidate = parent.get(ptName);
        }
        if (ptCandidate == null) {
            BCloudProxyExt px = this.addProxy(parent, ptName, point);
            this.log().message(String.format(this.lexicon.getText("point.learn.addedWithAlternateName"), name, point.getSlotPath(), ptName, px.getPointId()));
            return true;
        }
        this.log().message(String.format(this.lexicon.getText("point.learn.couldNotCreateSiblingProxy"), point.getSlotPath(), parent.getSlotPath()));
        return false;
    }

    private static boolean isProxy(BValue v, BOrd srcOrd) {
        return v instanceof BControlPoint && ((BControlPoint)v).getProxyExt() instanceof BCloudProxyExt && ((BCloudProxyExt)((BControlPoint)v).getProxyExt()).getOrdPath().equals((Object)srcOrd);
    }

    private BCloudProxyExt addProxy(BComponent parent, String name, BControlPoint point) {
        BControlPoint newPoint = BCloudPointLearnJob.makePointForProxy(point);
        BCloudProxyExt pext = new BCloudProxyExt();
        pext.setOrdPath(point.getSlotPathOrd());
        pext.setDeviceFacets(newPoint.getFacets());
        pext.setStationPointInput(this.learnConfig.getStationPointInput());
        pext.setTuningPolicyName(this.learnConfig.getTuningPolicyName());
        newPoint.setProxyExt((BAbstractProxyExt)pext);
        parent.add(name, (BValue)newPoint, BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
        newPoint.getParent().asComponent().setDisplayName(newPoint.getPropertyInParent(), BFormat.make((String)point.getDisplayName(null)), BDataRecoveryComponentRecorder.SKIP_CRITICAL_CX);
        return pext;
    }

    private static BControlPoint makePointForProxy(BControlPoint sourcePoint) {
        Type srcType = sourcePoint.getType();
        if (srcType.is(BNumericPoint.TYPE)) {
            return new BNumericPoint();
        }
        if (srcType.is(BBooleanPoint.TYPE)) {
            return new BBooleanPoint();
        }
        if (srcType.is(BEnumPoint.TYPE)) {
            return new BEnumPoint();
        }
        return new BStringPoint();
    }

    protected void end() {
        if (this.jobException != null) {
            this.failed(this.jobException);
        } else if (this.isCanceled()) {
            this.canceled();
        } else {
            this.success();
        }
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    private boolean isJobRunning() {
        return this.getJobState() == BJobState.running;
    }
}

