/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.history;

import com.tridium.nc.history.BCloudHistoryDeviceExt;
import com.tridium.nc.history.BCloudHistoryExport;
import com.tridium.nc.history.BCloudHistoryExportLearnConfig;
import com.tridium.nc.history.BCloudHistoryFolder;
import com.tridium.util.CompUtil;
import com.tridium.util.EscUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.PatternFilter;

@NiagaraType
public class BCloudHistoryLearnJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BCloudHistoryLearnJob.class);
    private static final BHistoryDevice[] NO_DEVICES = new BHistoryDevice[0];
    public static final String CLOUD_HISTORY_FOLDER_NONDUP_SUFFIX = "_chf";
    public static final String CLOUD_HISTORY_EXPORT_NONDUP_SUFFIX = "_chx";
    private static final Lexicon lexicon = Lexicon.make((String)"nCloudDriver");
    public static final String lexLocal = lexicon.getText("historyExportManager.local");
    private static final Logger logger = Logger.getLogger("ncloud.history");
    private final BCloudHistoryDeviceExt historyDeviceExt;
    private BCloudHistoryExportLearnConfig learnConfig;
    private Exception jobException;
    private String parentStationName = "";
    private Set<BHistoryId> existingHistories = new HashSet<BHistoryId>();
    private static final Logger logDbg = Logger.getLogger("ncloud.history.dbg");

    public Type getType() {
        return TYPE;
    }

    public BCloudHistoryLearnJob() {
        this.historyDeviceExt = null;
    }

    public BCloudHistoryLearnJob(BCloudHistoryDeviceExt deviceExt, BCloudHistoryExportLearnConfig learnConfig) {
        this.historyDeviceExt = deviceExt;
        this.learnConfig = learnConfig;
    }

    public void run(Context context) {
        this.log().start("nCloudDriver", "history.learn.start", null);
        this.log().message("nCloudDriver", "history.learn.config", new String[]{this.learnConfig.getDeviceExclusionPatterns(), this.learnConfig.getHistoryExclusionPatterns(), this.learnConfig.getBeginExportTime().toString()});
        try {
            Objects.requireNonNull(this.historyDeviceExt);
            this.parentStationName = Sys.getStation().getStationName();
            this.getExistingHistoriesOnDeviceExt();
            BHistoryDevice[] historyDevices = BCloudHistoryLearnJob.getHistoryDevices((BComponent)this.historyDeviceExt);
            double devsLen = historyDevices.length;
            int i = 0;
            while ((double)i < devsLen) {
                if (!this.isJobRunning()) {
                    this.canceled();
                    throw new JobCancelException(lexicon.get("history.learn.canceled"));
                }
                int progressAtStart = (int)((double)i * 100.0 / devsLen);
                int progressAtEnd = (int)((double)(i + 1) * 100.0 / devsLen);
                BHistoryDevice device = historyDevices[i];
                if (BCloudHistoryLearnJob.includeDevice(this.learnConfig.getDeviceExclusionPatterns(), device.getDeviceName())) {
                    BINavNode[] children = device.getNavChildren();
                    double histsLen = children.length;
                    int exportAddCount = 0;
                    int j = 0;
                    while ((double)j < histsLen && this.isJobRunning()) {
                        BINavNode discovery = children[j];
                        if (this.addCloudHistoryExport(discovery, device)) {
                            ++exportAddCount;
                        }
                        this.progress(progressAtStart, progressAtEnd, j, histsLen);
                        ++j;
                    }
                    this.log().message(String.format(lexicon.getText("history.learn.historyExportAddedCount"), device.getDeviceName(), (int)histsLen, exportAddCount));
                    if (!this.isJobRunning()) {
                        this.canceled();
                        throw new JobCancelException(lexicon.get("history.learn.canceled"));
                    }
                    this.progress(0.0, 100.0, i, devsLen);
                } else {
                    this.log().message("nCloudDriver", "history.learn.skipDevice", device.getDeviceName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.jobException = e;
            throw e;
        }
        this.end();
    }

    private void getExistingHistoriesOnDeviceExt() {
        BCloudHistoryExport[] components = (BCloudHistoryExport[])CompUtil.getDescendants((BComponent)((BComponent)Objects.requireNonNull(this.historyDeviceExt)), BCloudHistoryExport.class);
        logger.finest(() -> String.format(lexicon.getText("history.learn.getExistingHistories"), components.length));
        this.existingHistories = Arrays.stream(components).map(BCloudHistoryExport2 -> BCloudHistoryExport2.getHistoryId().toShorthand(this.parentStationName)).collect(Collectors.toSet());
    }

    private static BHistoryDevice[] getHistoryDevices(BComponent target) {
        BHistoryDeviceExt ext = ((BIArchiveFolder)target).getDeviceExt();
        BISession session = ext.getSession();
        BOrd spaceOrd = BOrd.make((String)"history:");
        BHistorySpace space = (BHistorySpace)spaceOrd.resolve((BObject)session).get();
        return space == null ? NO_DEVICES : space.listDevices();
    }

    private BCloudHistoryFolder getFolder(BHistoryDevice device) {
        String chfName = device.getDeviceName();
        BValue v = Objects.requireNonNull(this.historyDeviceExt).get(EscUtil.slot.escape(chfName));
        if (v != null) {
            if (v instanceof BCloudHistoryFolder) {
                return (BCloudHistoryFolder)v;
            }
            chfName = chfName + CLOUD_HISTORY_FOLDER_NONDUP_SUFFIX;
        }
        BCloudHistoryFolder folder = new BCloudHistoryFolder();
        Property chfProp = this.historyDeviceExt.add(chfName + '?', (BValue)folder);
        this.log().message(String.format(lexicon.getText("history.learn.addDevice"), chfProp.getName(), device.getDeviceName()));
        return folder;
    }

    private boolean addCloudHistoryExport(BINavNode discovery, BHistoryDevice device) {
        boolean added = false;
        if (discovery instanceof BIHistory) {
            BIHistory history = (BIHistory)discovery;
            if (BCloudHistoryLearnJob.includeHistory(this.learnConfig.getHistoryExclusionPatterns(), history.getId())) {
                String name;
                BCloudHistoryFolder folder = this.getFolder(device);
                BHistoryId shorthandId = history.getId().toShorthand(this.parentStationName);
                String finalName = name = BCloudHistoryLearnJob.name(shorthandId);
                logger.finest(() -> String.format("Checking for history export: folder:%s; shorthandId:%s; name:%s; exportExists(shId):%s; childExists(f,n):%s", folder.getName(), shorthandId, finalName, this.exportExists(shorthandId), BCloudHistoryLearnJob.childExists(folder, finalName)));
                if (!this.exportExists(shorthandId)) {
                    BCloudHistoryExport hExp = new BCloudHistoryExport();
                    hExp.setHistoryId(shorthandId);
                    logDbg.finest("Calling HDE.getSourceOrd() from learn job addCloudHistoryExport()...");
                    hExp.setSourceOrd(this.historyDeviceExt.getSourceOrd(history));
                    hExp.setLastSentToCloud(this.learnConfig.getBeginExportTime());
                    if (BCloudHistoryLearnJob.childExists(folder, name)) {
                        name = name + CLOUD_HISTORY_EXPORT_NONDUP_SUFFIX;
                        Property altProp = folder.add(name + '?', (BValue)hExp);
                        this.log().message(String.format(lexicon.getText("history.learn.addAltNamedHistoryExport"), altProp.getName(), shorthandId));
                        added = true;
                    } else {
                        folder.add(EscUtil.slot.escape(name), (BValue)hExp);
                        added = true;
                    }
                } else {
                    this.log().message(String.format(lexicon.getText("history.learn.historyAlreadyAdded"), history.getId().toString()));
                }
            } else {
                this.log().message("nCloudDriver", "history.learn.skipHistory", history.getId().toString());
            }
        }
        return added;
    }

    private void progress(double progAtStart, double progAtEnd, double prog, double numSteps) {
        this.progress((int)(progAtStart + prog * (progAtEnd - progAtStart) / numSteps));
    }

    private static String name(BHistoryId shorthandId) {
        String name = shorthandId.toString();
        name = name.startsWith("^") ? lexLocal + '_' + name.substring(1) : name.substring(1);
        name = name.replace('/', '_');
        return name;
    }

    private boolean exportExists(BHistoryId shorthandId) {
        return this.existingHistories.contains(shorthandId);
    }

    private static boolean childExists(BCloudHistoryFolder folder, String name) {
        return folder.get(name) != null;
    }

    protected void end() {
        if (this.jobException != null) {
            this.failed(this.jobException);
        } else if (this.isCanceled()) {
            this.canceled();
        } else {
            this.success();
        }
    }

    public static boolean includeDevice(String exclusionPatterns, String historyDeviceName) {
        PatternFilter[] excludeDevices;
        for (PatternFilter filter : excludeDevices = PatternFilter.parseList((String)exclusionPatterns, (String)";")) {
            if (!filter.accept(historyDeviceName)) continue;
            return false;
        }
        return true;
    }

    public static boolean includeHistory(String exclusionPatterns, BHistoryId historyId) {
        PatternFilter[] excludeDevices = PatternFilter.parseList((String)exclusionPatterns, (String)";");
        String historyName = SlotPath.unescape((String)historyId.getHistoryName());
        for (PatternFilter filter : excludeDevices) {
            if (!filter.accept(historyName)) continue;
            return false;
        }
        return true;
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    private boolean isJobRunning() {
        return this.getJobState() == BJobState.running;
    }
}

