/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.devices.sentience.points;

import com.tridium.cloud.client.BICloudConnector;
import com.tridium.json.JSONArray;
import com.tridium.nc.BCloudDevice;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.CloudDecodeMsg;
import com.tridium.nc.devices.CloudEncodeMsg;
import com.tridium.nc.devices.CloudReadHandler;
import com.tridium.nc.devices.sentience.points.CloudMultiPointData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.util.Lexicon;

public class SentienceReadHandler
implements CloudReadHandler {
    private final BCloudDevice cloudConnectorDevice;
    private static final Logger log = Logger.getLogger("ncloud.point");
    private static final Lexicon LEX = Lexicon.make((String)"nCloudDriver");

    public SentienceReadHandler(BCloudDevice cloudConnectorDevice) {
        this.cloudConnectorDevice = cloudConnectorDevice;
    }

    @Override
    public void handleResponse(CloudDecodeMsg request, String messageId, Context cx) {
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        String sentiencePointId = (String)request.getData("PointId");
        BControlPoint pxPoint = CloudUtilities.getPoint(SlotPath.unescape((String)sentiencePointId));
        if (CloudUtilities.canSendMessage(this.cloudConnectorDevice)) {
            CloudEncodeMsg ackResponse = this.cloudConnectorDevice.getFactory().createPointReadResponseMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            HashMap<String, Object> ackProperties = new HashMap<String, Object>();
            if (pxPoint != null) {
                if (CloudUtilities.isPointReadAllowed(this.cloudConnectorDevice.getNiagaraCloudNetwork(), pxPoint, cx)) {
                    BStatusValue pointValue = CloudUtilities.cloudProxy(pxPoint).getPointValue();
                    String status = CloudUtilities.toStatusString(pointValue.getStatus());
                    String value = pointValue.getValueValue().toString();
                    properties.put("Status", status);
                    properties.put("Value", value);
                } else {
                    properties.put("Status", "Error: Access Not Allowed");
                    log.warning(() -> String.format(LEX.getText("accessNotAllowed"), Objects.toString(request.getData("PointId"))) + " " + messageId);
                }
            } else {
                properties.put("Status", "Error: Access Not Allowed");
                log.warning(() -> String.format("Point not found: %s %s", Objects.toString(request.getData("PointId")), messageId));
            }
            ackProperties.put("CorrelationId", messageId);
            connector.sendMessage(ackResponse.encode(properties), ackResponse.getProperties(ackProperties)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(String.format("failed to read point values %s %s", err.getMessage(), messageId));
                } else {
                    log.fine("Read point values sent successfully " + messageId);
                }
            });
            log.info(String.format("Sentience point read completed with %s %s", properties.get("Status"), messageId));
        }
    }

    @Override
    public void handleMultiResponse(CloudDecodeMsg request, String messageId, Context cx) {
        BICloudConnector connector = this.cloudConnectorDevice.resolveConnector();
        if (CloudUtilities.canSendMessage(this.cloudConnectorDevice)) {
            ArrayList<CloudMultiPointData> list = new ArrayList<CloudMultiPointData>();
            JSONArray points = (JSONArray)request.getData("PointIds");
            boolean networkPointReadAllowed = true;
            if (!this.cloudConnectorDevice.getNiagaraCloudNetwork().getPointReadAllowed()) {
                log.warning(() -> String.format(LEX.getText("accessNotAllowed"), "network point read") + " " + messageId);
                networkPointReadAllowed = false;
            }
            for (int i = 0; i < points.length(); ++i) {
                String sentiencePointId = (String)points.get(i);
                BControlPoint pxPoint = CloudUtilities.getPoint(SlotPath.unescape((String)sentiencePointId));
                if (pxPoint != null && CloudUtilities.isPointReadAllowed(this.cloudConnectorDevice.getNiagaraCloudNetwork(), pxPoint, cx)) {
                    BStatusValue pointValue = CloudUtilities.cloudProxy(pxPoint).getPointValue();
                    String status = CloudUtilities.toStatusString(pointValue.getStatus());
                    String value = pointValue.getValueValue().toString();
                    list.add(new CloudMultiPointData(sentiencePointId, status, value));
                    continue;
                }
                list.add(new CloudMultiPointData(sentiencePointId, "Error: Access Not Allowed", null));
                if (!networkPointReadAllowed) continue;
                log.warning(() -> String.format(LEX.getText("accessNotAllowed"), sentiencePointId) + " " + messageId);
            }
            CloudEncodeMsg ackResponse = this.cloudConnectorDevice.getFactory().createMultiPointReadResponseMsg();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("PointValues", list);
            HashMap<String, Object> ackProperties = new HashMap<String, Object>();
            ackProperties.put("CorrelationId", messageId);
            connector.sendMessage(ackResponse.encode(properties), ackResponse.getProperties(ackProperties)).whenComplete((resp, err) -> {
                if (err != null) {
                    log.warning(String.format("failed to read point values %s %s", err.getMessage(), messageId));
                } else {
                    log.fine("Read point values successfully " + messageId);
                }
            });
            log.info(String.format("Sentience multi point read completed returning %d points %s", list.size(), messageId));
        }
    }
}

